/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import oracle.sysman.ccr.collector.cmd.AnonRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CSIRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.EmailRegistrationInfo;
import oracle.sysman.ccr.collector.countryCodes.CountryCode;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeException;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeMap;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;

public abstract class RegistrationInfo {
    static final int REGISTRATION_MODE_EMAIL = 0;
    static final int REGISTRATION_MODE_ANONYMOUS = 1;
    static final int REGISTRATION_MODE_CSI = 2;
    static final int REGISTRATION_MODE_UNKNOWN = -1;

    private static int getCountryCode(String string) throws CountryCodeException {
        CountryCodeMap countryCodeMap = null;
        countryCodeMap = CountryCodeMap.getInstance();
        CountryCode countryCode = countryCodeMap.getCountryCode(string);
        return countryCode.getValue();
    }

    public static RegistrationInfo getRegistrationInfo() throws CommandException {
        Config config = UplinkSystemConfig.getInstance();
        String string = config.getProperty("ccr.registration_mode");
        RegistrationInfo registrationInfo = null;
        if (string == null) {
            String string2 = config.getProperty("ccr.support_id");
            String string3 = config.getProperty("ccr.metalink_id");
            String string4 = config.getProperty("ccr.country_code");
            try {
                registrationInfo = CSIRegistrationInfo.authenticateAndPersist(string3, string2, string4);
            }
            catch (NetworkException networkException) {
                throw new CommandException(CollectorCmdMsgID.ERR_AUTHENTICATING_REGISTRATION, (Throwable)networkException);
            }
            catch (FileWriteException fileWriteException) {
                throw new CommandException(CollectorCmdMsgID.ERR_WRITING, (Throwable)fileWriteException);
            }
            catch (FileReadException fileReadException) {
                throw new CommandException(CollectorCmdMsgID.ERR_READING, (Throwable)fileReadException);
            }
        } else if (string.equals("csi")) {
            String string5 = config.getProperty("ccr.support_id");
            String string6 = config.getProperty("ccr.country_code");
            String string7 = config.getProperty("ccr.registration_ct");
            if (string5 != null && string6 != null && string7 != null) {
                try {
                    registrationInfo = new CSIRegistrationInfo(string5, RegistrationInfo.getCountryCode(string6), string7);
                }
                catch (CountryCodeException countryCodeException) {
                    throw new CommandException("Unable to retrieve CountryCode information.", (Throwable)countryCodeException);
                }
            }
        } else if (string.equals("email")) {
            String string8 = config.getProperty("ccr.metalink_email.address");
            String string9 = config.getProperty("ccr.registration_ct");
            registrationInfo = new EmailRegistrationInfo(string8, string9);
        } else if (string.equals("anon")) {
            String string10 = config.getProperty("ccr.metalink_email.address");
            registrationInfo = new AnonRegistrationInfo(string10);
        }
        return registrationInfo;
    }

    abstract void registerInstallation(OCMEndPoint var1, String var2, String var3, String var4) throws AuthenticationFailure, NetworkException;

    int registrationType() {
        return -1;
    }
}

