/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import HTTPClient.HTTPConnection;
import HTTPClient.URI;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.RegisterCmd;
import oracle.sysman.ccr.collector.cmd.TestCmdException;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;

public class TestCmd
extends CollectorCmd {
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$TestCmd != null ? class$oracle$sysman$ccr$collector$cmd$TestCmd : (class$oracle$sysman$ccr$collector$cmd$TestCmd = TestCmd.class$("oracle.sysman.ccr.collector.cmd.TestCmd")));
    static final String COMMAND = "test";
    private static final String TEST_URI = "/em/upload";
    private static final MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String REGISTER_QUALIFIER = "register";
    public static final String VERBOSE_QUALIFIER = "verbose";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$TestCmd;

    public TestCmd() {
    }

    public TestCmd(boolean bl) {
        super(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private OCMEndPoint connect(String string) throws TestCmdException {
        OCMEndPoint oCMEndPoint = null;
        try {
            oCMEndPoint = new OCMEndPoint(CollectorCmd.getEndpointAddr());
        }
        catch (CommandException commandException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_ADDR_ERR, false, (Object[])new String[]{string}), (Throwable)commandException);
        }
        catch (NetworkException networkException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_CONNECT_ERR, false, (Object[])new String[]{string}), (Throwable)networkException);
        }
        InputStream inputStream = null;
        try {
            try {
                if (CollectorCmd.getEndpointIsRepeater()) {
                    String string2 = oCMEndPoint.processRepeaterTestRequest();
                    System.out.println(string2);
                } else {
                    inputStream = oCMEndPoint.getFile(TEST_URI);
                }
            }
            catch (NetworkException networkException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.REQUEST_ERR, false), (Throwable)networkException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.TEST_URI_GET_ERR, false), (Throwable)fileNotFoundException);
            }
            catch (CommandException commandException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.REQUEST_ERR, false), (Throwable)commandException);
            }
            Object var5_10 = null;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return oCMEndPoint;
    }

    private void execute() throws CommandException {
        String string = "";
        if (CollectorCmd.getEndpointIsRepeater()) {
            string = "Repeater ";
        }
        URI uRI = null;
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.VERIFY_PROXY, false));
        this.verifyProxy();
        try {
            uRI = CollectorCmd.getEndpointUri();
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.CCR_SERVER, false, (Object[])new String[]{string, uRI.getHost()}));
        }
        catch (CommandException commandException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_ADDR_ERR, false, (Object[])new String[]{string}), (Throwable)commandException);
        }
        try {
            Config config = UplinkSystemConfig.getInstance();
            String string2 = config.getProperty("http.proxyHost");
            if (string2 == null) {
                System.out.println(s_bundle.getMessage(CollectorCmdMsgID.RESOLVE_SERVER_ADDR, false, (Object[])new String[]{string}));
                this.resolveAddr(uRI.getHost());
            } else {
                System.out.println(s_bundle.getMessage(CollectorCmdMsgID.SKIP_SERVER_ADDR_RESOLVE, false, (Object[])new String[]{string}));
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.SERVER_ADDR_LOOKUP_ERR, false, (Object[])new String[]{string}));
        }
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.CONNECT_SERVER, false, (Object[])new String[]{string}));
        this.connect(string);
        if (Collector.qualifierSpecified(REGISTER_QUALIFIER)) {
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.REGISTERING, false));
            new RegisterCmd().processRequest();
        }
    }

    public int processRequest() throws CommandException {
        UplinkSystemConfig.getInstance();
        if (Collector.qualifierSpecified(VERBOSE_QUALIFIER)) {
            System.setProperty("HTTPClient.log.mask", Integer.toString(-1));
        }
        this.execute();
        System.out.println();
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.CMD_SUCCESS, false));
        return 0;
    }

    private InetAddress resolveAddr(String string) throws TestCmdException, UnknownHostException {
        if (string == null) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.NO_HOSTNAME, false));
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (SecurityException securityException) {
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.NO_ADDR_LOOKUP_ALLOWED, false));
        }
        return inetAddress;
    }

    public String toString() {
        return COMMAND;
    }

    private void verifyProxy() throws TestCmdException {
        Object object;
        HTTPConnection hTTPConnection = null;
        boolean bl = false;
        try {
            bl = CollectorCmd.getEndpointIsRepeater();
        }
        catch (CommandException commandException) {
            throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.PROXY_ADDR_LOOKUP_ERR, false));
        }
        if (bl) {
            object = UplinkSystemConfig.getInstance();
            String string = ((Config)object).getProperty("ccr.endpoint", "https://ccr.oracle.com");
            try {
                hTTPConnection = new EndPoint(new URI(string)).getConnection();
            }
            catch (Exception exception) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.PROXY_ADDR_LOOKUP_ERR, false));
            }
        } else {
            hTTPConnection = new HTTPConnection("http://www.oracle.com");
        }
        object = hTTPConnection.getProxyHost();
        if (object != null) {
            int n = hTTPConnection.getProxyPort();
            System.out.println(s_bundle.getMessage(CollectorCmdMsgID.PROXY_SETTINGS, false, (Object[])new String[]{object, String.valueOf(n)}));
            try {
                this.resolveAddr((String)object);
            }
            catch (UnknownHostException unknownHostException) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.PROXY_ADDR_LOOKUP_ERR, false));
            }
            try {
                hTTPConnection.connect();
            }
            catch (Exception exception) {
                throw new TestCmdException(s_bundle.getMessage(CollectorCmdMsgID.NO_CONNECTIVITY, false), (Throwable)exception);
            }
        }
        System.out.println(s_bundle.getMessage(CollectorCmdMsgID.NO_PROXY, false));
    }
}

