/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.UpdateCommandException;
import oracle.sysman.ccr.collector.softwareMgr.Component;
import oracle.sysman.ccr.collector.softwareMgr.ComponentStateException;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareUpdateException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.NetworkException;

public class UpdateCmd
extends CollectorCmd {
    static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$UpdateCmd != null ? class$oracle$sysman$ccr$collector$cmd$UpdateCmd : (class$oracle$sysman$ccr$collector$cmd$UpdateCmd = UpdateCmd.class$("oracle.sysman.ccr.collector.cmd.UpdateCmd")));
    static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String COMMAND = "getupdates";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$UpdateCmd;

    public UpdateCmd() {
    }

    public UpdateCmd(boolean bl) {
        super(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int processRequest() throws CommandException {
        int n = 0;
        try {
            SoftwareMgr softwareMgr = SoftwareMgr.getInstance();
            Component[] componentArray = softwareMgr.getComponentDownloadList();
            if (componentArray.length > 0) {
                if (SoftwareMgr.autoUpdateEnabled() || this.cmdExplicitlyRequested()) {
                    if (softwareMgr.downloadUpdates(componentArray)) {
                        n = 5;
                    }
                } else {
                    String string = SoftwareMgr.formatComponentList(componentArray);
                    if (softwareMgr.containsMandatoryComponent(componentArray)) {
                        if (s_log.isEnabledFor(Logger.ERROR)) {
                            s_log.error(CollectorCmdMsgID.MANDATORY_PENDING_DOWNLOAD, new String[]{string});
                        }
                        String string2 = s_msgBundle.getMessage(CollectorCmdMsgID.MANDATORY_PENDING_DOWNLOAD, false, (Object[])new String[]{string});
                        throw new UpdateCommandException(string2);
                    }
                    if (s_log.isEnabledFor(Logger.WARN)) {
                        s_log.warn(CollectorCmdMsgID.DISABLED_PENDING_DOWNLOAD, new String[]{string});
                    }
                }
            }
        }
        catch (NetworkException networkException) {
            throw new UpdateCommandException(s_msgBundle.getMessage(CollectorCmdMsgID.UPDATE_COMM_FAILURE, false), (Throwable)networkException);
        }
        catch (SoftwareUpdateException softwareUpdateException) {
            throw new UpdateCommandException(s_msgBundle.getMessage(CollectorCmdMsgID.UPDATE_REQUEST_ERR, false), (Throwable)softwareUpdateException);
        }
        catch (ComponentStateException componentStateException) {
            throw new CommandException("Internal error encountered during component update", (Throwable)componentStateException);
        }
        catch (UpdateCommandException updateCommandException) {
            throw new UpdateCommandException("Unable to get product updates.", (Throwable)updateCommandException);
        }
        return n;
    }

    public String toString() {
        return COMMAND;
    }
}

