/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.UploadCommandException;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class UploadCmd
extends CollectorCmd {
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$UploadCmd != null ? class$oracle$sysman$ccr$collector$cmd$UploadCmd : (class$oracle$sysman$ccr$collector$cmd$UploadCmd = UploadCmd.class$("oracle.sysman.ccr.collector.cmd.UploadCmd")));
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.cmd.CollectorCmd");
    private static final String UPLOAD_URI = "/em/upload";
    public static final String COMMAND = "upload";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$UploadCmd;

    public UploadCmd() {
    }

    public UploadCmd(boolean bl) {
        super(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private OCMEndPoint connect(EndPointAddr endPointAddr) throws UploadCommandException {
        OCMEndPoint oCMEndPoint = null;
        try {
            oCMEndPoint = new OCMEndPoint(endPointAddr);
        }
        catch (NetworkException networkException) {
            throw new UploadCommandException("Unable to connect to Oracle Configuration Manager content receiver", (Throwable)networkException);
        }
        return oCMEndPoint;
    }

    private File getCollectionFilePath(String string) {
        return new File(FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, string}));
    }

    private File getGCCollectionFilePath(String string, String string2) {
        return new File(FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external", string2, string}));
    }

    private String[] getGCXMLFileNames(String string) {
        String[] stringArray = new String[]{};
        String string2 = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external", string});
        File file = new File(string2);
        if (file.exists()) {
            stringArray = file.list(new XMLFileFilter());
        }
        return stringArray;
    }

    private String[] getXMLFileNames() {
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new XMLFileFilter());
        return stringArray;
    }

    private boolean hasGCDir() {
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external"});
        File file = new File(string);
        return file.exists();
    }

    private void moveState(File file, File file2) {
        BufferedInputStream bufferedInputStream;
        block20: {
            bufferedInputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                block19: {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        bufferedInputStream = new BufferedInputStream(fileInputStream);
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        filterOutputStream = new BufferedOutputStream(fileOutputStream);
                        int n = 8192;
                        int n2 = 0;
                        byte[] byArray = new byte[8192];
                        while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                        }
                        bufferedInputStream.close();
                        bufferedInputStream = null;
                        if (!file.delete()) {
                            System.gc();
                            if (!file.delete()) {
                                file.deleteOnExit();
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (!Collector.silentMode()) {
                            System.err.println("Unable to save collection uploaded collection state");
                            System.err.println(fileNotFoundException.getMessage());
                        }
                    }
                    catch (IOException iOException) {
                        if (s_log.isEnabledFor(Logger.DEBUG)) {
                            s_log.error(CollectorCmdMsgID.STATE_COPY_ERR, iOException);
                        }
                        if (Collector.silentMode()) break block19;
                        System.err.println("Unable to save collection upload collection state.");
                        System.err.println(iOException.getMessage());
                    }
                }
                Object var6_12 = null;
                if (filterOutputStream == null) break block20;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                filterOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int processRequest() throws CommandException {
        Object object;
        try {
            this.preProcessRequest();
        }
        catch (AuthenticationFailure authenticationFailure) {
            throw new UploadCommandException("Unable to upload the collected configuration information.", (Throwable)authenticationFailure);
        }
        File file = null;
        String[] stringArray = this.getXMLFileNames();
        if (stringArray.length > 0 || this.hasGCDir()) {
            object = CollectorCmd.getEndpointAddr();
            OCMEndPoint oCMEndPoint = this.connect((EndPointAddr)object);
            SecurityMgr securityMgr = SecurityMgr.getInstance();
            String string = securityMgr.getAuthenticationKeyString();
            String string2 = securityMgr.getCustomerOrgId();
            String string3 = Hostname.getHostname();
            String string4 = Collector.getOracleHome();
            String string5 = Collector.getConfigHome();
            int n = 0;
            while (n < stringArray.length) {
                if (s_log.isEnabledFor(Logger.INFO)) {
                    s_log.info(CollectorCmdMsgID.UPLOADING_FILE, new String[]{stringArray[n]});
                }
                file = null;
                file = this.getCollectionFilePath(stringArray[n]);
                if (file != null) {
                    this.uploadXMLFile(oCMEndPoint, file, string, string2, string3, string4, string5);
                    this.replaceFullCollection(stringArray[n]);
                }
                ++n;
            }
            if (this.hasGCDir()) {
                int n2 = 0;
                while (n2 < 11) {
                    String string6 = String.valueOf(n2);
                    String[] stringArray2 = this.getGCXMLFileNames(string6);
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (s_log.isEnabledFor(Logger.INFO)) {
                            s_log.info(CollectorCmdMsgID.UPLOADING_FILE, new String[]{String.valueOf(stringArray2[n3]) + " (gc)"});
                        }
                        file = null;
                        file = this.getGCCollectionFilePath(stringArray2[n3], string6);
                        if (file != null) {
                            this.uploadXMLFile(oCMEndPoint, file, string, string2, string3, string4, string5);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        object = TargetManager.getInstance();
        ((TargetManager)object).clearTemporaryCollectionState();
        return 0;
    }

    private void replaceFullCollection(String string) {
        String string2 = string.substring(0, string.lastIndexOf(".xml"));
        File file = new File(FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH, String.valueOf(string2) + ".ser"}));
        File file2 = new File(FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, String.valueOf(string2) + ".ser"}));
        if (file2.exists()) {
            if (file.exists() && !file.delete()) {
                System.gc();
                file.delete();
            }
            this.moveState(file2, file);
        }
    }

    public String toString() {
        return COMMAND;
    }

    private void uploadXMLFile(OCMEndPoint oCMEndPoint, File file, String string, String string2, String string3, String string4, String string5) throws UploadCommandException {
        try {
            oCMEndPoint.sendContent(file, string, string2, string3, string4, string5);
            if (!file.delete()) {
                System.gc();
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
        catch (NetworkException networkException) {
            throw new UploadCommandException("Error encountered attempting to upload to Oracle Configuration Manager content receiver", (Throwable)networkException);
        }
    }

    class XMLFileFilter
    implements FilenameFilter {
        XMLFileFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl = true;
            int n = string.lastIndexOf(".");
            if (n != -1) {
                String string2 = string.substring(n);
                bl = string2.equals(".xml");
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

