/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Collection {
    private TreeMap m_configMetrics = new TreeMap();
    public static final String TAGNAME = "CollectionItem";
    public static final String ATTR_CONFIG = "CONFIG";
    public static final String ATTR_NAME = "NAME";
    private static final String ATTR_LEVEL = "LEVEL";
    private static final String ATTR_UPLOAD = "UPLOAD";
    private static final String ATTR_UPLOAD_ON_FETCH = "UPLOAD_ON_FETCH";
    private static final String ATTR_ATOMIC_UPLOAD = "ATOMIC_UPLOAD";
    private static final String ATTR_POSTLOAD_PROC = "POSTLOAD_PROC";
    private static final String ATTR_PRELOAD_PROC = "PRELOAD_PROC";
    private static final String ATTR_CONFIG_METADATA_VERSION = "CONFIG_METADATA_VERSION";
    private static final String ATTR_TIMEOUT = "TIMEOUT";
    private static final String ATTR_COLLECT_WHEN_DOWN = "COLLECT_WHEN_DOWN";
    private static final String ATTR_COLLECT_WHEN_ALTSKIP = "COLLECT_WHEN_ALTSKIP";
    private static final String ATTR_COMBINE_WITH_OTHER_COLLECTION = "COMBINE_WITH_OTHER_COLLECTION";
    private static final String ATTR_PROXY_TARGET_NAME = "PROXY_TARGET_NAME";
    private static final String ATTR_PROXY_TARGET_TYPE = "PROXY_TARGET_TYPE";
    private static final String ATTR_PROXY_TARGET_TZ = "PROXY_TARGET_TZ";
    private static final String ATTR_PROXY_TARGET_TZ_REGION = "PROXY_TARGET_TZ_REGION";
    private static final String ATTR_INITIAL_UPLOADS = "INITIAL_UPLOADS";
    private static final String ATTR_DISABLED = "DISABLED";
    private static final String ATTR_REQUIRED = "REQUIRED";
    private String m_strCollectionName = null;
    private String m_strLevel = "";
    private String m_strUpload = "";
    private boolean m_bUploadOnFetch = false;
    private boolean m_bAtomicUpload = false;
    private String m_strPostloadProc = "";
    private String m_strPreloadProc = "";
    private boolean m_bConfig = false;
    private String m_strConfigMetdataVersion = "";
    private String m_strTimeout = "";
    private boolean m_bCollectWhenDown = false;
    private boolean m_bCollectWhenAltSkip = false;
    private boolean m_bCombineCollections = false;
    private String m_strProxyTargetName = "";
    private String m_strProxyTargetType = "";
    private String m_strProxyTargetTz = "";
    private String m_strProxyTargetTzRegion = "";
    private String m_strInitialUploads = "";
    private boolean m_bDisabled = false;
    private boolean m_bRequired = false;
    private static final String METRIC_COL = "MetricColl";

    public Collection(String string) {
        this.m_strCollectionName = string;
    }

    public Collection(Element element) throws SAXException {
        this.setName(element);
        this.m_strLevel = this.getAttr(element, ATTR_LEVEL, "");
        this.m_strUpload = this.getAttr(element, ATTR_UPLOAD, "");
        this.m_bUploadOnFetch = this.getAttr(element, ATTR_UPLOAD_ON_FETCH, false);
        this.m_bAtomicUpload = this.getAttr(element, ATTR_ATOMIC_UPLOAD, false);
        this.m_strPostloadProc = this.getAttr(element, ATTR_POSTLOAD_PROC, "");
        this.m_strPreloadProc = this.getAttr(element, ATTR_PRELOAD_PROC, "");
        this.m_bConfig = this.getAttr(element, ATTR_CONFIG, false);
        this.m_strConfigMetdataVersion = this.getAttr(element, ATTR_CONFIG_METADATA_VERSION, "");
        this.m_strTimeout = this.getAttr(element, ATTR_TIMEOUT, "");
        this.m_bCollectWhenDown = this.getAttr(element, ATTR_COLLECT_WHEN_DOWN, false);
        this.m_bCollectWhenAltSkip = this.getAttr(element, ATTR_COLLECT_WHEN_ALTSKIP, false);
        this.m_bCombineCollections = this.getAttr(element, ATTR_COMBINE_WITH_OTHER_COLLECTION, false);
        this.m_strProxyTargetName = this.getAttr(element, ATTR_PROXY_TARGET_NAME, "");
        this.m_strProxyTargetType = this.getAttr(element, ATTR_PROXY_TARGET_TYPE, "");
        this.m_strProxyTargetTz = this.getAttr(element, ATTR_PROXY_TARGET_TZ, "");
        this.m_strProxyTargetTzRegion = this.getAttr(element, ATTR_PROXY_TARGET_TZ_REGION, "");
        this.m_strInitialUploads = this.getAttr(element, ATTR_INITIAL_UPLOADS, "");
        this.m_bDisabled = this.getAttr(element, ATTR_DISABLED, false);
        this.m_bRequired = this.getAttr(element, ATTR_REQUIRED, false);
        this.getCollectionMetrics(element);
    }

    public void addMetric(String string) {
        this.m_configMetrics.put(string, null);
    }

    private String getAttr(Element element, String string, String string2) {
        String string3 = string2;
        if (element.hasAttribute(string)) {
            string3 = element.getAttribute(string);
        }
        return string3;
    }

    private boolean getAttr(Element element, String string, boolean bl) {
        boolean bl2 = bl;
        if (element.hasAttribute(string)) {
            String string2 = element.getAttribute(string);
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    private void getCollectionMetrics(Element element) throws SAXException {
        this.addMetric(this.getCollectionName());
        NodeList nodeList = element.getElementsByTagName(METRIC_COL);
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                Element element2 = (Element)nodeList.item(n);
                if (element2.hasAttribute(ATTR_NAME)) {
                    this.addMetric(element2.getAttribute(ATTR_NAME));
                } else {
                    throw new SAXException("MetricCol is missing the metricName in collection " + this.m_strCollectionName);
                }
            }
            ++n;
        }
    }

    public String getCollectionName() {
        return this.m_strCollectionName;
    }

    public Vector getMetrics() {
        Vector<String> vector = new Vector<String>();
        Set set = this.m_configMetrics.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            vector.add((String)iterator.next());
        }
        return vector;
    }

    private String getName() {
        return this.m_strCollectionName;
    }

    private void setName(Element element) throws SAXException {
        if (!element.hasAttribute(ATTR_NAME)) {
            throw new SAXException("Name is missing from the Collection");
        }
        this.m_strCollectionName = element.getAttribute(ATTR_NAME);
    }
}

