/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.collectionMgr.Collection;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CollectionList
extends Vector {
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$collectionMgr$CollectionList != null ? class$oracle$sysman$ccr$collector$collectionMgr$CollectionList : (class$oracle$sysman$ccr$collector$collectionMgr$CollectionList = CollectionList.class$("oracle.sysman.ccr.collector.collectionMgr.CollectionList")));
    private String m_strTargetType;
    private String m_strName;
    private String m_strLevel;
    private static String m_strSystemId = null;
    public static final String TAGNAME = "TargetCollection";
    public static final String ATTR_NAME = "NAME";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$CollectionList;

    public CollectionList(String string) throws SAXException, FileNotFoundException {
        this.m_strTargetType = string;
        Document document = this.parseCollection();
        Element element = this.getRootElement(document);
        this.getCollectionItems(element);
    }

    private void addCollection(Collection collection) {
        this.add(collection);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void getCollectionItems(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName("CollectionItem");
        CollectionMgr collectionMgr = CollectionMgr.getInstance();
        String string = null;
        boolean bl = false;
        String string2 = null;
        try {
            string2 = collectionMgr.getCollectionTargetType();
            if (string2 != null && this.m_strTargetType.equals(string2)) {
                string = collectionMgr.getCollectionItem();
            }
        }
        catch (CommandException commandException) {
            throw new SAXException(commandException.getMessage());
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            String string3;
            Element element2;
            if (nodeList.item(n).getNodeType() == 1 && (element2 = (Element)nodeList.item(n)).hasAttribute("CONFIG") && Boolean.valueOf(string3 = element2.getAttribute("CONFIG")).booleanValue()) {
                if (string != null) {
                    String string4 = element2.getAttribute(ATTR_NAME);
                    if (string.equals(string4)) {
                        this.addCollection(new Collection(element2));
                        bl = true;
                        break;
                    }
                } else {
                    this.addCollection(new Collection(element2));
                }
            }
            ++n;
        }
        if (string != null && !bl) {
            throw new SAXException("CollectionItem " + string + " not found in default collection for type " + this.m_strTargetType);
        }
    }

    private Element getRootElement(Document document) throws SAXException {
        Element element = null;
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength() && element == null) {
            Element element2;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNodeName().equals(TAGNAME) && !(element2 = (Element)node).hasAttribute(ATTR_NAME)) {
                element = element2;
            }
            ++n;
        }
        if (element == null) {
            throw new SAXException("TargetCollection root element for default collection for type " + this.m_strTargetType + " not found.");
        }
        return element;
    }

    private String getSystemId() throws SAXException {
        if (m_strSystemId == null) {
            Class clazz = class$oracle$sysman$ccr$collector$collectionMgr$CollectionList != null ? class$oracle$sysman$ccr$collector$collectionMgr$CollectionList : (class$oracle$sysman$ccr$collector$collectionMgr$CollectionList = CollectionList.class$("oracle.sysman.ccr.collector.collectionMgr.CollectionList"));
            synchronized (clazz) {
                if (m_strSystemId == null) {
                    try {
                        String[] stringArray = new String[]{Collector.getOracleHome(), UplinkPath.DEFAULT_COLLECTION_PATH};
                        File file = new File(FileSpec.catfile(stringArray));
                        m_strSystemId = file.toURL().toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SAXException("Error in constructing URL for metadata SystemID\n" + malformedURLException.getMessage());
                    }
                }
            }
        }
        return m_strSystemId;
    }

    private Document parseCollection() throws SAXException, FileNotFoundException {
        File file = new File(FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.DEFAULT_COLLECTION_PATH, String.valueOf(this.m_strTargetType) + ".xml"}));
        Document document = null;
        try {
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug("Parsing default collection file for " + this.m_strTargetType);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId(this.getSystemId());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (SAXException sAXException) {
            throw new SAXException("Default Collection parser failure\n" + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new SAXException("IO Error parsing default collection for " + this.m_strTargetType + "\n" + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Problem with configuring parser for defaultCollection for " + this.m_strTargetType + "\n" + parserConfigurationException.getMessage());
        }
        return document;
    }
}

