/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectCommandException;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.collectionMgr.Collection;
import oracle.sysman.ccr.collector.collectionMgr.CollectionList;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgrMsgID;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.collectionMgr.XMLReviewWriter;
import oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.SAXException;

public class CollectionMgr {
    private static CollectionMgr s_instance = null;
    private HashMap m_hashConfigCollectionList = null;
    private Logger m_log = Logger.getInstance(class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr != null ? class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr : (class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr = CollectionMgr.class$("oracle.sysman.ccr.collector.collectionMgr.CollectionMgr")));
    private MessageBundle m_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.collectionMgr.CollectionMgr");
    private final String REVIEW_TARGETS_XSL_FORMAT = "<?xml-stylesheet type=\"text/xsl\" href=\"{0}/ccr/admin/xsl/preview_targets.xsl\"?>";
    private static String s_strUploadPath = null;
    private static SimpleDateFormat m_dateFormat;
    private static final String UPLOADFILE_QUALIFIER = "uploadfile";
    private String m_uploadFile = null;
    private int m_uploadFileCounter = 1;
    private static final String TARGET_COLLECTION_QUALIFIER = "collection";
    private static final String TARGET_COLLECTION_QUALIFIER_USAGE = "\nUsage: -collection=<target_name>,<target_type>[,<collection>]";
    private static final int TARGET_COLLECTION_MIN_ARGS = 2;
    private static final int TARGET_COLLECTION_MAX_ARGS = 3;
    private static final int TARGET_COLLECTION_TARGET_NAME = 0;
    private static final int TARGET_COLLECTION_TARGET_TYPE = 1;
    private static final int TARGET_COLLECTION_COLLECTION_ITEM = 2;
    private boolean m_bCollectionQualifierParsed = false;
    private Target m_collectionTarget = null;
    private String m_collectionTargetName = null;
    private String m_collectionTargetType = null;
    private String m_collectionItem = null;
    private static String XMLPATTERN;
    private static RE m_collectionSplitPattern;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr;

    static {
        s_strUploadPath = UplinkPath.gridAgentMode() ? FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH}) : FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_UPLOAD_PATH});
        m_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        XMLPATTERN = ",";
        try {
            m_collectionSplitPattern = new RE(",");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException("Invalid regular expression, " + XMLPATTERN);
        }
    }

    private CollectionMgr() {
        this.m_hashConfigCollectionList = new HashMap();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearCollectionReviewFiles() {
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_REVIEW_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new CollectionFileFilter());
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(FileSpec.catfile(new String[]{string, stringArray[n]}));
            file2.delete();
            ++n;
        }
    }

    public void clearCollectionState() {
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new CollectionStateFilter());
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(FileSpec.catfile(new String[]{string, stringArray[n]}));
            file2.delete();
            ++n;
        }
    }

    public void clearCollectionUpload() {
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH});
        File file = new File(string);
        String[] stringArray = file.list(new CollectionFileFilter());
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(FileSpec.catfile(new String[]{string, stringArray[n]}));
            file2.delete();
            ++n;
        }
    }

    public void clearGCCollectionUpload() {
        int n = 0;
        while (n < 11) {
            String[] stringArray;
            String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_UPLOAD_PATH, "external", String.valueOf(n)});
            File file = new File(string);
            if (file.exists() && (stringArray = file.list(new CollectionFileFilter())) != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    File file2 = new File(FileSpec.catfile(new String[]{string, stringArray[n2]}));
                    if (file2.exists() && !file2.delete()) {
                        System.gc();
                        if (!file2.delete()) {
                            file2.deleteOnExit();
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void closeTargetMap(PrintWriter printWriter) {
        block4: {
            try {
                if (printWriter == null) break block4;
                printWriter.println("</Targets>");
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (printWriter != null) {
            printWriter.close();
        }
    }

    public void collectConfigMetricData() throws CommandException {
        TargetManager targetManager = TargetManager.getInstance();
        String[] stringArray = null;
        String string = this.getCollectionTargetType();
        stringArray = string != null ? new String[]{string} : targetManager.getTargetTypes();
        PrintWriter printWriter = null;
        if (!UplinkPath.gridAgentMode()) {
            printWriter = this.openTargetMap();
        }
        try {
            if (UplinkPath.gridAgentMode()) {
                CommandQualifier commandQualifier = Collector.getQualifier(UPLOADFILE_QUALIFIER);
                if (commandQualifier == null) {
                    throw new CommandException("Mandatory qualifier -uploadfile missing for Grid Agent installation");
                }
                this.m_uploadFile = commandQualifier.getQualifierValue();
                this.m_uploadFileCounter = 1;
            }
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                TargetMetadata targetMetadata = targetManager.getTargetMetadata(string2);
                CollectionList collectionList = (CollectionList)this.m_hashConfigCollectionList.get(string2);
                if (collectionList != null && targetMetadata != null && targetMetadata.supportsConfigMetrics()) {
                    this.collectConfigMetricData(string2, printWriter);
                }
                ++n;
            }
        }
        finally {
            Object var6_10 = null;
            this.closeTargetMap(printWriter);
        }
    }

    private void collectConfigMetricData(String string, PrintWriter printWriter) throws CommandException {
        TargetManager targetManager = TargetManager.getInstance();
        Target[] targetArray = null;
        Target target = this.getCollectionTarget();
        targetArray = target != null ? new Target[]{target} : targetManager.getTargetInstances(string);
        try {
            int n = 0;
            while (n < targetArray.length) {
                Target target2 = targetArray[n];
                if (!target2.isDisabled()) {
                    this.collectConfigMetricData(target2, printWriter);
                }
                ++n;
            }
        }
        catch (SAXException sAXException) {
            throw new CommandException("Unable to collect metric data", (Throwable)sAXException);
        }
    }

    private void collectConfigMetricData(Target target, PrintWriter printWriter) throws CollectCommandException, SAXException {
        String string = target.getTargetType();
        TargetManager targetManager = TargetManager.getInstance();
        TargetMetadata targetMetadata = targetManager.getTargetMetadata(string);
        CollectionList collectionList = this.getCollectionList(target.getTargetType());
        Iterator iterator = ((AbstractList)collectionList).iterator();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            CollectionResultList collectionResultList = new CollectionResultList(target, collection.getCollectionName(), targetMetadata.getMetadataVersion());
            Vector vector = collection.getMetrics();
            Iterator iterator2 = ((AbstractList)vector).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                Metric metric = targetMetadata.getMetric(string2, target);
                if (metric != null) {
                    if (this.m_log.isEnabledFor(Logger.INFO)) {
                        this.m_log.info(CollectionMgrMsgID.PROCESSING_METRIC, new String[]{string2, target.getTargetName(), target.getTargetType()});
                    }
                    MetricResult metricResult = null;
                    try {
                        metricResult = metric.collect(target);
                        CollectionResult collectionResult = new CollectionResult(string2, metric.isIncremental(), metric.isCmdbFormat(), metric.getTblDesc(), metricResult);
                        collectionResultList.put(string2, collectionResult);
                    }
                    catch (FetchletException fetchletException) {
                        CollectCommandException collectCommandException = new CollectCommandException("Error in processing " + metric.getMetricId() + " metric collection for " + target.getTargetName(), (Throwable)fetchletException);
                        if (Collector.failOnError()) {
                            throw collectCommandException;
                        }
                        Collector.logExceptionChainToStderr(collectCommandException);
                    }
                    continue;
                }
                if (collection.getCollectionName().equals(string2)) continue;
                this.m_log.debug(this.m_bundle.getMessage(CollectionMgrMsgID.COLLECTION_METADATA_MISMATCH, false, (Object[])new String[]{collection.getCollectionName(), string, string2}));
            }
            if (!UplinkPath.gridAgentMode()) {
                this.persistReviewFile(collectionResultList, printWriter);
            }
            this.persistCollectionForUpload(collectionResultList);
        }
    }

    private boolean filterCollection(CollectionResultList collectionResultList) {
        String string = CollectionResultList.getSerializedObjectFilename(collectionResultList.getTargetInstance(), collectionResultList.getCollectionName());
        String string2 = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_PREVIOUS_PATH, string});
        try {
            Object object;
            Vector<String> vector = new Vector<String>();
            CollectionResultList collectionResultList2 = CollectionResultList.inflate(string2);
            if (!collectionResultList2.getMetadataVersion().equals(collectionResultList.getMetadataVersion())) {
                return false;
            }
            Set set = collectionResultList.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                object = collectionResultList.getResult(string3);
                CollectionResult collectionResult = null;
                collectionResult = collectionResultList2.getResult(string3);
                if (collectionResult == null) continue;
                if (((CollectionResult)object).equals(collectionResult)) {
                    vector.add(string3);
                    continue;
                }
                if (!((CollectionResult)object).isIncrementalMetric()) continue;
                ((CollectionResult)object).diffRows(collectionResult);
            }
            int n = 0;
            while (n < vector.size()) {
                object = (String)vector.get(n);
                collectionResultList.remove(object);
                ++n;
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.m_log.isEnabledFor(Logger.DEBUG)) {
                Target target = collectionResultList.getTargetInstance();
                this.m_log.debug("Previous state file (" + string2 + ") does not exist for target (" + target.getTargetName() + "," + target.getTargetType() + ") and collection (" + collectionResultList.getCollectionName() + ")");
            }
            return false;
        }
        catch (IOException iOException) {
            if (this.m_log.isEnabledFor(Logger.WARN)) {
                Target target = collectionResultList.getTargetInstance();
                this.m_log.warn(CollectionMgrMsgID.COLLECTION_INFLATION_ERR, new String[]{target.getTargetName(), target.getTargetType(), collectionResultList.getCollectionName()});
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.m_log.isEnabledFor(Logger.DEBUG)) {
                Target target = collectionResultList.getTargetInstance();
                this.m_log.debug("unable to re-instantiate the previous state file (" + string2 + ") for target (" + target.getTargetName() + "," + target.getTargetType() + ") and collection (" + collectionResultList.getCollectionName() + ")");
            }
            return false;
        }
    }

    public String getCollectionItem() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionItem;
    }

    private CollectionList getCollectionList(String string) {
        return (CollectionList)this.m_hashConfigCollectionList.get(string);
    }

    private Target getCollectionTarget() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionTarget;
    }

    private String getCollectionTargetName() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionTargetName;
    }

    public String getCollectionTargetType() throws CommandException {
        this.parseCollectionQualifier();
        return this.m_collectionTargetType;
    }

    private CollectionList getConfigCollections(String string) throws SAXException {
        CollectionList collectionList = null;
        try {
            collectionList = new CollectionList(string);
            if (collectionList.size() == 0) {
                collectionList = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            collectionList = null;
        }
        return collectionList;
    }

    public static CollectionMgr getInstance() {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr != null ? class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr : (class$oracle$sysman$ccr$collector$collectionMgr$CollectionMgr = CollectionMgr.class$("oracle.sysman.ccr.collector.collectionMgr.CollectionMgr"));
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new CollectionMgr();
                }
            }
        }
        return s_instance;
    }

    public static boolean isGCUploaded(Target target, String string) {
        String string2 = String.valueOf(CollectionResultList.getObjectBaseFilename(target, string)) + ".xml";
        String string3 = CollectionResultList.getObjectBaseSubDir(target.getGUID());
        String string4 = FileSpec.catfile(new String[]{s_strUploadPath, "external", string3, string2});
        File file = new File(string4);
        return !file.exists();
    }

    private PrintWriter openTargetMap() throws CollectCommandException {
        File file = new File(FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_REVIEW_PATH, "targetMap.xml"}));
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(MessageFormat.format("<?xml-stylesheet type=\"text/xsl\" href=\"{0}/ccr/admin/xsl/preview_targets.xsl\"?>", Collector.getOracleHome()));
            printWriter.println("<Targets collection_time=\"" + m_dateFormat.format(new Date()) + "\" host_name=\"" + Hostname.getHostname() + "\">");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CollectCommandException("Unable to open target Map", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CollectCommandException("Unable to write to targetMap file", (Throwable)iOException);
        }
        return printWriter;
    }

    private void parseCollectionQualifier() throws CommandException {
        if (this.m_bCollectionQualifierParsed) {
            return;
        }
        this.m_bCollectionQualifierParsed = true;
        if (Collector.qualifierSpecified(TARGET_COLLECTION_QUALIFIER)) {
            CommandQualifier commandQualifier = Collector.getQualifier(TARGET_COLLECTION_QUALIFIER);
            String string = null;
            if (commandQualifier != null && (string = commandQualifier.getQualifierValue()) != null) {
                String[] stringArray = m_collectionSplitPattern.split(string);
                if (stringArray.length < 2 || stringArray.length > 3 || stringArray[0] == null || stringArray[1] == null) {
                    throw new CommandException("Error parsing -collection=" + string + TARGET_COLLECTION_QUALIFIER_USAGE);
                }
                this.m_collectionTargetName = stringArray[0].trim();
                this.m_collectionTargetType = stringArray[1].trim();
                if (stringArray.length == 3 && stringArray[2] != null) {
                    this.m_collectionItem = stringArray[2].trim();
                }
                TargetManager targetManager = TargetManager.getInstance();
                this.m_collectionTarget = targetManager.getTargetByNameType(this.m_collectionTargetName, this.m_collectionTargetType);
                if (this.m_collectionTarget == null) {
                    throw new CommandException("Unknown target specified in -collection=" + string + TARGET_COLLECTION_QUALIFIER_USAGE);
                }
            }
        }
    }

    public void persistCollectionForGCUpload(CollectionResultList collectionResultList, boolean bl) throws CollectCommandException {
        this.persistGCUploadFile(collectionResultList, bl ^ true);
    }

    private void persistCollectionForUpload(CollectionResultList collectionResultList) throws CollectCommandException {
        String string = null;
        String string2 = null;
        if (UplinkPath.gridAgentMode()) {
            string2 = string = String.valueOf(this.m_uploadFile) + "0." + Integer.toString(this.m_uploadFileCounter++);
        } else {
            string = String.valueOf(collectionResultList.getObjectBaseFilename()) + ".xml";
            string2 = FileSpec.catfile(new String[]{s_strUploadPath, string});
        }
        this.persistCollectionForUpload(collectionResultList, string2, true, false);
    }

    private void persistCollectionForUpload(CollectionResultList collectionResultList, String string, boolean bl, boolean bl2) throws CollectCommandException {
        boolean bl3 = bl;
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("*** Writing out the file (" + string + ") for upload ***");
        }
        try {
            if (!bl2) {
                collectionResultList.deflate(s_strUploadPath);
                bl3 = this.filterCollection(collectionResultList);
            }
            XMLUploadWriter xMLUploadWriter = new XMLUploadWriter(string, collectionResultList, bl3, bl2);
            xMLUploadWriter.write();
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug("*** Completed writing out upload file ***");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CollectCommandException("Unable to open state directory for writing", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CollectCommandException("Error writting upload file " + string, (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new CollectCommandException("Error writing CMDB Instance Data to upload file " + string, (Throwable)sAXException);
        }
    }

    private void persistGCUploadFile(CollectionResultList collectionResultList, boolean bl) throws CollectCommandException {
        String string = FileSpec.catfile(new String[]{s_strUploadPath, "external", collectionResultList.getObjectBaseSubDir(), String.valueOf(collectionResultList.getObjectBaseFilename()) + ".xml"});
        String string2 = FileSpec.catfile(new String[]{s_strUploadPath, "external", collectionResultList.getObjectBaseSubDir(), String.valueOf(collectionResultList.getObjectBaseFilename()) + ".inprocess"});
        this.persistCollectionForUpload(collectionResultList, string2, bl, true);
        File file = new File(string2);
        File file2 = new File(string);
        boolean bl2 = false;
        if (!file2.exists()) {
            bl2 = file.renameTo(file2);
        }
        if (!bl2) {
            if (!file.delete()) {
                System.gc();
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            throw new CollectCommandException("Upload file( " + string + " ) not generated as it is already present.");
        }
    }

    private String persistReviewFile(CollectionResultList collectionResultList) throws CollectCommandException {
        String string = String.valueOf(collectionResultList.getObjectBaseFilename()) + ".xml";
        String string2 = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_REVIEW_PATH, string});
        this.persistReviewFile(collectionResultList, string2, false, false);
        return string;
    }

    private void persistReviewFile(CollectionResultList collectionResultList, PrintWriter printWriter) throws CollectCommandException {
        String string = "  <Target name=\"{0}\" type=\"{1}\">\n    <Collection name=\"{2}\" file=\"{3}\" collection_timestamp=\"{4}\"/>\n  </Target>";
        TargetManager targetManager = TargetManager.getInstance();
        Target target = collectionResultList.getTargetInstance();
        String string2 = target.getTargetType();
        TargetMetadata targetMetadata = targetManager.getTargetMetadata(string2);
        String string3 = this.persistReviewFile(collectionResultList);
        String string4 = MessageFormat.format("  <Target name=\"{0}\" type=\"{1}\">\n    <Collection name=\"{2}\" file=\"{3}\" collection_timestamp=\"{4}\"/>\n  </Target>", target.getTargetName(), targetMetadata.getTypeDisplayString(), collectionResultList.getCollectionName(), string3, collectionResultList.getCollectionTSwTZ());
        printWriter.println(string4);
    }

    private void persistReviewFile(CollectionResultList collectionResultList, String string, boolean bl, boolean bl2) throws CollectCommandException {
        XMLReviewWriter xMLReviewWriter = null;
        try {
            xMLReviewWriter = new XMLReviewWriter(string, collectionResultList, bl, bl2);
            xMLReviewWriter.write();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CollectCommandException("Unable to open state directory for writing", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CollectCommandException("Error writting review file " + string, (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new CollectCommandException("Error writting review file " + string, (Throwable)sAXException);
        }
    }

    public void processCollections() throws CommandException {
        TargetManager targetManager = TargetManager.getInstance();
        String[] stringArray = targetManager.getTargetTypes();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            CollectionList collectionList = null;
            try {
                collectionList = this.getConfigCollections(string);
            }
            catch (SAXException sAXException) {
                throw new CommandException("Unable to process the default collection for " + string, (Throwable)sAXException);
            }
            if (collectionList != null) {
                this.m_hashConfigCollectionList.put(string, collectionList);
            }
            ++n;
        }
    }

    class CollectionStateFilter
    implements FilenameFilter {
        CollectionStateFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl = true;
            int n = string.lastIndexOf(".");
            if (n != -1) {
                String string2 = string.substring(n);
                bl = string2.equals(".ser");
            } else {
                bl = false;
            }
            return bl;
        }
    }

    class CollectionFileFilter
    implements FilenameFilter {
        CollectionFileFilter() {
        }

        public boolean accept(File file, String string) {
            String string2;
            boolean bl = true;
            int n = string.lastIndexOf(".");
            bl = n != -1 ? (string2 = string.substring(n)).equals(".ser") || string2.equals(".xml") : false;
            return bl;
        }
    }
}

