/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.util.FileSpec;

public class CollectionResultList
extends HashMap
implements Serializable {
    private static final long serialVersionUID = 3757688827981178926L;
    private Target m_targetInstance = null;
    private String m_strCollectionName = null;
    private String m_strMetadataVersion = null;
    private transient Date m_dateCollection = new Date();
    private static final String SERIALIZED_EXTENSION = ".ser";
    private static final transient SimpleDateFormat s_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public CollectionResultList(Target target, String string, String string2) {
        this.m_targetInstance = target;
        this.m_strCollectionName = string;
        this.m_strMetadataVersion = string2;
    }

    void deflate(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = null;
        File file = new File(FileSpec.catfile(new String[]{string, CollectionResultList.getSerializedObjectFilename(this.m_targetInstance, this.m_strCollectionName)}));
        try {
            fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var5_5 = null;
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getCollectionName() {
        return this.m_strCollectionName;
    }

    public String getCollectionTSwTZ() {
        String string = s_dateFormat.format(this.getCollectionTimestamp());
        return String.valueOf(string) + " " + this.m_targetInstance.getTimeZone();
    }

    public Date getCollectionTimestamp() {
        Date date = this.m_targetInstance.getCollectionTimestampOverride();
        if (date == null) {
            date = this.m_dateCollection;
        }
        return date;
    }

    public String getMetadataVersion() {
        return this.m_strMetadataVersion;
    }

    public String getObjectBaseFilename() {
        return CollectionResultList.getObjectBaseFilename(this.m_targetInstance, this.m_strCollectionName);
    }

    public static String getObjectBaseFilename(Target target, String string) {
        StringBuffer stringBuffer = new StringBuffer(target.getGUID()).append("-").append(string);
        return stringBuffer.toString();
    }

    public String getObjectBaseSubDir() {
        return CollectionResultList.getObjectBaseSubDir(this.m_targetInstance.getGUID());
    }

    public static String getObjectBaseSubDir(String string) {
        BigInteger bigInteger = new BigInteger(string, 16);
        BigInteger bigInteger2 = bigInteger.remainder(new BigInteger("11"));
        return bigInteger2.toString();
    }

    public CollectionResult getResult(String string) {
        return (CollectionResult)this.get(string);
    }

    public static String getSerializedObjectFilename(Target target, String string) {
        return String.valueOf(CollectionResultList.getObjectBaseFilename(target, string)) + SERIALIZED_EXTENSION;
    }

    public Target getTargetInstance() {
        return this.m_targetInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CollectionResultList inflate(String string) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fileInputStream = null;
        CollectionResultList collectionResultList = null;
        try {
            try {
                File file = new File(string);
                fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                collectionResultList = (CollectionResultList)objectInputStream.readObject();
            }
            catch (StreamCorruptedException streamCorruptedException) {
                streamCorruptedException.printStackTrace();
            }
            catch (OptionalDataException optionalDataException) {
                optionalDataException.printStackTrace();
            }
            Object var4_7 = null;
            if (fileInputStream == null) return collectionResultList;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
            return collectionResultList;
        }
        catch (IOException iOException) {}
        return collectionResultList;
    }
}

