/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.collectionMgr;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgrMsgID;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.collectionMgr.TargetMapper;
import oracle.sysman.ccr.collector.collectionMgr.UploadTags;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.CmdbInstanceDataParser;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.GUID;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.Instance;
import oracle.sysman.ccr.collector.collectionMgr.cmdb.Instances;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.MetricValue;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.security.AnonAuthenticationKey;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.AuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIAuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIV2AuthenticationKey;
import oracle.sysman.ccr.collector.security.EmailAuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.collector.targets.metadata.CCRMetadataVer;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.collector.timezone.Timezone;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.ccr.util.XMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUploadWriter
implements UploadTags {
    private boolean m_bCollectorFiltered = true;
    private boolean m_isGC = false;
    private CollectionResultList m_resultMap = null;
    private OutputStreamWriter m_printWriter = null;
    private static final Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter != null ? class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter : (class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter = XMLUploadWriter.class$("oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter")));
    private static SimpleDateFormat s_dateFormat = null;
    private static String XMLPATTERN = "[&<>'\"]";
    private static Locale s_locale = Locale.US;
    public static final String ADHOC_COLLECTION_PROTOCOL_VERSION = "11.0.0.0.0";
    private static String s_protocolVersion;
    private static boolean s_protocolVersionSet;
    private static final String ASSOCIATED_TARGETS_TABLE = "MGMT_TARGETS";
    private static final String UNASSOCIATED_TARGETS_TABLE = "MGMT_VAGUE_TARGETS";
    private static String m_emdUrl;
    static final String DATE_VAR = "%DATE%";
    private static final String EMD_URL_QUALIFIER = "emdurl";
    private HashMap m_longText = new HashMap();
    private ArrayList m_cmdbInstanceTypes = new ArrayList();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter;

    static {
        s_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        s_protocolVersion = null;
        s_protocolVersionSet = false;
        m_emdUrl = null;
    }

    private XMLUploadWriter(OutputStreamWriter outputStreamWriter, CollectionResultList collectionResultList) {
        this.m_resultMap = collectionResultList;
        this.m_bCollectorFiltered = false;
        this.m_isGC = false;
        this.m_printWriter = outputStreamWriter;
    }

    protected XMLUploadWriter(String string, CollectionResultList collectionResultList) throws FileNotFoundException, IOException {
        this.init(string, collectionResultList, false, false);
    }

    public XMLUploadWriter(String string, CollectionResultList collectionResultList, boolean bl) throws FileNotFoundException, IOException {
        this.init(string, collectionResultList, bl, false);
    }

    public XMLUploadWriter(String string, CollectionResultList collectionResultList, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        this.init(string, collectionResultList, bl, bl2);
    }

    private String beginRow() {
        return "  <ROW>\n";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void collectCmdbInstanceData(CollectionResult collectionResult, String string) {
        MetricResult metricResult = collectionResult.getCollectionResult();
        if (metricResult == null) {
            return;
        }
        MetricValue metricValue = metricResult.getValue();
        if (metricValue == null) {
            return;
        }
        String string2 = metricValue.getContents();
        CmdbInstanceDataParser cmdbInstanceDataParser = new CmdbInstanceDataParser(string2, string);
        try {
            cmdbInstanceDataParser.parseInstanceData();
            this.m_cmdbInstanceTypes.add(cmdbInstanceDataParser.getInstanceTypes());
        }
        catch (SAXException sAXException) {
            Target target = this.m_resultMap.getTargetInstance();
            s_log.error(CollectionMgrMsgID.ERROR_PARSING_CMDB_INSTANCE_DATA, new String[]{collectionResult.getMetricCollectionName(), target.getTargetName(), target.getTargetType(), sAXException.getMessage()});
        }
        catch (IOException iOException) {
            Target target = this.m_resultMap.getTargetInstance();
            s_log.error(CollectionMgrMsgID.ERROR_PARSING_CMDB_INSTANCE_DATA, new String[]{collectionResult.getMetricCollectionName(), target.getTargetName(), target.getTargetType(), iOException.getMessage()});
        }
    }

    public static Object[] convertToAgentFormat(InputSource inputSource, OutputStreamWriter outputStreamWriter, TargetMapper targetMapper) throws IOException, SAXException {
        XMLUploadWriter xMLUploadWriter = new XMLUploadWriter(outputStreamWriter, null);
        xMLUploadWriter.convertToAgentFormat(inputSource, targetMapper);
        return null;
    }

    private void convertToAgentFormat(InputSource inputSource, TargetMapper targetMapper) throws IOException, SAXException {
        String[] stringArray;
        CmdbInstanceDataParser cmdbInstanceDataParser = new CmdbInstanceDataParser(null, "1");
        cmdbInstanceDataParser.parseInstanceData(inputSource);
        this.m_cmdbInstanceTypes.add(cmdbInstanceDataParser.getInstanceTypes());
        String string = cmdbInstanceDataParser.getTargetName();
        String string2 = cmdbInstanceDataParser.getTargetType();
        String string3 = cmdbInstanceDataParser.getCollectionGroupName();
        String string4 = cmdbInstanceDataParser.getHostName();
        String string5 = cmdbInstanceDataParser.getInstallLocation();
        String string6 = cmdbInstanceDataParser.getConfigLocation();
        String string7 = cmdbInstanceDataParser.getOrgId();
        String string8 = cmdbInstanceDataParser.getCollectionTS();
        String string9 = cmdbInstanceDataParser.getTimezone();
        if (string3 == null || string3.length() == 0) {
            string3 = "defaultCollectionGroup";
        }
        String string10 = null;
        if (targetMapper != null && string4 == null && string5 == null && string7 == null && (stringArray = targetMapper.map(new String[]{string, string2, string4, string5, string6, string7})) != null) {
            int n = 0;
            string10 = stringArray[n++];
            string = stringArray[n++];
            string2 = stringArray[n++];
            string4 = stringArray[n++];
            string5 = stringArray[n++];
            string6 = stringArray[n++];
            string7 = stringArray[n++];
        }
        stringArray = new Target(string, string2, false, string, true, null, string5 == null ? "" : string5, string6, true, string4 == null ? "" : string4, string9, "1");
        String string11 = stringArray.getTimeZone();
        if (string9 != null && string9.length() > 0 && string11 == null) {
            s_log.error(TargetsMsgID.INVALID_COLLECTION_TIMEZONE, new String[]{string9, string, string2, Timezone.getTimezonesFilename()});
            throw new SAXException("Timezone " + string9 + " is not supported. See " + Timezone.getTimezonesFilename() + " for a list of suppored timezones.");
        }
        if (string10 != null) {
            stringArray.setGUID(string10);
        } else {
            stringArray.generateGUIDForImport(string7, string4);
        }
        this.m_resultMap = new CollectionResultList((Target)stringArray, string3, "1");
        this.write(this.getUploadPreambleForImport((Target)stringArray, string3, string4, string5, string8, string11));
        this.write(this.getTargetMapping((Target)stringArray, string7, string11));
        this.writeCmdbInstanceData();
        this.writeLongText();
        this.write(this.endUpload());
        this.m_printWriter.close();
    }

    private String endRow() {
        return "  </ROW>\n";
    }

    private String endRowSet() {
        return "</ROWSET>\n";
    }

    private String endUpload() {
        return "</UPLOAD>\n";
    }

    private void formatColumnValue(String string, String string2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (XMLOps.hasInvalidCDATA(string2)) {
            string2 = XMLOps.filterInvalidCDATA(string2);
            s_log.warn(CollectionMgrMsgID.INVALID_CHARS);
        }
        if (XMLOps.hasSpecialChars(string2)) {
            UploadTags.ROW_CDATA_FORMAT.format(new String[]{string, string2}, stringBuffer, fieldPosition);
        } else {
            UploadTags.ROW_FORMAT.format(new String[]{string, string2}, stringBuffer, fieldPosition);
        }
    }

    private String getAnnotationRowset(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        stringBuffer.append("<ROWSET TABLE=\"MGMT_ECM_SNAPSHOT_ANNOTATION\">\n");
        stringBuffer.append("  <ROW>\n");
        MessageFormat messageFormat = null;
        if (XMLOps.hasInvalidCDATA(string)) {
            string = XMLOps.filterInvalidCDATA(string);
            s_log.warn(CollectionMgrMsgID.INVALID_CHARS);
        }
        messageFormat = XMLOps.hasSpecialChars(string) ? UploadTags.ROW_CDATA_FORMAT : UploadTags.ROW_FORMAT;
        messageFormat.format(new String[]{"ANNOTATION", string}, stringBuffer, fieldPosition);
        stringBuffer.append("  </ROW>\n");
        stringBuffer.append("</ROWSET>\n");
        if (s_log.isDebugEnabled()) {
            s_log.debug("Writing annotation rowset for \"" + string + "\"");
        }
        return stringBuffer.toString();
    }

    private String getBeginMetricRowset(String string, CollectionResult collectionResult) {
        StringBuffer stringBuffer = new StringBuffer();
        TableDescriptor tableDescriptor = collectionResult.getMetricTableDescriptor();
        String string2 = tableDescriptor.getTableName();
        String string3 = "FALSE";
        if (collectionResult.isIncrementalMetric()) {
            string3 = "TRUE";
        }
        FieldPosition fieldPosition = new FieldPosition(1);
        String string4 = XMLUploadWriter.getProtocolVersion();
        if (tableDescriptor.isCmdbConfigurationItem()) {
            String string5 = tableDescriptor.getCmdbPackageName();
            String string6 = tableDescriptor.getCmdbTypeName();
            String string7 = tableDescriptor.getCmdbModelType();
            UploadTags.CMDB_BEGIN_ROWSET_FORMAT.format(new String[]{string4, string2, string, string3, string5, string6, string7}, stringBuffer, fieldPosition);
            if (s_log.isDebugEnabled()) {
                s_log.debug("Writing metricRowset for CMDB configuration item " + string5 + "/" + string6 + "/" + string7);
            }
        } else {
            UploadTags.BEGIN_ROWSET_FORMAT.format(new String[]{string4, string2.toUpperCase(s_locale), string, string3}, stringBuffer, fieldPosition);
            if (s_log.isDebugEnabled()) {
                s_log.debug("Writing metricRowset for table " + string2.toUpperCase(s_locale));
            }
        }
        return stringBuffer.toString();
    }

    private static String getEmdUrl() {
        if (m_emdUrl != null) {
            return m_emdUrl;
        }
        if (UplinkPath.gridAgentMode()) {
            CommandQualifier commandQualifier = Collector.getQualifier(EMD_URL_QUALIFIER);
            if (commandQualifier != null) {
                m_emdUrl = commandQualifier.getQualifierValue();
                return m_emdUrl;
            }
            Config config = AgentConfig.getInstance();
            Properties properties = config.getProperties();
            m_emdUrl = properties.getProperty("EMD_URL");
            if (m_emdUrl != null) {
                return m_emdUrl;
            }
        }
        m_emdUrl = "http://" + Hostname.getHostname() + "/ccr";
        return m_emdUrl;
    }

    private String getLiveLinkTargetMapping() {
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        String string = securityMgr.getCustomerOrgId();
        Target target = this.m_resultMap.getTargetInstance();
        return this.getTargetMapping(target, string, target.getTimeZone());
    }

    public static String getProtocolVersion() {
        if (!s_protocolVersionSet) {
            Class clazz = class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter != null ? class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter : (class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter = XMLUploadWriter.class$("oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter"));
            synchronized (clazz) {
                if (!s_protocolVersionSet) {
                    s_protocolVersion = UplinkPath.omsMode() ? ADHOC_COLLECTION_PROTOCOL_VERSION : CCRMetadataVer.getMetadataVer();
                    s_protocolVersionSet = true;
                }
            }
        }
        return s_protocolVersion;
    }

    private String getTargetMapping(Target target, String string, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        FieldPosition fieldPosition2 = new FieldPosition(1);
        FieldPosition fieldPosition3 = new FieldPosition(1);
        FieldPosition fieldPosition4 = new FieldPosition(1);
        if (string == null || string.length() == 0) {
            string = "0";
        }
        String string3 = "";
        String string4 = null;
        String string5 = null;
        if (target.isProxyTarget() || UplinkPath.gridAgentMode()) {
            string4 = target.getTargetHost();
            string5 = target.getTargetHome();
        } else {
            string4 = Hostname.getHostname();
            string5 = Collector.getOracleHome();
        }
        String string6 = target.getConfigHome();
        String string7 = target.getFullPath();
        if (!Collector.isDisconnected()) {
            string3 = target.getGUID();
        }
        String string8 = UNASSOCIATED_TARGETS_TABLE;
        if (UplinkPath.omsMode() || UplinkPath.gridAgentMode()) {
            string8 = "MGMT_CMDB_TARGETS";
        } else {
            try {
                object = SecurityMgr.getInstance().getAuthenticationKey();
                if (object != null && !(object instanceof AnonAuthenticationKey)) {
                    if (object instanceof CSIV2AuthenticationKey || object instanceof CSIAuthenticationKey) {
                        string8 = ASSOCIATED_TARGETS_TABLE;
                    } else if (object instanceof EmailAuthenticationKey && ((AuthenticationKey)object).holdsUniqueCSI()) {
                        string8 = ASSOCIATED_TARGETS_TABLE;
                    }
                }
            }
            catch (AuthenticationFailure authenticationFailure) {
                string8 = ASSOCIATED_TARGETS_TABLE;
            }
        }
        object = new StringBuffer("");
        if (string7 != null && string7.length() > 0) {
            UploadTags.LIVELINK_FULL_PATH_FORMAT.format(new String[]{string7}, (StringBuffer)object, fieldPosition4);
        }
        UploadTags.LIVELINK_TARGET_ROW_FORMAT.format(new String[]{string3, string, string4, target.getTargetName(), target.getTargetType(), string5, string2 == null ? "" : string2, ((StringBuffer)object).toString()}, stringBuffer, fieldPosition2);
        if (string6 != null && string6.length() > 0 && !target.getTargetType().equals("oracle_home")) {
            UploadTags.LIVELINK_ORACLE_CFGHOME_FORMAT.format(new String[]{string6}, stringBuffer2, fieldPosition3);
        } else {
            stringBuffer2.append("");
        }
        UploadTags.LIVELINK_MAPPING_FORMAT.format(new String[]{XMLUploadWriter.getProtocolVersion(), string8, stringBuffer.toString(), stringBuffer2.toString()}, stringBuffer3, fieldPosition);
        if (s_log.isDebugEnabled()) {
            s_log.debug("Writing targetMapping for (" + target.getTargetName() + ", " + target.getTargetType() + ")");
        }
        return stringBuffer3.toString();
    }

    private String getUploadPreamble() {
        String string;
        String string2;
        String string3;
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        FieldPosition fieldPosition2 = new FieldPosition(1);
        String string4 = "";
        if (UplinkHomeConfig.getInstance().getProperty("generateTemplate", false)) {
            string4 = DATE_VAR;
        } else {
            serializable = this.m_resultMap.getCollectionTimestamp();
            string4 = s_dateFormat.format((Date)serializable);
        }
        serializable = this.m_resultMap.getTargetInstance();
        String string5 = "";
        if (((Target)serializable).isProxyTarget()) {
            string3 = new Boolean(((Target)serializable).isProxyTarget()).toString();
            string2 = ((Target)serializable).getTargetHost();
            string = ((Target)serializable).getTargetHome();
            UploadTags.PROXY_OPTIONAL_ATTRIBUTES.format(new String[]{string3, string2, string}, stringBuffer2, fieldPosition);
        }
        if (!Collector.isDisconnected()) {
            string5 = ((Target)serializable).getGUID();
        }
        string3 = Collector.getGridAgentOnTarget();
        string4 = String.valueOf(string4) + " " + ((Target)serializable).getTimeZone();
        string2 = ((Target)serializable).getTargetProperty("OCM_CROSS_HOST");
        string2 = string2 == null || !string2.equalsIgnoreCase("TRUE") ? "FALSE" : "TRUE";
        string = stringBuffer2.toString();
        if (this.m_isGC) {
            string = " IS_GC=\"TRUE\"" + string;
        }
        UploadTags.AGENT_UPLOAD_FORMAT.format(new String[]{XMLUploadWriter.getProtocolVersion(), XMLUploadWriter.getEmdUrl(), string4, string5, this.m_resultMap.getCollectionName(), new Boolean(this.m_bCollectorFiltered).toString(), string3, string2, string}, stringBuffer, fieldPosition2);
        if (s_log.isDebugEnabled()) {
            s_log.debug("Writing upload tag for (" + ((Target)serializable).getTargetName() + ", " + ((Target)serializable).getTargetType() + ") collection " + this.m_resultMap.getCollectionName());
        }
        return stringBuffer.toString();
    }

    private String getUploadPreambleForImport(Target target, String string, String string2, String string3, String string4, String string5) throws SAXException {
        String string6;
        StringBuffer stringBuffer = new StringBuffer();
        if (string4 != null && string5 != null) {
            if (XMLUploadWriter.parseCollectionDate(string4) == null) {
                s_log.error(TargetsMsgID.INVALID_COLLECTION_TS, new String[]{string4, target.getTargetName(), target.getTargetType(), s_dateFormat.toPattern()});
                throw new SAXException("Failed to parse collection timestamp: " + string4 + " for target " + target.getTargetName() + " of type " + target.getTargetType() + ". Expexted date pattern: " + s_dateFormat.toPattern());
            }
            string6 = String.valueOf(string4) + " " + string5;
        } else {
            string6 = String.valueOf(s_dateFormat.format(new Date())) + " " + Timezone.getInstance().getSupportedRegion();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        UploadTags.PROXY_OPTIONAL_ATTRIBUTES.format(new String[]{"true", string2 == null ? "" : string2, string3 == null ? "" : string3}, stringBuffer2, new FieldPosition(1));
        String string7 = stringBuffer2.toString();
        if (this.m_isGC) {
            string7 = " IS_GC=\"TRUE\"" + string7;
        }
        UploadTags.AGENT_UPLOAD_FORMAT.format(new String[]{XMLUploadWriter.getProtocolVersion(), "ad hoc collection", string6, target.getGUID(), string, "false", "local", "FALSE", string7}, stringBuffer, new FieldPosition(1));
        return stringBuffer.toString();
    }

    private void init(String string, CollectionResultList collectionResultList, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        this.m_resultMap = collectionResultList;
        this.m_bCollectorFiltered = bl;
        this.m_isGC = bl2;
        this.openFile(string);
    }

    public static final void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Did not find sourceFileName and outputFileName arguments on the command line.");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                try {
                    fileInputStream = new FileInputStream(new File(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException("Source file is not found: '" + fileNotFoundException.getMessage() + "'; " + fileNotFoundException.toString());
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException("Security exception while opening source file: '" + securityException.getMessage() + "'; " + securityException.toString());
                }
                XMLUploadWriter.convertToAgentFormat(new InputSource(fileInputStream), new OutputStreamWriter((OutputStream)new BufferedOutputStream(byteArrayOutputStream), "UTF-8"), null);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                File file = new File(string2);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                filterOutputStream = new BufferedOutputStream(fileOutputStream);
                int n = 0;
                while ((n = byteArrayInputStream.read()) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Caught exception in main(): " + exception.getMessage() + "; " + exception.toString());
            }
            Object var7_13 = null;
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Throwable throwable2) {}
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
        catch (Throwable throwable) {}
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Throwable throwable) {}
        System.out.println("Finished conversion: success");
    }

    protected void openFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.m_printWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
    }

    public static Date parseCollectionDate(String string) {
        return s_dateFormat.parse(string, new ParsePosition(0));
    }

    public void write() throws IOException, SAXException {
        Object object;
        Object object2;
        this.write(this.getUploadPreamble());
        this.write(this.getLiveLinkTargetMapping());
        if (Collector.qualifierSpecified("annotation") && (object2 = ((CommandQualifier)(object = Collector.getQualifier("annotation"))).getQualifierValue()) != null) {
            this.write(this.getAnnotationRowset((String)object2));
        }
        object = this.m_resultMap.getMetadataVersion();
        object2 = this.m_resultMap.keySet();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CollectionResult collectionResult = this.m_resultMap.getResult(string);
            if (collectionResult.isCmdbFormat()) {
                this.collectCmdbInstanceData(collectionResult, (String)object);
                continue;
            }
            this.write(collectionResult, (String)object);
        }
        this.writeCmdbInstanceData();
        this.writeLongText();
        this.write(this.endUpload());
        this.m_printWriter.close();
    }

    protected void write(String string) throws IOException {
        this.m_printWriter.write(string, 0, string.length());
    }

    private void write(CollectionResult collectionResult, String string) throws IOException {
        Target target = this.m_resultMap.getTargetInstance();
        String string2 = target.getTargetType();
        String string3 = collectionResult.getMetricCollectionName();
        TableDescriptor tableDescriptor = collectionResult.getMetricTableDescriptor();
        Vector vector = tableDescriptor.getColDescs();
        FieldPosition fieldPosition = new FieldPosition(1);
        MetricResult metricResult = collectionResult.getCollectionResult();
        Vector vector2 = null;
        if (metricResult == null || (vector2 = metricResult.getValueRows()) == null || vector2.size() == 0) {
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug("No metric data found for metric " + collectionResult.getMetricCollectionName());
            }
            if (!collectionResult.isIncrementalMetric()) {
                this.write(this.getBeginMetricRowset(string, collectionResult));
                this.write(this.endRowSet());
            }
            return;
        }
        this.write(this.getBeginMetricRowset(string, collectionResult));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector2.size()) {
            ValueRow valueRow = (ValueRow)vector2.get(n);
            stringBuffer.append(this.beginRow());
            if (tableDescriptor.isCmdbConfigurationItem()) {
                UploadTags.ROW_FORMAT.format(new String[]{"IVID", GUID.generateGuid()}, stringBuffer, fieldPosition);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.get(n2);
                if (columnDescriptor.isEnabled()) {
                    String string4;
                    String string5 = columnDescriptor.getColumnName();
                    String string6 = valueRow.getValue(n2);
                    if (TargetManager.m_disabledColumns.containsKey("ccr.metric." + string2.toLowerCase() + "." + string3.toLowerCase() + "." + string5.toLowerCase())) {
                        string6 = null;
                    }
                    if (!tableDescriptor.isCmdbConfigurationItem()) {
                        string5 = string5.toUpperCase(s_locale);
                    }
                    if (string6 == null || string6.length() == 0) {
                        UploadTags.ROW_NOVALUE_FORMAT.format(new String[]{string5}, stringBuffer, fieldPosition);
                    } else if (columnDescriptor.isLongText()) {
                        string4 = null;
                        try {
                            string4 = Utils.getDigest(string6);
                            if (!this.m_longText.containsKey(string4)) {
                                this.m_longText.put(string4, string6);
                            }
                            UploadTags.ROW_FORMAT.format(new String[]{string5, string4}, stringBuffer, fieldPosition);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            this.formatColumnValue(string5, string6, stringBuffer, fieldPosition);
                        }
                        catch (DigestException digestException) {
                            this.formatColumnValue(string5, string6, stringBuffer, fieldPosition);
                        }
                    } else if (columnDescriptor.isToBeReadFromFile() && this.getClass().equals(class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter != null ? class$oracle$sysman$ccr$collector$collectionMgr$XMLUploadWriter : XMLUploadWriter.class$("oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter"))) {
                        string4 = string6.substring(0, string6.lastIndexOf("$FileDigest="));
                        String string7 = null;
                        try {
                            string7 = string4 == null ? "ERROR: File name is NULL" : Utils.getFileContent(new File(string4));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            string7 = "ERROR: File " + string4 + " was not found";
                        }
                        catch (IOException iOException) {
                            string7 = "ERROR: File " + string4 + " could not be read";
                        }
                        UploadTags.ROW_CDATA_FORMAT.format(new String[]{string5, string7}, stringBuffer, fieldPosition);
                    } else {
                        this.formatColumnValue(string5, string6, stringBuffer, fieldPosition);
                    }
                }
                ++n2;
            }
            stringBuffer.append(this.endRow());
            ++n;
        }
        this.write(stringBuffer.toString());
        this.write(this.endRowSet());
    }

    private void writeCmdbInstanceData() throws IOException {
        ArrayList arrayList = Instances.mergeInstanceTypes(this.m_cmdbInstanceTypes);
        int n = 0;
        while (n < arrayList.size()) {
            Instances instances = (Instances)arrayList.get(n);
            ArrayList arrayList2 = instances.getInstances();
            if (arrayList2 != null) {
                String string = instances.getInstanceTypeStart();
                this.write(string);
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    Instance instance = (Instance)arrayList2.get(n2);
                    string = instance.generateUploadXml();
                    this.write(string);
                    ++n2;
                }
                string = instances.getInstanceTypeEnd();
                this.write(string);
            }
            ++n;
        }
    }

    private void writeLongText() throws IOException {
        int n = this.m_longText.size();
        if (n == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(1);
        UploadTags.LONG_TEXT_ROWSET_HDR.format(new String[]{XMLUploadWriter.getProtocolVersion()}, stringBuffer, fieldPosition);
        Set set = this.m_longText.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.m_longText.get(string);
            stringBuffer.append("  <ROW>\n");
            UploadTags.ROW_FORMAT.format(new String[]{"DIGEST", string}, stringBuffer, fieldPosition);
            MessageFormat messageFormat = null;
            if (XMLOps.hasInvalidCDATA(string2)) {
                string2 = XMLOps.filterInvalidCDATA(string2);
                s_log.warn(CollectionMgrMsgID.INVALID_CHARS);
            }
            messageFormat = XMLOps.hasSpecialChars(string2) ? UploadTags.ROW_CDATA_FORMAT : UploadTags.ROW_FORMAT;
            messageFormat.format(new String[]{"PREFIX", string2}, stringBuffer, fieldPosition);
            stringBuffer.append("  </ROW>\n");
        }
        stringBuffer.append("</ROWSET>\n");
        this.write(stringBuffer.toString());
    }
}

