/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.fetchlets;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.MetricValue;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;

public class MetricResult
implements Serializable {
    private static final long serialVersionUID = -2851588453520926374L;
    static final String TAGNAME = "MetricResult";
    private static final String ATTR_TYPE = "TYPE";
    private static final String ATTR_DATE = "DATE";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int m_typeId;
    private long m_computeTime = System.currentTimeMillis();
    private Date m_computeDate = null;
    private MetricValue m_value = null;
    private Vector m_valueRows = null;
    private static DecimalFormat m_df = null;

    static {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        if (numberFormat != null) {
            m_df = (DecimalFormat)numberFormat;
            m_df.setMaximumFractionDigits(2);
            ((NumberFormat)m_df).setGroupingUsed(false);
        }
    }

    public ValueRow addValueRow() {
        ValueRow valueRow = new ValueRow();
        this.addValueRow(valueRow);
        return valueRow;
    }

    public ValueRow addValueRow(int n) {
        ValueRow valueRow = new ValueRow(n);
        this.addValueRow(valueRow);
        return valueRow;
    }

    public void addValueRow(ValueRow valueRow) {
        if (this.m_valueRows == null) {
            this.m_valueRows = new Vector();
        }
        valueRow.setResult(this);
        this.m_valueRows.addElement(valueRow);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MetricResult)) {
            return false;
        }
        MetricResult metricResult = (MetricResult)object;
        if (this.m_value != null) {
            MetricValue metricValue = metricResult.getValue();
            if (metricValue != null) {
                return this.getValue().equals(metricValue);
            }
            return false;
        }
        Vector vector = this.getValueRows();
        if (vector == null) {
            return metricResult.getValueRows() == null;
        }
        Vector vector2 = metricResult.getValueRows();
        if (vector2 == null) {
            return false;
        }
        int n = vector.size();
        if (n != vector2.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e == null ? vector2.elementAt(n2) != null : !e.equals(vector2.elementAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Date getComputeDate() {
        if (this.m_computeDate != null) {
            return this.m_computeDate;
        }
        return new Date(this.m_computeTime);
    }

    public long getComputeTime() {
        return this.m_computeTime;
    }

    public int getTypeId() {
        return this.m_typeId;
    }

    public MetricValue getValue() {
        if (this.m_value == null && this.m_valueRows != null) {
            ValueRow valueRow = (ValueRow)this.m_valueRows.firstElement();
            this.m_value = (MetricValue)valueRow.getValues().firstElement();
        }
        return this.m_value;
    }

    public Vector getValueRows() {
        return this.m_valueRows;
    }

    public void setComputeTime(long l) {
        this.m_computeTime = l;
    }

    public void setRsltPointers() {
        int n = this.m_valueRows == null ? 0 : this.m_valueRows.size();
        int n2 = 0;
        while (n2 < n) {
            ValueRow valueRow = (ValueRow)this.m_valueRows.elementAt(n2);
            valueRow.setResult(this);
            ++n2;
        }
    }

    public void setTypeId(int n) {
        this.m_typeId = n;
    }

    public void setValue(MetricValue metricValue) {
        this.m_value = metricValue;
    }
}

