/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.fetchlets;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.MetricValue;
import org.xml.sax.Attributes;

public class ValueRow
implements Serializable {
    private static final long serialVersionUID = 4840650007219673076L;
    static final String TAGNAME = "ValueRow";
    private Vector m_values = null;
    private MetricResult m_result = null;

    public ValueRow() {
        this.m_values = new Vector();
    }

    public ValueRow(int n) {
        this.m_values = new Vector(n);
        this.m_values.setSize(n);
    }

    public void addValue(MetricValue metricValue) {
        this.m_values.addElement(metricValue);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueRow)) {
            return false;
        }
        ValueRow valueRow = (ValueRow)object;
        int n = this.m_values.size();
        if (n != valueRow.m_values.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            Object e = this.m_values.elementAt(n2);
            if (e == null ? valueRow.m_values.elementAt(n2) != null : !e.equals(valueRow.m_values.elementAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public MetricValue getMValue(int n) {
        MetricValue metricValue = null;
        int n2 = this.m_values.size();
        if (n >= 0 && n < n2) {
            metricValue = (MetricValue)this.m_values.elementAt(n);
        }
        return metricValue;
    }

    public Vector getNestedValues(int n) {
        Vector vector = null;
        MetricValue metricValue = this.getMValue(n);
        if (metricValue != null) {
            vector = metricValue.getNestedRows();
        }
        return vector;
    }

    public float getNumValue(int n) throws NumberFormatException {
        String string = this.getValue(n);
        return Float.valueOf(string).floatValue();
    }

    public String getRowString() {
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < this.m_values.size()) {
            String string = this.getValue(n);
            if (string != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string);
                } else {
                    stringBuffer.append("|").append(string);
                }
            }
            ++n;
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String getValue(int n) {
        String string = null;
        MetricValue metricValue = this.getMValue(n);
        if (metricValue != null) {
            string = metricValue.getContents();
        }
        return string;
    }

    public Vector getValues() {
        return this.m_values;
    }

    public void init(Attributes attributes) {
    }

    public void setResult(MetricResult metricResult) {
        this.m_result = metricResult;
    }

    public void setValue(int n) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(), n);
    }

    public void setValue(int n, float f) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(f), n);
    }

    public void setValue(int n, String string) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(string), n);
    }

    public void setValue(int n, Vector vector) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(new MetricValue(vector), n);
    }

    public void setValue(int n, MetricValue metricValue) {
        if (n >= this.m_values.size()) {
            this.m_values.setSize(n + 1);
        }
        this.m_values.setElementAt(metricValue, n);
    }
}

