/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigResponseException;
import oracle.sysman.ccr.collector.install.ConfigResponseExitConsts;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConflictingQualifierException;
import oracle.sysman.ccr.collector.install.CreateCSIResponseCommand;
import oracle.sysman.ccr.collector.install.CreateMetaLinkEmailResponseCommand;
import oracle.sysman.ccr.collector.install.CreateResponseCommand;
import oracle.sysman.ccr.collector.install.DisplayResponseCommand;
import oracle.sysman.ccr.collector.install.ExportResponseCommand;
import oracle.sysman.ccr.collector.install.InsufficientArgumentsException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.QueryResponseCommand;
import oracle.sysman.ccr.collector.install.SyntaxException;
import oracle.sysman.ccr.collector.install.UsageCommand;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.JCEInitializationException;
import org.apache.log4j.PropertyConfigurator;

public class ConfigResponse
implements ConfigResponseExitConsts {
    static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.install.ConfigResponse");
    static final String OCM_LOG_LEVEL = "OCM_LOG_LEVEL";
    static final String DEFAULT_LOG_LEVEL = "WARN";
    static final String RESPONSE_OUTPUT_QUAL = "-output";
    static final String SILENT_QUAL = "-no_banner";
    static final String USAGE_QUAL = "-help";
    static final String INSTALL_CODEPATH = "-InstallPath";
    static final String QUERY_QUAL = "-query";
    static final String RESPONSE_INPUT_QUAL = "-response_file";
    static final String RECONFIG_QUAL = "-reconfig";
    static final String LICENSE_QUAL = "-license";
    static final String VERBOSE_QUAL = "-verbose";
    static final String EXPORT_QUAL = "-export";
    static final String REPEATER_QUAL = "-repeater";
    private static final String DEFAULT_RESPONSE_FILENAME = "ocm.rsp";
    private static final String OCM_ROOT = "OCM_ROOT";
    private static String s_strOCMRoot;
    private static Logger s_logger;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$install$ConfigResponse;

    static {
        ConfigResponse.init();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void createResponseFile(String string, String string2) throws ConfigResponseException, IOException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put(INSTALL_CODEPATH, new Boolean(true));
        CreateMetaLinkEmailResponseCommand createMetaLinkEmailResponseCommand = new CreateMetaLinkEmailResponseCommand(string, string2);
        createMetaLinkEmailResponseCommand.setQualifiers(hashMap);
        createMetaLinkEmailResponseCommand.setNoConfirmationMsg();
        createMetaLinkEmailResponseCommand.execute();
    }

    public static void createResponseFile(String string, LicenseAgreement licenseAgreement, NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal) throws IOException {
        CreateResponseCommand.createResponseFile(string, licenseAgreement, networkConfiguration, oCMRegistrationPrincipal);
    }

    public static void createResponseFile(String string, NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal) throws IOException {
        CreateResponseCommand.createResponseFile(string, new LicenseAgreement(true), networkConfiguration, oCMRegistrationPrincipal);
    }

    public static void init() {
        if (!Logger.isLoggingConfigured()) {
            Properties properties = new Properties();
            ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
            ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
            ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
            String string = System.getProperty(OCM_LOG_LEVEL);
            if (string == null) {
                string = DEFAULT_LOG_LEVEL;
            }
            ((Hashtable)properties).put("log4j.rootCategory", String.valueOf(string) + ", Console");
            PropertyConfigurator.configure(properties);
        }
        System.setProperty("ocm.keystore_resource", "true");
        System.setProperty("ocm.countrymap_resource", "true");
        s_strOCMRoot = System.getProperty(OCM_ROOT);
        s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$install$ConfigResponse != null ? class$oracle$sysman$ccr$collector$install$ConfigResponse : (class$oracle$sysman$ccr$collector$install$ConfigResponse = ConfigResponse.class$("oracle.sysman.ccr.collector.install.ConfigResponse")));
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            ConfigResponseCommand configResponseCommand = null;
            configResponseCommand = ConfigResponse.parseCommand(stringArray);
            if (configResponseCommand.displayBanner()) {
                System.out.println(s_msgBundle.getMessage(ConfigResponseMsgID.OCM_RESPONSE_BANNER, false));
            }
            configResponseCommand.execute();
        }
        catch (SyntaxException syntaxException) {
            try {
                System.err.println(syntaxException.getMessage());
                new UsageCommand().execute();
                n = syntaxException.exitCode();
            }
            catch (ConfigCommandException configCommandException) {
                n = configCommandException.exitCode();
            }
        }
        catch (ConfigCommandException configCommandException) {
            System.err.println(configCommandException.getMessage());
            n = configCommandException.exitCode();
        }
        catch (JCEInitializationException jCEInitializationException) {
            System.err.println(jCEInitializationException.getMessage());
            n = 1;
        }
        System.exit(n);
    }

    private static ConfigResponseCommand parseCommand(String[] stringArray) throws ConfigCommandException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ConfigResponseCommand configResponseCommand = null;
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 2;
        String[] stringArray2 = new String[3];
        String[] stringArray3 = new String[stringArray2.length];
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4].equals(USAGE_QUAL)) {
                configResponseCommand = new UsageCommand();
                break;
            }
            if (stringArray[n4].equals(INSTALL_CODEPATH)) {
                hashMap.put(INSTALL_CODEPATH, new Boolean(true));
            } else if (stringArray[n4].equals(LICENSE_QUAL)) {
                hashMap.put(LICENSE_QUAL, new Boolean(true));
            } else if (stringArray[n4].equals(SILENT_QUAL)) {
                hashMap.put(SILENT_QUAL, new Boolean(true));
            } else if (stringArray[n4].equals(RECONFIG_QUAL)) {
                hashMap.put(RECONFIG_QUAL, new Boolean(true));
                Config config = UplinkSystemConfig.getInstance();
                String string = config.getProperty("ccr.registration_mode");
                if (string == null || string.equals("csi")) {
                    stringArray3[0] = config.getProperty("ccr.support_id");
                    stringArray3[1] = config.getProperty("ccr.metalink_id");
                    stringArray3[2] = config.getProperty("ccr.country_code");
                }
                if ((string = (config = UplinkHomeConfig.getInstance()).getProperty("ccr.agreement_signer")) != null) {
                    hashMap.put(LICENSE_QUAL, new Boolean(true));
                }
            } else if (stringArray[n4].equals(RESPONSE_OUTPUT_QUAL)) {
                if (n4 == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(RESPONSE_OUTPUT_QUAL, stringArray[++n4]);
                ++n;
            } else if (stringArray[n4].equals(EXPORT_QUAL)) {
                if (n4 == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(EXPORT_QUAL, stringArray[++n4]);
                ++n;
            } else if (stringArray[n4].equals(QUERY_QUAL)) {
                if (n4 == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(QUERY_QUAL, stringArray[++n4]);
            } else if (stringArray[n4].equals(RESPONSE_INPUT_QUAL)) {
                if (n4 == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(RESPONSE_INPUT_QUAL, stringArray[++n4]);
            } else if (stringArray[n4].equals(VERBOSE_QUAL)) {
                if (n4 == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(VERBOSE_QUAL, stringArray[++n4]);
                ++n;
            } else if (stringArray[n4].equals(REPEATER_QUAL)) {
                if (n4 == stringArray.length - 1) {
                    throw new InsufficientArgumentsException();
                }
                hashMap.put(REPEATER_QUAL, stringArray[++n4]);
            } else {
                if (stringArray[n4].startsWith("-")) {
                    throw new SyntaxException();
                }
                if (n2 == stringArray2.length - 1) {
                    throw new SyntaxException();
                }
                stringArray2[++n2] = stringArray[n4];
            }
            ++n4;
        }
        if (n > 1) {
            throw new ConflictingQualifierException();
        }
        String string = (String)hashMap.get(VERBOSE_QUAL);
        if (string != null) {
            configResponseCommand = new DisplayResponseCommand(string);
        } else {
            string = (String)hashMap.get(EXPORT_QUAL);
            if (string != null) {
                configResponseCommand = new ExportResponseCommand(string);
            } else {
                string = (String)hashMap.get(QUERY_QUAL);
                if (string != null) {
                    configResponseCommand = new QueryResponseCommand(string, (String)hashMap.get(RESPONSE_INPUT_QUAL));
                } else if (n2 >= 0) {
                    string = (String)hashMap.get(RESPONSE_OUTPUT_QUAL);
                    if (string == null) {
                        string = DEFAULT_RESPONSE_FILENAME;
                    }
                    configResponseCommand = new CreateCSIResponseCommand(string, s_strOCMRoot, stringArray2[0], stringArray2[1], stringArray2[2], stringArray3[0], stringArray3[1], stringArray3[2]);
                } else {
                    string = (String)hashMap.get(RESPONSE_OUTPUT_QUAL);
                    if (string != null) {
                        configResponseCommand = new CreateMetaLinkEmailResponseCommand(string, s_strOCMRoot);
                    }
                }
            }
        }
        if (configResponseCommand == null) {
            configResponseCommand = new CreateMetaLinkEmailResponseCommand(DEFAULT_RESPONSE_FILENAME, s_strOCMRoot);
        }
        if (s_logger != null && s_logger.isDebugEnabled()) {
            s_logger.debug("CLI Qualifiers found are: " + hashMap);
            s_logger.debug("Found " + (n2 + 1) + " command line arguments");
            int n5 = 0;
            while (n5 <= n2) {
                s_logger.debug("  arg[" + n5 + "] = " + stringArray2[n5]);
                ++n5;
            }
        }
        configResponseCommand.setQualifiers(hashMap);
        return configResponseCommand;
    }
}

