/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.IOException;
import oracle.sysman.ccr.collector.countryCodes.CountryCode;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeException;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeMap;
import oracle.sysman.ccr.collector.countryCodes.NoSuchCountryCodeException;
import oracle.sysman.ccr.collector.install.AnonymousRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.CreateResponseCommand;
import oracle.sysman.ccr.collector.install.InsufficientArgumentsException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.install.MetaLinkCSIPrincipal;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.UnexpectedException;
import oracle.sysman.ccr.common.ResourceID;
import oracle.sysman.ccr.common.logging.Logger;

class CreateCSIResponseCommand
extends CreateResponseCommand {
    private static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$install$CreateCSIResponseCommand != null ? class$oracle$sysman$ccr$collector$install$CreateCSIResponseCommand : (class$oracle$sysman$ccr$collector$install$CreateCSIResponseCommand = CreateCSIResponseCommand.class$("oracle.sysman.ccr.collector.install.CreateCSIResponseCommand")));
    private static boolean s_bFirstPromptRequest = true;
    private String m_strCSI = null;
    private String m_strMetaLinkId = null;
    private int m_nCountryCode = -1;
    private String m_strCountryCode = null;
    private String m_strDefaultCSI = null;
    private String m_strDefaultMetalink = null;
    private String m_strDefaultCC = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$install$CreateCSIResponseCommand;

    CreateCSIResponseCommand(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws InvalidValueException, UnexpectedException {
        super(string, string2);
        this.init();
        this.m_strCSI = string3;
        this.m_strMetaLinkId = string4;
        if (string5 != null) {
            this.setCountryCode(string5);
        }
        this.m_strDefaultCSI = string6;
        this.m_strDefaultMetalink = string7;
        this.m_strDefaultCC = string8;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Constructing CSIResponse Command with: " + this.m_strCSI + ", " + this.m_strMetaLinkId + ", " + this.m_strCountryCode + ", " + this.m_strDefaultCSI + ", " + this.m_strDefaultMetalink + ", " + this.m_strDefaultCC);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void init() {
        this.m_strCSI = null;
        this.m_strMetaLinkId = null;
        this.m_nCountryCode = -1;
        this.m_strCountryCode = null;
    }

    protected OCMRegistrationPrincipal promptForPrincipal() throws ConfigCommandException {
        OCMRegistrationPrincipal oCMRegistrationPrincipal = null;
        while (oCMRegistrationPrincipal == null) {
            try {
                if (s_bFirstPromptRequest && (this.m_strCSI == null || this.m_strMetaLinkId == null || this.m_strCountryCode == null)) {
                    ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.CSI_PROMPT_INTRO, false));
                }
                this.m_strCSI = this.safePrompt(ConfigResponseMsgID.CSI_PROMPT, this.m_strCSI, null, s_bFirstPromptRequest);
                if (this.m_strCSI == null || this.m_strCSI.length() == 0) {
                    oCMRegistrationPrincipal = new AnonymousRegistrationPrincipal();
                } else {
                    this.m_strMetaLinkId = this.safePrompt(ConfigResponseMsgID.CSI_MLID_PROMPT, this.m_strMetaLinkId, ConfigResponseMsgID.ERR_MISSING_MLID, s_bFirstPromptRequest);
                    this.m_strCountryCode = this.safePrompt(ConfigResponseMsgID.CSI_CC_PROMPT, this.m_strCountryCode, ConfigResponseMsgID.ERR_MISSING_CC, s_bFirstPromptRequest);
                    this.setCountryCode(this.m_strCountryCode);
                    oCMRegistrationPrincipal = new MetaLinkCSIPrincipal(this.m_strMetaLinkId, this.m_strCSI, this.m_nCountryCode);
                }
            }
            catch (InsufficientArgumentsException insufficientArgumentsException) {
                ConfigResponseCommand.Stderr.println(insufficientArgumentsException.getMessage());
                ConfigResponseCommand.Stderr.println();
            }
            catch (InvalidValueException invalidValueException) {
                ConfigResponseCommand.Stderr.println(invalidValueException.getMessage());
                ConfigResponseCommand.Stderr.println();
            }
            s_bFirstPromptRequest = false;
        }
        return oCMRegistrationPrincipal;
    }

    String safePrompt(ResourceID resourceID, String string, ResourceID resourceID2, boolean bl) throws InsufficientArgumentsException {
        String string2;
        block3: {
            string2 = null;
            try {
                string2 = bl && string != null && string.length() != 0 ? string : this.promptForInput(this.s_msgBundle.getMessage(resourceID, false));
                if (string2 == null || string2.trim().length() == 0 && resourceID2 != null) {
                    throw new InsufficientArgumentsException(resourceID2);
                }
            }
            catch (IOException iOException) {
                if (resourceID2 == null) break block3;
                throw new InsufficientArgumentsException(resourceID2);
            }
        }
        return string2.trim();
    }

    private void setCountryCode(String string) throws InvalidValueException, UnexpectedException {
        try {
            CountryCodeMap countryCodeMap = CountryCodeMap.getInstance();
            CountryCode countryCode = countryCodeMap.getCountryCode(string);
            this.m_nCountryCode = countryCode.getValue();
            this.m_strCountryCode = string;
        }
        catch (NoSuchCountryCodeException noSuchCountryCodeException) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_COUNTRY_CODE);
        }
        catch (CountryCodeException countryCodeException) {
            throw new UnexpectedException(countryCodeException.getMessage());
        }
    }
}

