/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.AnonymousMailRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.AnonymousRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigResponseExitConsts;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.CreateCommandException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ResponseFile;
import oracle.sysman.ccr.collector.install.UnexpectedException;
import oracle.sysman.ccr.common.TestMap;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.SecurePrompter;

class CreateResponseCommand
extends ConfigResponseCommand
implements ConfigResponseExitConsts {
    private static final String LICENSE_DOC = "license.txt";
    protected static int PROMPT_LIMIT = 3;
    protected static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$install$CreateResponseCommand != null ? class$oracle$sysman$ccr$collector$install$CreateResponseCommand : (class$oracle$sysman$ccr$collector$install$CreateResponseCommand = CreateResponseCommand.class$("oracle.sysman.ccr.collector.install.CreateResponseCommand")));
    private static TestMap s_testMap = new TestMap(class$oracle$sysman$ccr$collector$install$CreateResponseCommand != null ? class$oracle$sysman$ccr$collector$install$CreateResponseCommand : (class$oracle$sysman$ccr$collector$install$CreateResponseCommand = CreateResponseCommand.class$("oracle.sysman.ccr.collector.install.CreateResponseCommand")));
    private String m_strFilename;
    private String m_strOCMRoot;
    private boolean m_bNoConfirmation = false;
    private static final String SUBTEST_PROXY_REQD = "proxyreqd";
    private static final String SUBTEST_NO_PRINCIPAL_PROMPT = "noprincipal_prompting";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$install$CreateResponseCommand;

    static {
        if (s_testMap.isUnderTest(SUBTEST_NO_PRINCIPAL_PROMPT)) {
            PROMPT_LIMIT = 1;
        }
    }

    CreateResponseCommand(String string, String string2) {
        this.m_strFilename = string;
        this.m_strOCMRoot = string2;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("CreateResponseCommand created: (" + this.m_strFilename + "," + this.m_strOCMRoot + ")");
        }
    }

    protected String authenticateUser(OCMRegistrationPrincipal oCMRegistrationPrincipal, EndPoint endPoint, NetworkConfiguration networkConfiguration) {
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static void createResponseFile(String string, LicenseAgreement licenseAgreement, NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal) throws IOException {
        ResponseFile responseFile = new ResponseFile(licenseAgreement, networkConfiguration, oCMRegistrationPrincipal);
        responseFile.concentrateResponseFile(string);
    }

    private NetworkConfiguration determineNetworkPath() throws InvalidValueException {
        NetworkConfiguration networkConfiguration = new NetworkConfiguration();
        if (this.qualifierSet("-repeater")) {
            String string = this.qualifierValue("-repeater");
            try {
                if (string.equals("NONE")) {
                    networkConfiguration.declineRepeater();
                } else {
                    URI uRI = new URI(string);
                    networkConfiguration.setRepeaterURI(uRI);
                }
            }
            catch (ParseException parseException) {
                throw new InvalidValueException(ConfigResponseMsgID.INVALID_REPEATER_ADDRESS, new String[]{string});
            }
        }
        try {
            if (!s_testMap.isUnderTest(SUBTEST_PROXY_REQD) && (networkConfiguration.isDisconnectedNetConfig() || networkConfiguration.testConnection() != null)) {
                return networkConfiguration;
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.UNRECOVERABLE_NETWORK_ERR, false));
            ConfigResponseCommand.Stderr.println(sSLPeerUnverifiedException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {}
        this.promptForProxy(networkConfiguration);
        return networkConfiguration;
    }

    void displayAgreement() throws FileNotFoundException {
        String string = FileSpec.catfile(new String[]{this.m_strOCMRoot, "doc", LICENSE_DOC});
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() == 0) {
                        ConfigResponseCommand.displayWrappedLines();
                        continue;
                    }
                    ConfigResponseCommand.displayWrappedLines(string2);
                }
            }
            catch (IOException iOException) {
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * Unable to fully structure code
     */
    protected void execute() throws ConfigCommandException {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = 0;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        while (!(var5_5 || var7_7 || var6_6 || var4_4++ >= CreateResponseCommand.PROMPT_LIMIT)) {
            var2_2 = this.promptForPrincipal();
            if (var2_2 == null) {
                var7_7 = true;
                continue;
            }
            if (var1_1 == null && (var3_3 = (var1_1 = this.determineNetworkPath()).getConnection()) == null) {
                var6_6 = true;
            }
            try {
                if (var6_6) continue;
                var2_2.validatePrincipal(var3_3, var1_1);
                var5_5 = true;
                continue;
            }
            catch (NetworkException var8_8) {
                var9_10 = var8_8.formatExceptionChain();
                var10_11 = var9_10.iterator();
                ** while (var10_11.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                ConfigResponseCommand.Stderr.println((String)var10_11.next());
                continue;
            }
lbl26:
            // 1 sources

            ConfigResponseCommand.Stderr.println();
        }
        if (!(var2_2 == null || var5_5 && !var6_6 || (var2_2 = (var8_9 = var2_2.getMetaLinkPrincipal()) != null ? new AnonymousMailRegistrationPrincipal(var8_9) : null) == null || var5_5 || var6_6)) {
            ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_MAX_MLUSER_PROMPT_EXCEEDED, false));
        }
        if (var2_2 == null && !var7_7) {
            if (!var6_6) {
                ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_MAX_MLUSER_PROMPT_EXCEEDED, false));
            }
            var2_2 = new AnonymousRegistrationPrincipal();
        }
        try {
            if (var7_7) {
                ConfigResponse.createResponseFile(this.m_strFilename, new LicenseAgreement(false), null, null);
            } else {
                ConfigResponse.createResponseFile(this.m_strFilename, new LicenseAgreement(true), var1_1, var2_2);
            }
        }
        catch (IOException v0) {
            throw new CreateCommandException(ConfigResponseMsgID.OCM_RESPONSE_NONWRITEABLE, new String[]{this.m_strFilename}, 11);
        }
        if (!(this.qualifierSet("-InstallPath") || this.qualifierSet("-reconfig") || this.m_bNoConfirmation)) {
            ConfigResponseCommand.displayLine(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_RESPONSE_FILE_CREATED, false, (Object[])new String[]{this.m_strFilename}));
        }
    }

    protected OCMRegistrationPrincipal getRegistrationPrincipal(EndPoint endPoint, NetworkConfiguration networkConfiguration) throws ConfigCommandException {
        return null;
    }

    protected OCMRegistrationPrincipal promptForPrincipal() throws ConfigCommandException {
        return null;
    }

    private void promptForProxy(NetworkConfiguration networkConfiguration) {
        boolean bl = false;
        while (!bl) {
            try {
                ConfigResponseCommand.displayWrappedLines();
                ConfigResponseCommand.displayWrappedLines(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_NO_NETWORK_CONNECTION, false));
                String string = this.promptForInput(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_PROXY_PROMPT, false));
                if (!this.validProxySpec(networkConfiguration, string)) continue;
                if (networkConfiguration.requiresProxyPwd()) {
                    char[] cArray = SecurePrompter.readResponse(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_PROXY_PWD_PROMPT, false));
                    byte[] byArray = new byte[cArray.length];
                    int n = 0;
                    while (n < byArray.length) {
                        byArray[n] = (byte)cArray[n];
                        ++n;
                    }
                    networkConfiguration.setProxyCreds(byArray);
                }
                try {
                    if (networkConfiguration.testProxyConnection() != null) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug("Proxy specification passed");
                        }
                        bl = true;
                        ConfigResponseCommand.Stdout.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_PROXY_CONFIG_CONFIRMED, false));
                        continue;
                    }
                    if (!networkConfiguration.isDisconnectedNetConfig()) continue;
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug("Proxy specification passed");
                    }
                    bl = true;
                }
                catch (ConnectionException connectionException) {
                    ConfigResponseCommand.Stderr.println(connectionException.getMessage());
                }
            }
            catch (UnknownHostException unknownHostException) {
                ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_PROXY_DETECTED_UNKNOWN_HOST, false));
            }
            catch (IOException iOException) {
                ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_READING_INPUT, false));
            }
        }
        ConfigResponseCommand.displayWrappedLines();
        if (!bl) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("No valid proxy specified - and completed the proxy loop");
            }
            networkConfiguration.setNoProxy();
        }
    }

    protected void promptForSupportPolicy() throws UnexpectedException {
        if (this.qualifierSet("-license")) {
            return;
        }
        String string = "";
        try {
            try {
                string = this.promptForInput(this.s_msgBundle.getMessage(ConfigResponseMsgID.OCM_LICENSE_PROMPT, false));
                ConfigResponseCommand.displayWrappedLines();
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Response is " + string);
                }
                if (string == null) {
                    string = "";
                }
                if ((string = string.trim().toUpperCase()).length() == 0) {
                    string = "N";
                }
                if (string.substring(0, 1).equals("Y")) {
                    this.displayAgreement();
                    ConfigResponseCommand.displayWrappedLines();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UnexpectedException(this.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_LICENSE_AGREEMENT_NOT_FOUND, false));
            }
        }
        catch (IOException iOException) {}
    }

    void setNoConfirmationMsg() {
        this.m_bNoConfirmation = true;
    }

    protected boolean validProxySpec(NetworkConfiguration networkConfiguration, String string) {
        boolean bl = false;
        try {
            networkConfiguration.setProxySpecification(string);
            bl = true;
        }
        catch (InvalidValueException invalidValueException) {
            ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_PORT, false));
        }
        catch (java.text.ParseException parseException) {
            ConfigResponseCommand.Stderr.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_SPECIFICATION, false));
        }
        catch (UnknownHostException unknownHostException) {
            ConfigResponseCommand.Stderr.println(unknownHostException.getMessage());
        }
        return bl;
    }
}

