/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ResponseFile;
import oracle.sysman.ccr.collector.install.ResponseNotFoundException;

class DisplayResponseCommand
extends ConfigResponseCommand {
    private static PrintStream Stdout = new PrintStream(System.out, true);
    private String m_strResponseFile;

    DisplayResponseCommand(String string) {
        this.m_strResponseFile = string;
    }

    static void displayVectorResults(Vector vector) {
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Stdout.println(iterator.next());
        }
    }

    void execute() throws ConfigCommandException {
        OCMRegistrationPrincipal oCMRegistrationPrincipal;
        ResponseFile responseFile;
        try {
            responseFile = ResponseFile.reconstituteResponseFile(this.m_strResponseFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResponseNotFoundException(new String[]{this.m_strResponseFile, fileNotFoundException.getMessage()});
        }
        Stdout.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_CREATION_DATE, false, (Object[])new String[]{responseFile.getCreationDate()}));
        Stdout.println(this.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_CREATOR, false, (Object[])new String[]{responseFile.getCreator()}));
        DisplayResponseCommand.displayVectorResults(responseFile.getLicenseInstance().verboseDisplay());
        NetworkConfiguration networkConfiguration = responseFile.getNetworkConfig();
        if (networkConfiguration != null) {
            DisplayResponseCommand.displayVectorResults(networkConfiguration.verboseDisplay());
        }
        if ((oCMRegistrationPrincipal = responseFile.getRegistrationPrincipal()) != null) {
            DisplayResponseCommand.displayVectorResults(oCMRegistrationPrincipal.verboseDisplay());
        }
    }
}

