/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.util.Vector;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeException;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeMap;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConfigurationResponseInfo;
import oracle.sysman.ccr.collector.install.MetaLinkEmailPrincipal;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;

public class MetaLinkCSIPrincipal
extends OCMRegistrationPrincipal {
    static final long serialVersionUID = 3470915378307111412L;
    private String m_strMetaLinkID;
    private String m_strCSI;
    private int m_nCountryCode;

    MetaLinkCSIPrincipal(String string, String string2, int n) {
        super(null);
        this.m_strMetaLinkID = string;
        this.m_strCSI = string2;
        this.m_nCountryCode = n;
    }

    public MetaLinkCSIPrincipal(String string, String string2, int n, String string3) {
        super(string3);
        this.m_strMetaLinkID = string;
        this.m_strCSI = string2;
        this.m_nCountryCode = n;
    }

    void addConfigurationProperties(ConfigWriter configWriter, ConfigWriter configWriter2) {
        configWriter.setProperty("ccr.registration_mode", "csi");
        configWriter.setProperty("ccr.support_id", this.m_strCSI);
        configWriter.setProperty("ccr.country_code", this.getCountryCode());
        configWriter.setProperty("ccr.registration_ct", this.getCipherText());
    }

    private String getCountryCode() {
        String string;
        try {
            CountryCodeMap countryCodeMap = CountryCodeMap.getInstance();
            string = countryCodeMap.getCountryCode(this.m_nCountryCode);
        }
        catch (CountryCodeException countryCodeException) {
            string = "UNKNOWN";
        }
        return string;
    }

    protected String getMetaLinkPrincipal() {
        if (MetaLinkEmailPrincipal.validAddress(this.m_strMetaLinkID)) {
            return this.m_strMetaLinkID;
        }
        return super.getMetaLinkPrincipal();
    }

    protected void validatePrincipal(EndPoint endPoint, NetworkConfiguration networkConfiguration) throws NetworkException {
        OCMEndPoint oCMEndPoint = new OCMEndPoint(endPoint);
        String string = null;
        string = oCMEndPoint.authenticateUser(this.m_strMetaLinkID, this.m_strCSI, this.m_nCountryCode);
        this.setCipherText(string);
    }

    Vector verboseDisplay() {
        Vector<String> vector = new Vector<String>();
        vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REG_TYPE, false, (Object[])new String[]{ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REG_TYPE_CSI, false)}));
        vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REG_CSI_VALUES, false, (Object[])new String[]{this.m_strMetaLinkID, this.m_strCSI, this.getCountryCode()}));
        return vector;
    }
}

