/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConfigurationResponseInfo;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.util.crypt.Crypt;

public class MetaLinkEmailPrincipal
extends OCMRegistrationPrincipal {
    static final long serialVersionUID = 6216134147945871037L;
    private String m_strUsername;
    private transient byte[] m_arrayPassword;
    private String m_strPasswordSeed;
    private String m_strPasswordObf;

    MetaLinkEmailPrincipal(String string, byte[] byArray) {
        super(null);
        this.m_strUsername = string;
        this.m_arrayPassword = byArray;
    }

    public MetaLinkEmailPrincipal(String string, byte[] byArray, String string2) {
        super(string2);
        this.m_strUsername = string;
        this.m_arrayPassword = byArray;
    }

    void addConfigurationProperties(ConfigWriter configWriter, ConfigWriter configWriter2) {
        configWriter.setProperty("ccr.registration_mode", "email");
        configWriter.setProperty("ccr.registration_ct", this.getCipherText());
        configWriter.setProperty("ccr.metalink_email.address", this.m_strUsername);
    }

    protected String getMetaLinkPrincipal() {
        return this.getMetaLinkUsername();
    }

    byte[] getMetaLinkPwd() {
        return this.m_arrayPassword;
    }

    String getMetaLinkUsername() {
        return this.m_strUsername;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Crypt crypt = new Crypt();
        objectInputStream.defaultReadObject();
        if (this.m_strPasswordSeed != null && this.m_strPasswordObf != null) {
            this.m_arrayPassword = crypt.decrypt(this.m_strPasswordObf, this.m_strPasswordSeed).getBytes();
        }
    }

    public static boolean validAddress(String string) {
        String string2 = string.trim();
        int n = string2.indexOf("@");
        if (n < 0) {
            return false;
        }
        int n2 = string2.lastIndexOf(".");
        return n2 > n && n2 < string2.length() - 1;
    }

    protected void validatePrincipal(EndPoint endPoint, NetworkConfiguration networkConfiguration) throws NetworkException {
        OCMEndPoint oCMEndPoint = new OCMEndPoint(endPoint);
        String string = null;
        string = oCMEndPoint.authenticateUser(this.m_strUsername, this.m_arrayPassword);
        this.setCipherText(string);
    }

    Vector verboseDisplay() {
        Vector<String> vector = new Vector<String>();
        vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REG_TYPE, false, (Object[])new String[]{ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REG_TYPE_MLID, false)}));
        vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REG_MLID_VALUES, false, (Object[])new String[]{this.getMetaLinkUsername()}));
        return vector;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Crypt crypt = new Crypt();
        this.m_strPasswordSeed = Long.toString(Math.abs(ConfigurationResponseInfo.s_secureRandom.nextLong()));
        this.m_strPasswordObf = crypt.encrypt(new String(this.m_arrayPassword), this.m_strPasswordSeed);
        objectOutputStream.defaultWriteObject();
    }
}

