/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConfigurationResponseInfo;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.TestMap;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.SSLInitializationException;
import oracle.sysman.ccr.util.Host;
import oracle.sysman.ccr.util.OCMProxySpec;
import oracle.sysman.ccr.util.OCMProxySpecException;
import oracle.sysman.util.crypt.Crypt;
import org.apache.regexp.RE;

public class NetworkConfiguration
extends ConfigurationResponseInfo
implements AuthorizationPrompter {
    static final long serialVersionUID = 879263700195084067L;
    public static final String NO_PROXY = "NONE";
    private static final int DEFAULT_PROXY_PORT = 80;
    private static final int SEC_15 = 15000;
    private static final int MAX_PORT_NUMBER = 65535;
    static final String NO_REPEATER = "NONE";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String PROXY_USER = "http.proxyUser";
    public static final String PROXY_PWD = "http.proxyPassword";
    public static final String PROXY_SEED = "ccr.proxypswd.seed";
    public static final String DISCONNECTED = "ccr.disconnected";
    private static final String SUBTEST_NO_DIRECT_CONNECTION = "noDirectConnection";
    private static final String PROXY_REGEXP = "^((.*?)@)?([^@:]+)(:(\\d+))?$";
    private static final int PROXY_REGEXP_USER = 2;
    private static final int PROXY_REGEXP_HOST = 3;
    private static final int PROXY_REGEXP_PORT = 5;
    private static RE s_proxyRegExp;
    private static int s_nDefaultConnectionTimeout;
    private static Logger s_logger;
    private static TestMap s_testMap;
    private transient EndPointAddr m_endPointAddr;
    private boolean m_bProxyNONE = false;
    private String m_strHost = "";
    private int m_nPort = 80;
    private String m_strUsername = null;
    private transient byte[] m_arrayChPwd = null;
    private String m_strProxySeed = null;
    private String m_strProxyPwdObfuscated = null;
    private String m_strRepeaterURI = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$install$NetworkConfiguration;

    static {
        s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$install$NetworkConfiguration != null ? class$oracle$sysman$ccr$collector$install$NetworkConfiguration : (class$oracle$sysman$ccr$collector$install$NetworkConfiguration = NetworkConfiguration.class$("oracle.sysman.ccr.collector.install.NetworkConfiguration")));
        s_testMap = new TestMap(class$oracle$sysman$ccr$collector$install$NetworkConfiguration != null ? class$oracle$sysman$ccr$collector$install$NetworkConfiguration : (class$oracle$sysman$ccr$collector$install$NetworkConfiguration = NetworkConfiguration.class$("oracle.sysman.ccr.collector.install.NetworkConfiguration")));
        s_nDefaultConnectionTimeout = HTTPConnection.getDefaultConnectionTimeout();
    }

    public NetworkConfiguration() {
        try {
            this.m_endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("EndPoint configured as: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater());
        }
        this.resetProxyInformation();
        EndPoint.setAuthorizationHandler(this);
    }

    void addConfigurationProperties(ConfigWriter configWriter, ConfigWriter configWriter2) {
        if (this.m_bProxyNONE) {
            configWriter2.setProperty(DISCONNECTED, new Boolean(true).toString());
        } else if (this.m_strHost.trim().length() > 0) {
            configWriter.setProperty(PROXY_HOST, this.m_strHost.trim());
            if (this.m_nPort > 0 && this.m_nPort != 80) {
                configWriter.setProperty(PROXY_PORT, Integer.toString(this.m_nPort));
            }
            if (this.m_strUsername != null && this.m_strUsername.trim().length() > 0) {
                configWriter.setProperty(PROXY_USER, this.m_strUsername);
                if (this.m_strProxySeed != null && this.m_strProxySeed.length() > 0) {
                    configWriter.setProperty(PROXY_SEED, this.m_strProxySeed);
                    configWriter.setProperty(PROXY_PWD, this.m_strProxyPwdObfuscated);
                } else {
                    Crypt crypt = new Crypt();
                    String string = Long.toString(Math.abs(ConfigurationResponseInfo.s_secureRandom.nextLong()));
                    String string2 = crypt.encrypt(new String(this.m_arrayChPwd), string);
                    configWriter.setProperty(PROXY_SEED, string);
                    configWriter.setProperty(PROXY_PWD, string2);
                }
            }
        }
        if (this.m_strRepeaterURI != null && !this.m_strRepeaterURI.equals("NONE")) {
            configWriter.setProperty("ccr.endpoint", this.m_strRepeaterURI);
            configWriter.setProperty("ccr.endpoint.is_repeater", Boolean.TRUE.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private EndPoint connect() throws SSLPeerUnverifiedException, UnknownHostException, IOException {
        EndPoint endPoint = null;
        try {
            try {
                HTTPConnection.setDefaultTimeout(15000);
                HTTPConnection.setDefaultConnectionTimeout(15000);
                endPoint = new EndPoint(this.m_endPointAddr, this.populateProxyProperties());
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Endpoint created for connection");
                }
            }
            catch (SSLInitializationException sSLInitializationException) {
                throw new RuntimeException(sSLInitializationException.getMessage());
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException.getMessage());
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException.getMessage());
            }
            catch (ProtocolNotSuppException protocolNotSuppException) {
                throw new RuntimeException(protocolNotSuppException.getMessage());
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            HTTPConnection.setDefaultConnectionTimeout(s_nDefaultConnectionTimeout);
            throw throwable;
        }
        HTTPConnection.setDefaultConnectionTimeout(s_nDefaultConnectionTimeout);
        return endPoint;
    }

    public void declineRepeater() {
        this.m_strRepeaterURI = "NONE";
        try {
            this.m_endPointAddr = new EndPointAddr(UplinkSystemConfig.getOCMServiceEndPoint().getEndPointString(), false);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("EndPoint set to: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater());
        }
    }

    static void filterConfigurationProperties(ConfigWriter configWriter, ConfigWriter configWriter2, ConfigurationResponseInfo configurationResponseInfo) {
        boolean bl;
        NetworkConfiguration networkConfiguration = null;
        if (configurationResponseInfo instanceof NetworkConfiguration) {
            networkConfiguration = (NetworkConfiguration)configurationResponseInfo;
        }
        configWriter2.removeProperty(DISCONNECTED);
        configWriter.removeProperty(PROXY_SEED);
        configWriter.removeProperty(PROXY_HOST);
        configWriter.removeProperty(PROXY_PORT);
        configWriter.removeProperty(PROXY_USER);
        configWriter.removeProperty(PROXY_PWD);
        String string = configWriter.propertyValue("ccr.endpoint.is_repeater");
        if (string != null && (bl = Boolean.valueOf(string).booleanValue()) && networkConfiguration.m_strRepeaterURI != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("The System Config indicates a repeater property.Removing the endpoint and the is_repeater properties.");
            }
            configWriter.removeProperty("ccr.endpoint.is_repeater");
            configWriter.removeProperty("ccr.endpoint");
        }
    }

    public EndPoint getConnection() {
        EndPoint endPoint = null;
        try {
            endPoint = this.testConnection(false);
        }
        catch (IOException iOException) {
            endPoint = null;
        }
        return endPoint;
    }

    public NVPair getUsernamePassword(AuthorizationInfo authorizationInfo, boolean bl) {
        NVPair nVPair = null;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Proxy Authorization being requested");
        }
        if (this.m_strUsername != null && this.m_arrayChPwd != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(String.valueOf(this.getClass().getName()) + " returning proxy credentials (" + this.m_strUsername + ", ******)");
            }
            nVPair = new NVPair(this.m_strUsername, new String(this.m_arrayChPwd));
        }
        return nVPair;
    }

    public boolean isDisconnectedNetConfig() {
        return this.m_bProxyNONE;
    }

    private Properties populateProxyProperties() {
        Properties properties = new Properties();
        if (!this.m_bProxyNONE && this.m_strHost != null && this.m_strHost.length() > 0) {
            ((Hashtable)properties).put(PROXY_HOST, this.m_strHost);
        }
        if (this.m_nPort != 80) {
            ((Hashtable)properties).put(PROXY_PORT, Integer.toString(this.m_nPort));
        }
        return properties;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Crypt crypt = new Crypt();
        objectInputStream.defaultReadObject();
        if (this.m_strProxyPwdObfuscated != null && this.m_strProxySeed != null) {
            this.m_arrayChPwd = crypt.decrypt(this.m_strProxyPwdObfuscated, this.m_strProxySeed).getBytes();
        }
    }

    public boolean requiresProxyPwd() {
        boolean bl = false;
        if (this.m_strUsername != null && this.m_strUsername.trim().length() > 0 && this.m_arrayChPwd == null) {
            bl = true;
        }
        return bl;
    }

    public void resetProxyInformation() {
        this.m_strHost = "";
        this.m_nPort = 80;
        this.m_strUsername = null;
        this.m_arrayChPwd = null;
        this.m_bProxyNONE = false;
    }

    public void resetRepeaterURI() {
        this.m_strRepeaterURI = null;
        try {
            this.m_endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("EndPoint reset to: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater());
        }
    }

    public void setNoProxy() {
        this.resetProxyInformation();
        this.m_bProxyNONE = true;
    }

    public void setProxyCreds(String string, byte[] byArray) {
        this.m_bProxyNONE = false;
        this.m_strUsername = string;
        this.m_arrayChPwd = byArray;
    }

    void setProxyCreds(byte[] byArray) {
        this.m_bProxyNONE = false;
        this.m_arrayChPwd = byArray;
    }

    public void setProxyHost(String string) throws UnknownHostException {
        if (string.equals("NONE")) {
            this.setNoProxy();
        } else {
            if (!Host.isValidHostname(string)) {
                throw new UnknownHostException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_UNKNOWN_PROXY_HOST, false, (Object[])new String[]{string}));
            }
            this.m_bProxyNONE = false;
            this.m_strHost = string;
        }
    }

    public void setProxyPort(int n) throws InvalidValueException {
        if (n <= 0 || n > 65535) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_PROXY_PORT);
        }
        this.m_bProxyNONE = false;
        this.m_nPort = n;
    }

    void setProxySpecification(String string) throws InvalidValueException, java.text.ParseException, UnknownHostException {
        boolean bl = false;
        OCMProxySpec oCMProxySpec = new OCMProxySpec();
        try {
            oCMProxySpec.validateAndParse(string);
        }
        catch (OCMProxySpecException oCMProxySpecException) {
            switch (oCMProxySpecException.getRetCode()) {
                case 1: {
                    throw new java.text.ParseException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_SPECIFICATION, false), 0);
                }
                case 2: {
                    throw new UnknownHostException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.ERR_UNKNOWN_PROXY_HOST, false, (Object[])new String[]{oCMProxySpecException.getParsedValue()}));
                }
                case 3: {
                    throw new InvalidValueException(ConfigResponseMsgID.INVALID_PROXY_PORT);
                }
            }
            throw new java.text.ParseException(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.INVALID_PROXY_SPECIFICATION, false), 0);
        }
        this.m_bProxyNONE = oCMProxySpec.isProxyNone();
        this.m_nPort = oCMProxySpec.getProxyPort();
        this.m_strHost = oCMProxySpec.getProxyHost();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Proxy host set to: " + this.m_strHost);
        }
        this.m_strUsername = oCMProxySpec.getProxyUser();
        if (this.m_strUsername != null) {
            this.m_strUsername = this.m_strUsername.trim();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Proxy username specified with value of: " + this.m_strUsername);
            }
        }
        this.m_arrayChPwd = null;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Connection properties will be: " + this.populateProxyProperties());
        }
    }

    public void setRepeaterURI(URI uRI) throws InvalidValueException {
        String string = uRI.getScheme();
        if (!EndPoint.isValidScheme(string)) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_REPEATER_SCHEME);
        }
        String string2 = uRI.getHost();
        if (!Host.isValidHostname(string2)) {
            throw new InvalidValueException(ConfigResponseMsgID.ERR_UNKNOWN_REPEATER_HOST, new String[]{string2});
        }
        int n = uRI.getPort();
        if (n != -1 && (n <= 0 || n > 65535)) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_REPEATER_PORT);
        }
        String string3 = uRI.getPathAndQuery();
        if (string3 != null && string3.length() > 0) {
            throw new InvalidValueException(ConfigResponseMsgID.INVALID_REPEATER_PATH);
        }
        this.m_strRepeaterURI = uRI.toExternalForm();
        try {
            this.m_endPointAddr = new EndPointAddr(this.m_strRepeaterURI, true);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException.getMessage());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("EndPoint set to: " + this.m_endPointAddr.getURI() + " is_repeater = " + this.m_endPointAddr.getIsRepeater());
        }
    }

    public EndPoint testConnection() throws UnknownHostException, SSLPeerUnverifiedException, IOException {
        return this.testConnection(true);
    }

    private EndPoint testConnection(boolean bl) throws UnknownHostException, SSLPeerUnverifiedException, IOException {
        EndPoint endPoint = null;
        if (this.m_bProxyNONE || bl && s_testMap.isUnderTest(SUBTEST_NO_DIRECT_CONNECTION)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Returning a NULL to a testConnnection request. ProxyNone: " + this.m_bProxyNONE + ", subTestEnabled: " + bl + ", underTest: " + s_testMap.isUnderTest(SUBTEST_NO_DIRECT_CONNECTION));
            }
            endPoint = null;
        } else {
            endPoint = this.connect();
        }
        return endPoint;
    }

    public EndPoint testProxyConnection() throws ConnectionException {
        EndPoint endPoint = null;
        if (this.m_bProxyNONE) {
            return null;
        }
        try {
            endPoint = this.connect();
            HTTPResponse hTTPResponse = null;
            String string = "/em/upload";
            if (this.m_endPointAddr.getIsRepeater()) {
                string = "/ocmrepeater/testIt";
            }
            hTTPResponse = endPoint.get(string);
            int n = hTTPResponse.getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Returned from the get " + string + " with a status code of: " + n);
            }
            if (n >= 300) {
                switch (n) {
                    case 408: {
                        throw new ConnectionException(ConfigResponseMsgID.HTTP_CLIENT_TIMEOUT);
                    }
                    case 403: {
                        throw new ConnectionException(ConfigResponseMsgID.HTTP_FORBIDDEN);
                    }
                    case 500: {
                        throw new ConnectionException(ConfigResponseMsgID.HTTP_INTERNAL_ERROR, new Object[]{new Integer(n)});
                    }
                    case 407: {
                        throw new ConnectionException(ConfigResponseMsgID.HTTP_PROXY_AUTH);
                    }
                }
                throw new ConnectionException(ConfigResponseMsgID.HTTP_UNKNOWN, new Object[]{new Integer(n), hTTPResponse.getText()});
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ModuleException moduleException) {
            throw new ConnectionException(ConfigResponseMsgID.HTTP_UNKNOWN, new Object[]{new Integer(-1), moduleException.getMessage()});
        }
        catch (ParseException parseException) {
            throw new ConnectionException(ConfigResponseMsgID.HTTP_UNKNOWN, new Object[]{new Integer(-1), parseException.getMessage()});
        }
        return endPoint;
    }

    Vector verboseDisplay() {
        CharSequence charSequence;
        Vector<String> vector = new Vector<String>();
        String string = this.m_bProxyNONE ? ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_STATE_DISCONNECTED, false) : ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_STATE_CONNECTED, false);
        vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_CONNSTATE, false, (Object[])new String[]{string}));
        if (!this.m_bProxyNONE) {
            charSequence = new StringBuffer();
            if (this.m_strUsername != null && this.m_strUsername.length() > 0) {
                ((StringBuffer)charSequence).append(this.m_strUsername);
                ((StringBuffer)charSequence).append("/********@");
            }
            if (this.m_strHost != null && this.m_strHost.length() > 0) {
                ((StringBuffer)charSequence).append(this.m_strHost);
                if (this.m_nPort != 80) {
                    ((StringBuffer)charSequence).append(":" + this.m_nPort);
                }
            }
            if (((StringBuffer)charSequence).length() == 0) {
                ((StringBuffer)charSequence).append(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_PROXY_UNSPECIFIED, false));
            }
            vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_NET_PROXY_CONFIG, false, (Object[])new String[]{((StringBuffer)charSequence).toString()}));
        }
        if (this.m_strRepeaterURI != null) {
            charSequence = this.m_strRepeaterURI;
            if (((String)charSequence).equals("NONE")) {
                charSequence = ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REPEATER_DISABLED, false);
            }
            vector.add(ConfigurationResponseInfo.s_msgBundle.getMessage(ConfigResponseMsgID.VERBOSE_REPEATER_CONFIG, false, (Object[])new String[]{charSequence}));
        }
        return vector;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_strUsername != null && this.m_strUsername.trim().length() > 0) {
            Crypt crypt = new Crypt();
            this.m_strProxySeed = Long.toString(Math.abs(ConfigurationResponseInfo.s_secureRandom.nextLong()));
            this.m_strProxyPwdObfuscated = crypt.encrypt(new String(this.m_arrayChPwd), this.m_strProxySeed);
        }
        objectOutputStream.defaultWriteObject();
    }
}

