/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.FileNotFoundException;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.ResponseFile;
import oracle.sysman.ccr.collector.install.ResponseNotFoundException;

class QueryResponseCommand
extends ConfigResponseCommand {
    private static final String LICENSE = "license.accepted";
    private static final String DISCONNECTED = "network_config.disconnected";
    String m_strData;
    String m_strResponseFile;

    QueryResponseCommand(String string, String string2) {
        this.m_strData = string;
        this.m_strResponseFile = string2;
    }

    void execute() throws ConfigCommandException {
        ResponseFile responseFile;
        try {
            responseFile = ResponseFile.reconstituteResponseFile(this.m_strResponseFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResponseNotFoundException(new String[]{this.m_strResponseFile, fileNotFoundException.getMessage()});
        }
        LicenseAgreement licenseAgreement = responseFile.getLicenseInstance();
        NetworkConfiguration networkConfiguration = responseFile.getNetworkConfig();
        if (this.m_strData.equals(LICENSE)) {
            ConfigResponseCommand.Stdout.println(licenseAgreement.licenseAccepted());
        } else if (this.m_strData.equals(DISCONNECTED)) {
            if (networkConfiguration != null) {
                ConfigResponseCommand.Stdout.println(networkConfiguration.isDisconnectedNetConfig());
            } else {
                ConfigResponseCommand.Stdout.println(false);
            }
        }
    }
}

