/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.RegistrationInfo;
import oracle.sysman.ccr.collector.security.AnonAuthenticationKey;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.CSIAuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIV2AuthenticationKey;
import oracle.sysman.ccr.collector.security.DisconnectedAuthenticationKey;
import oracle.sysman.ccr.collector.security.EmailAuthenticationKey;
import oracle.sysman.ccr.collector.security.UnregisteredException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;
import oracle.sysman.ccr.util.FileSpec;

public abstract class AuthenticationKey {
    static final String KEY_VERSION_V2 = "2.0";
    static final String KEY_VERSION_V3 = "3.0";
    static final String LIVELINK_REGISTRATION_STORE = "uplinkreg.bin";
    protected static final String KEY_VERSION = "key.version";
    protected static final String KEY_STR = "key.value";
    protected static final String KEY_GCID = "key.id";
    protected static final String KEY_DATE = "key.registered";
    protected static final String KEY_REG_METHOD = "key.registration_method";
    protected static final String KEY_UNIQUE_CSI = "key.registered_w_uniqueCSI";
    static final Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$security$AuthenticationKey != null ? class$oracle$sysman$ccr$collector$security$AuthenticationKey : (class$oracle$sysman$ccr$collector$security$AuthenticationKey = AuthenticationKey.class$("oracle.sysman.ccr.collector.security.AuthenticationKey")));
    static final SimpleDateFormat s_dateFormatRegistration = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private String m_strKeyVersion = "";
    private String m_strClientKey = "";
    private String m_strGCID = "";
    private String m_strRegistrationDate = null;
    private Boolean m_booleanUniqueCSI = new Boolean(true);
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$security$AuthenticationKey;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getGCID() {
        return this.m_strGCID;
    }

    public String getKey() {
        return this.m_strClientKey;
    }

    protected abstract String getKeyVersion();

    abstract String getRegistrationMethod();

    public boolean holdsUniqueCSI() {
        return this.m_booleanUniqueCSI;
    }

    protected void initFromProps(Properties properties) throws UnregisteredException, AuthenticationFailure {
        this.m_strClientKey = properties.getProperty(KEY_STR);
        this.m_strGCID = properties.getProperty(KEY_GCID);
        this.m_strRegistrationDate = properties.getProperty(KEY_DATE);
        this.m_booleanUniqueCSI = new Boolean(properties.getProperty(KEY_UNIQUE_CSI));
        s_log.debug("registration info: GCID:client_key:UniqueCSI" + this.m_strGCID + ":" + this.m_strClientKey + ":" + this.m_booleanUniqueCSI.toString());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthenticationKey instantiate() throws AuthenticationFailure {
        void var0_6;
        Object var0 = null;
        s_log.debug("AuthenticationKey ctor");
        if (!Collector.isDisconnected()) {
            Properties properties = AuthenticationKey.loadKeyFile();
            String string = properties.getProperty(KEY_REG_METHOD);
            if (string != null) {
                if (string.equals(CSIAuthenticationKey.getRegistrationMethodConst())) {
                    CSIAuthenticationKey cSIAuthenticationKey = new CSIAuthenticationKey(properties);
                    return var0_6;
                } else if (string.equals(EmailAuthenticationKey.getRegistrationMethodConst())) {
                    EmailAuthenticationKey emailAuthenticationKey = new EmailAuthenticationKey(properties);
                    return var0_6;
                } else {
                    if (!string.equals(AnonAuthenticationKey.getRegistrationMethodConst())) throw new AuthenticationFailure("Unknown registration method - " + string);
                    AnonAuthenticationKey anonAuthenticationKey = new AnonAuthenticationKey(properties);
                }
                return var0_6;
            } else {
                String string2 = properties.getProperty(KEY_VERSION);
                if (!string2.equals(KEY_VERSION_V2)) return var0_6;
                CSIV2AuthenticationKey cSIV2AuthenticationKey = new CSIV2AuthenticationKey(properties);
            }
            return var0_6;
        } else {
            s_log.debug(" in disconnected mode");
            DisconnectedAuthenticationKey disconnectedAuthenticationKey = new DisconnectedAuthenticationKey();
        }
        return var0_6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadKeyFile() throws UnregisteredException, AuthenticationFailure {
        Properties properties = new Properties();
        String string = FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), "config", "default", LIVELINK_REGISTRATION_STORE});
        FileInputStream fileInputStream = null;
        s_log.debug("reading authentication data from file " + string);
        try {
            try {
                fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                properties.load(bufferedInputStream);
            }
            catch (SecurityException securityException) {
                throw new AuthenticationFailure("Unable to open Oracle Configuration Manager registration file", securityException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UnregisteredException();
            }
            catch (IOException iOException) {
                throw new AuthenticationFailure("Unable to read Oracle Configuration Manager registration information", iOException);
            }
            Object var4_6 = null;
            if (fileInputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void persistKeyFile(Properties properties) throws AuthenticationFailure {
        block9: {
            this.validateKey();
            String string = FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), "config", "default", LIVELINK_REGISTRATION_STORE});
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(string);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    properties.store(bufferedOutputStream, "");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new AuthenticationFailure("Unable to persist the registration data", fileNotFoundException);
                }
                catch (SecurityException securityException) {
                    throw new AuthenticationFailure("Unable to persist the registration data", securityException);
                }
                catch (IOException iOException) {
                    throw new AuthenticationFailure("Unable to persist the registration data", iOException);
                }
                Object var5_8 = null;
                if (fileOutputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            fileOutputStream.close();
        }
        s_log.debug("registration info (from XML): " + this.m_strGCID + ":" + this.m_strClientKey);
    }

    protected Properties setProperties(RegistrationKeyDoc registrationKeyDoc, RegistrationInfo registrationInfo) throws AuthenticationFailure {
        this.m_strClientKey = registrationKeyDoc.getKey();
        this.m_strGCID = registrationKeyDoc.getGCID();
        this.m_booleanUniqueCSI = registrationKeyDoc.holdsUniqueCSI();
        this.m_strRegistrationDate = s_dateFormatRegistration.format(new Date());
        Properties properties = new Properties();
        ((Hashtable)properties).put(KEY_STR, this.m_strClientKey);
        ((Hashtable)properties).put(KEY_GCID, this.m_strGCID);
        ((Hashtable)properties).put(KEY_DATE, this.m_strRegistrationDate);
        ((Hashtable)properties).put(KEY_VERSION, this.getKeyVersion());
        ((Hashtable)properties).put(KEY_REG_METHOD, this.getRegistrationMethod());
        ((Hashtable)properties).put(KEY_UNIQUE_CSI, this.m_booleanUniqueCSI.toString());
        return properties;
    }

    protected void validateKey() throws AuthenticationFailure {
        if (this.m_strKeyVersion == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing KeyID");
        }
        if (this.m_strClientKey == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing key");
        }
        if (this.m_strGCID == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing gcid");
        }
    }
}

