/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.security;

import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.collector.cmd.CSIRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.RegistrationInfo;
import oracle.sysman.ccr.collector.countryCodes.CountryCode;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeException;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeMap;
import oracle.sysman.ccr.collector.countryCodes.NoSuchCountryCodeException;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.CipherTextAuthenticationKey;
import oracle.sysman.ccr.collector.security.UnregisteredException;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;

public class CSIAuthenticationKey
extends CipherTextAuthenticationKey {
    private static final String KEY_REGISTRATION_METHOD_VAL = "CSI";
    private static final String KEY_REGISTRATION_CSI = "key.registration.CSI";
    private static final String KEY_REGISTRATION_MLID = "key.registration.CSI.metalinkId";
    private static final String KEY_REGISTRATION_COUNTRY = "key.registration.CSI.countryCode";
    private String m_strCSI;
    private String m_strMLID;
    private int m_nCountryCode;

    CSIAuthenticationKey(Properties properties) throws UnregisteredException, AuthenticationFailure {
        CountryCode countryCode;
        super.initFromProps(properties);
        this.m_strCSI = properties.getProperty(KEY_REGISTRATION_CSI);
        this.m_strMLID = properties.getProperty(KEY_REGISTRATION_MLID);
        String string = properties.getProperty(KEY_REGISTRATION_COUNTRY);
        try {
            countryCode = CountryCodeMap.getInstance().getCountryCode(string);
        }
        catch (NoSuchCountryCodeException noSuchCountryCodeException) {
            throw new AuthenticationFailure("Invalid country code found.", noSuchCountryCodeException);
        }
        catch (CountryCodeException countryCodeException) {
            throw new AuthenticationFailure("Invalid country code found.", countryCodeException);
        }
        this.m_nCountryCode = countryCode.getValue();
        this.validateKey();
    }

    public CSIAuthenticationKey(RegistrationKeyDoc registrationKeyDoc, CSIRegistrationInfo cSIRegistrationInfo) throws AuthenticationFailure {
        Properties properties = this.setProperties(registrationKeyDoc, cSIRegistrationInfo);
        this.persistKeyFile(properties);
    }

    protected String getKeyVersion() {
        return "3.0";
    }

    protected String getRegistrationMethod() {
        return CSIAuthenticationKey.getRegistrationMethodConst();
    }

    static String getRegistrationMethodConst() {
        return KEY_REGISTRATION_METHOD_VAL;
    }

    protected Properties setProperties(RegistrationKeyDoc registrationKeyDoc, RegistrationInfo registrationInfo) throws AuthenticationFailure {
        CSIRegistrationInfo cSIRegistrationInfo = (CSIRegistrationInfo)registrationInfo;
        Properties properties = super.setProperties(registrationKeyDoc, registrationInfo);
        this.m_strCSI = cSIRegistrationInfo.getCSI();
        this.m_strMLID = cSIRegistrationInfo.getMLID();
        this.m_nCountryCode = cSIRegistrationInfo.getCountryCode();
        try {
            CountryCodeMap countryCodeMap = CountryCodeMap.getInstance();
            ((Hashtable)properties).put(KEY_REGISTRATION_CSI, this.m_strCSI);
            ((Hashtable)properties).put(KEY_REGISTRATION_MLID, this.m_strMLID);
            ((Hashtable)properties).put(KEY_REGISTRATION_COUNTRY, countryCodeMap.getCountryCode(this.m_nCountryCode));
        }
        catch (CountryCodeException countryCodeException) {
            throw new AuthenticationFailure("Failed to save registration information.", countryCodeException);
        }
        return properties;
    }

    protected void validateKey() throws AuthenticationFailure {
        super.validateKey();
        if (this.m_strCSI == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing CSI");
        }
        if (this.m_strMLID == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing MetaLinkID");
        }
        if (this.m_nCountryCode == -1) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing CountryCode");
        }
    }
}

