/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.security;

import java.util.Properties;
import oracle.sysman.ccr.collector.cmd.CipherTextRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.RegistrationInfo;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.AuthenticationKey;
import oracle.sysman.ccr.collector.security.UnregisteredException;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;

abstract class CipherTextAuthenticationKey
extends AuthenticationKey {
    private static final String KEY_REGISTRATION_CIPHERTEXT = "key.ciphertext";
    private String m_strCipherText = null;

    CipherTextAuthenticationKey() {
    }

    protected String getCipherText() {
        return this.m_strCipherText;
    }

    protected void initFromProps(Properties properties) throws UnregisteredException, AuthenticationFailure {
        super.initFromProps(properties);
        this.m_strCipherText = properties.getProperty(KEY_REGISTRATION_CIPHERTEXT);
    }

    protected Properties setProperties(RegistrationKeyDoc registrationKeyDoc, RegistrationInfo registrationInfo) throws AuthenticationFailure {
        Properties properties = super.setProperties(registrationKeyDoc, registrationInfo);
        CipherTextRegistrationInfo cipherTextRegistrationInfo = (CipherTextRegistrationInfo)registrationInfo;
        this.m_strCipherText = cipherTextRegistrationInfo.getCipherText();
        properties.setProperty(KEY_REGISTRATION_CIPHERTEXT, this.m_strCipherText);
        return properties;
    }

    protected void validateKey() throws AuthenticationFailure {
        super.validateKey();
        if (this.m_strCipherText == null) {
            throw new AuthenticationFailure("Incomplete registration. Please register again. Keystate missing EmailID");
        }
    }
}

