/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.softwareMgr;

import HTTPClient.ParseException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CSIRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.softwareMgr.ClientAction;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CSIRegistrationAction
extends ClientAction {
    private String m_strCSI = null;
    private int m_nCountryCode = -1;
    private String m_strCipherText = null;

    CSIRegistrationAction(Attributes attributes) throws SAXException {
        this.m_strCSI = attributes.getValue("CSI");
        if (this.m_strCSI == null || this.m_strCSI.length() == 0) {
            throw new SAXException("Missing CSI from CSIRegistrationAction");
        }
        this.m_strCipherText = attributes.getValue("REGISTRATION_CIPHER");
        if (this.m_strCipherText == null || this.m_strCipherText.length() == 0) {
            throw new SAXException("Missing CipherText in the CSIRegistrationAction");
        }
        String string = attributes.getValue("COUNTRY_CODE");
        if (string == null || string.length() == 0) {
            throw new SAXException("Missing CountryCode in the CSIRegistrationAction");
        }
        this.m_nCountryCode = Integer.parseInt(string);
    }

    public void executeAction() throws NetworkException, CommandException {
        EndPointAddr endPointAddr = null;
        try {
            endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            if (endPointAddr == null) {
                throw new NetworkException("Oracle Configuration Manager endpoint unknown");
            }
            CSIRegistrationInfo cSIRegistrationInfo = CSIRegistrationInfo.authenticateAndPersist(this.m_strCSI, this.m_nCountryCode, this.m_strCipherText);
            String string = Hostname.getHostname();
            String string2 = Collector.getOracleHome();
            String string3 = Collector.getConfigHome();
            OCMEndPoint oCMEndPoint = new OCMEndPoint(endPointAddr);
            cSIRegistrationInfo.registerInstallation(oCMEndPoint, string, string2, string3);
            CollectionMgr.getInstance().clearGCCollectionUpload();
        }
        catch (AuthenticationFailure authenticationFailure) {
            throw new CommandException("Failed to re-register with CSI returned with getUpdates.", (Throwable)authenticationFailure);
        }
        catch (ParseException parseException) {
            throw new NetworkException("OCM Endpoint (" + endPointAddr.getEndPointString() + ") is invalid.");
        }
        catch (FileWriteException fileWriteException) {
            throw new CommandException("Error encountered in updating configuration with Registration data.", (Throwable)fileWriteException);
        }
        catch (FileReadException fileReadException) {
            throw new CommandException("Error encountered in updating configuration with Registration data.", (Throwable)fileReadException);
        }
    }
}

