/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.softwareMgr;

import java.util.StringTokenizer;
import oracle.sysman.ccr.collector.softwareMgr.InvalidComponentVersionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class ComponentVersion {
    private int m_nMajorVersion;
    private int m_nMinorVersion;
    private int m_nRelease;
    private int m_nPatchSetRelease;
    private int m_nBuildNumber;
    private static String VERSION_PATTERN = "(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)";
    private static RE s_versionPattern;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 2;
    private static final int RELEASE = 3;
    private static final int PATCHSET = 4;
    private static final int BUILD = 5;

    static {
        try {
            s_versionPattern = new RE(VERSION_PATTERN);
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException("Invalid Pattern " + VERSION_PATTERN);
        }
    }

    public ComponentVersion(int n, int n2, int n3, int n4, int n5) {
        this.init(n, n2, n3, n4, n5);
    }

    public ComponentVersion(String string, String string2, String string3, String string4, String string5) throws InvalidComponentVersionException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        try {
            n5 = Integer.valueOf(string);
            n4 = Integer.valueOf(string2);
            n3 = Integer.valueOf(string3);
            n2 = Integer.valueOf(string4);
            n = Integer.valueOf(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidComponentVersionException("Invalid version specification - ");
        }
        this.init(n5, n4, n3, n2, n);
    }

    public static int compare(String string, String string2) throws InvalidComponentVersionException {
        if (string == null || string2 == null) {
            return -1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            try {
                n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                n2 = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidComponentVersionException("Invalid Version: " + numberFormatException.getMessage());
            }
            if (n == n2) continue;
            return n > n2 ? 1 : -1;
        }
        return 0;
    }

    private void init(int n, int n2, int n3, int n4, int n5) {
        this.m_nMajorVersion = n;
        this.m_nMinorVersion = n2;
        this.m_nRelease = n3;
        this.m_nPatchSetRelease = n4;
        this.m_nBuildNumber = n5;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toString(this.m_nMajorVersion)).append(".");
        stringBuffer.append(Integer.toString(this.m_nMinorVersion)).append(".");
        stringBuffer.append(Integer.toString(this.m_nRelease)).append(".");
        stringBuffer.append(Integer.toString(this.m_nPatchSetRelease)).append(".");
        stringBuffer.append(Integer.toString(this.m_nBuildNumber));
        return stringBuffer.toString();
    }

    public static synchronized ComponentVersion valueOf(String string) throws InvalidComponentVersionException {
        if (!s_versionPattern.match(string)) {
            throw new InvalidComponentVersionException("Version was: " + string);
        }
        return new ComponentVersion(s_versionPattern.getParen(1), s_versionPattern.getParen(2), s_versionPattern.getParen(3), s_versionPattern.getParen(4), s_versionPattern.getParen(5));
    }
}

