/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.softwareMgr;

import HTTPClient.NVPair;
import HTTPClient.ParseException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.softwareMgr.ClientAction;
import oracle.sysman.ccr.collector.softwareMgr.Component;
import oracle.sysman.ccr.collector.softwareMgr.ComponentStateException;
import oracle.sysman.ccr.collector.softwareMgr.ComponentVerificationException;
import oracle.sysman.ccr.collector.softwareMgr.InvalidComponentException;
import oracle.sysman.ccr.collector.softwareMgr.SignedComponent;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareMgrMsgId;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareUpdateException;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareUpdatesXMLParser;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public class SoftwareMgr {
    private static SoftwareMgr s_instance = null;
    private static Vector s_vecComponents = null;
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr != null ? class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr : (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr");
    private static Component[] s_componentDownloadList = null;
    private static final int K_BLOCKS = 1024;
    public static final String PACKAGES_PENDING_DEPLOYMENT = "pending";
    private static final String JAR_SUFFIX = ".jar";
    private static String s_downloadDest = "";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr;

    private SoftwareMgr() {
    }

    public static boolean autoUpdateEnabled() {
        Config config = UplinkHomeConfig.getInstance();
        return config.getProperty("ccr.autoupdate", true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void clearDownloadState(File file) throws SoftwareUpdateException {
        if (file.exists() && !file.delete()) {
            throw new SoftwareUpdateException("Unable to remove inprogress package marker " + file.getName());
        }
    }

    private Vector constructInventoryURIParams(Component[] componentArray) {
        Vector<NVPair> vector = new Vector<NVPair>();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                String string = componentArray[n].getComponentVersion().toString();
                vector.add(new NVPair(componentArray[n].getComponentHeader(), string));
                String string2 = componentArray[n].getComponentArchitecture();
                if (string2 != null) {
                    vector.add(new NVPair(String.valueOf(componentArray[n].getComponentHeader()) + "-ARCH", string2));
                }
                ++n;
            }
        }
        return vector;
    }

    public boolean containsMandatoryComponent(Component[] componentArray) throws ComponentStateException {
        boolean bl = false;
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length && !bl) {
                bl = componentArray[n].isMandatory();
                ++n;
            }
        }
        return bl;
    }

    void dispatchActionException(CCRException cCRException) throws SoftwareUpdateException {
        if (s_log.isEnabledFor(Logger.ERROR)) {
            s_log.error(SoftwareMgrMsgId.CLIENT_ACTION_ERR);
            Vector vector = cCRException.formatExceptionChain();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                s_log.error(SoftwareMgrMsgId.CLIENT_ACTION_CHAINED_ERR, new String[]{string});
            }
        }
        throw new SoftwareUpdateException(s_msgBundle.getMessage(SoftwareMgrMsgId.CLIENT_ACTION_ERR, false), cCRException);
    }

    public boolean downloadUpdates(Component[] componentArray) throws NetworkException, SoftwareUpdateException {
        boolean bl;
        block15: {
            bl = false;
            EndPointAddr endPointAddr = null;
            try {
                endPointAddr = this.getContentServerAddr();
            }
            catch (MalformedURLException malformedURLException) {
                throw new SoftwareUpdateException("Error constructing URI for update check - " + malformedURLException.getMessage());
            }
            OCMEndPoint oCMEndPoint = new OCMEndPoint(endPointAddr);
            if (componentArray == null) break block15;
            int n = 0;
            while (n < componentArray.length) {
                Object var8_8;
                InputStream inputStream = null;
                try {
                    block13: {
                        try {
                            inputStream = oCMEndPoint.getFile(componentArray[n].getComponentFilename());
                            if (this.persistComponent(componentArray[n], inputStream)) {
                                bl = true;
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (!s_log.isEnabledFor(Logger.WARN)) break block13;
                            s_log.warn(SoftwareMgrMsgId.DOWNLOAD_UNAVAILABLE, new String[]{componentArray[n].getComponentFilename()});
                        }
                    }
                    var8_8 = null;
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    inputStream = null;
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                inputStream = null;
                ++n;
            }
        }
        return bl;
    }

    private Component[] extractUpdateList(String string) throws SoftwareUpdateException {
        Object object;
        Object object2;
        SoftwareUpdatesXMLParser softwareUpdatesXMLParser = new SoftwareUpdatesXMLParser();
        try {
            object2 = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
            object2.setContentHandler(softwareUpdatesXMLParser);
            object = new StringReader(string);
            InputSource inputSource = new InputSource((Reader)object);
            object2.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (s_log.isEnabledFor(Logger.ERROR)) {
                s_log.error(SoftwareMgrMsgId.CS_RESPONSE_ERR, new String[]{sAXException.getMessage(), string});
            }
            throw new SoftwareUpdateException(s_msgBundle.getMessage(SoftwareMgrMsgId.CS_RESPONSE_ERR, false, (Object[])new String[]{sAXException.getMessage(), string}));
        }
        catch (IOException iOException) {}
        object2 = softwareUpdatesXMLParser.getClientActions().elements();
        while (object2.hasMoreElements()) {
            try {
                object = (ClientAction)object2.nextElement();
                ((ClientAction)object).executeAction();
            }
            catch (NetworkException networkException) {
                this.dispatchActionException(networkException);
            }
            catch (CommandException commandException) {
                this.dispatchActionException(commandException);
            }
        }
        return softwareUpdatesXMLParser.getFilesForDownload();
    }

    public static String formatComponentList(Component[] componentArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(componentArray[n].getComponentName());
                stringBuffer.append(" (");
                stringBuffer.append(componentArray[n].getComponentVersion().toString());
                stringBuffer.append(")");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public Component[] getComponentDownloadList() throws NetworkException, SoftwareUpdateException {
        if (s_componentDownloadList == null) {
            SoftwareMgr softwareMgr = this;
            synchronized (softwareMgr) {
                if (s_componentDownloadList == null) {
                    Component[] componentArray = this.getDeployedComponents();
                    s_componentDownloadList = this.getComponentDownloadList(componentArray, null);
                }
            }
        }
        return s_componentDownloadList;
    }

    public Component[] getComponentDownloadList(Component[] componentArray, NVPair[] nVPairArray) throws NetworkException, SoftwareUpdateException {
        Vector vector = this.constructInventoryURIParams(componentArray);
        if (nVPairArray != null) {
            int n = 0;
            while (n < nVPairArray.length) {
                vector.add(nVPairArray[n]);
                ++n;
            }
        }
        String string = this.sendComponentInventory(vector);
        return this.extractUpdateList(string);
    }

    private EndPointAddr getContentServerAddr() throws MalformedURLException {
        EndPointAddr endPointAddr;
        try {
            endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            if (endPointAddr == null) {
                throw new MalformedURLException("Oracle Configuration Manager endpoint unknown");
            }
        }
        catch (ParseException parseException) {
            throw new MalformedURLException("Unable to construct URI for Oracle Configuration Manager connection - " + parseException.getMessage());
        }
        return endPointAddr;
    }

    public Component[] getDeployedComponents() {
        this.inventoryComponents();
        Component[] componentArray = new Component[s_vecComponents.size()];
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n] = (Component)s_vecComponents.get(n);
            ++n;
        }
        return componentArray;
    }

    private void getDownloadDest() {
        if (s_downloadDest.length() == 0) {
            Class clazz = class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr != null ? class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr : (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr"));
            synchronized (clazz) {
                Config config = UplinkHomeConfig.getInstance();
                s_downloadDest = config.getProperty("ccr.download_dest", FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.INVENTORY_PENDING_DEPLOYMENT_PATH}));
            }
        }
    }

    public static SoftwareMgr getInstance() {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr != null ? class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr : (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr"));
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new SoftwareMgr();
                }
            }
        }
        return s_instance;
    }

    private void initDownloadState(File file, File file2) throws SoftwareUpdateException {
        if (file.exists() && !file.delete()) {
            throw new SoftwareUpdateException("Unable to remove package staged for installation (" + file.getName() + ")");
        }
        this.clearDownloadState(file2);
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            throw new SoftwareUpdateException("Unable to create package marker file", iOException);
        }
    }

    private void inventoryComponents() {
        if (s_vecComponents != null) {
            return;
        }
        Class clazz = class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr != null ? class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr : (class$oracle$sysman$ccr$collector$softwareMgr$SoftwareMgr = SoftwareMgr.class$("oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr"));
        synchronized (clazz) {
            if (s_vecComponents == null) {
                s_vecComponents = new Vector();
                String string = FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.INVENTORY_PATH});
                String[] stringArray = this.packages(string);
                int n = 0;
                while (n < stringArray.length) {
                    block9: {
                        try {
                            File file = new File(FileSpec.catfile(new String[]{string, stringArray[n]}));
                            Component component = new Component(file);
                            s_vecComponents.add(component);
                            if (s_log.isEnabledFor(Logger.DEBUG)) {
                                s_log.debug("Discovered Component " + component.getComponentName() + ", version: " + component.getComponentVersion().toString() + ", buildDate: " + component.getComponentBuildDate() + ", header: " + component.getComponentHeader());
                            }
                        }
                        catch (InvalidComponentException invalidComponentException) {
                            if (!s_log.isEnabledFor(Logger.WARN)) break block9;
                            s_log.warn(SoftwareMgrMsgId.INV_COMPONENT, new String[]{stringArray[n]}, invalidComponentException);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    private String[] packages(String string) {
        File file = new File(string);
        String[] stringArray = file.list(new _packageFilenameFilter());
        return stringArray;
    }

    private boolean persistComponent(Component component, InputStream inputStream) throws SoftwareUpdateException {
        boolean bl;
        BufferedOutputStream bufferedOutputStream;
        File file;
        File file2;
        block21: {
            this.getDownloadDest();
            file2 = new File(FileSpec.catfile(new String[]{s_downloadDest, String.valueOf(component.getComponentName()) + JAR_SUFFIX}));
            file = new File(FileSpec.catfile(new String[]{s_downloadDest, String.valueOf(component.getComponentName()) + ".lk"}));
            this.initDownloadState(file2, file);
            FileOutputStream fileOutputStream = null;
            bufferedOutputStream = null;
            bl = false;
            try {
                try {
                    int n;
                    fileOutputStream = new FileOutputStream(file2);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) > 0) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    inputStream.close();
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    SignedComponent.verify(file2.toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new SoftwareUpdateException(String.valueOf(s_downloadDest) + " is not accessible", fileNotFoundException);
                }
                catch (IOException iOException) {
                    bl = true;
                    throw new SoftwareUpdateException("Error in streaming data from contentServer", iOException);
                }
                catch (ComponentVerificationException componentVerificationException) {
                    if (s_log.isEnabledFor(Logger.ERROR)) {
                        s_log.error(SoftwareMgrMsgId.DOWNLOAD_VERIFICATION_FAILURE, new String[]{component.getComponentName(), componentVerificationException.getMessage()});
                    }
                    bl = true;
                }
                catch (InvalidComponentException invalidComponentException) {
                    if (s_log.isEnabledFor(Logger.ERROR)) {
                        s_log.error(SoftwareMgrMsgId.DOWNLOAD_VERIFICATION_FAILURE, new String[]{component.getComponentName(), invalidComponentException.getMessage()});
                    }
                    bl = true;
                }
                Object var9_14 = null;
                if (inputStream == null) break block21;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bl && file2.exists()) {
                    file2.delete();
                }
                this.clearDownloadState(file);
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (bufferedOutputStream != null) {
            try {
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (bl && file2.exists()) {
            file2.delete();
        }
        this.clearDownloadState(file);
        return bl ^ true;
    }

    private String sendComponentInventory(Vector vector) throws NetworkException, SoftwareUpdateException {
        EndPointAddr endPointAddr = null;
        try {
            endPointAddr = this.getContentServerAddr();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SoftwareUpdateException("Error constructing URI for update check - " + malformedURLException.getMessage());
        }
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        String string = securityMgr.getCustomerOrgId();
        String string2 = Hostname.getHostname();
        String string3 = Collector.getOracleHome();
        String string4 = Collector.getConfigHome();
        OCMEndPoint oCMEndPoint = new OCMEndPoint(endPointAddr);
        return oCMEndPoint.getUpdates(vector, string2, string3, string, securityMgr.getAuthenticationKeyString(), string4);
    }

    private class _packageFilenameFilter
    implements FilenameFilter {
        _packageFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            if (file2.isFile()) {
                return string.endsWith(SoftwareMgr.JAR_SUFFIX);
            }
            return false;
        }
    }
}

