/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.DiscoveryCommandException;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.Process;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class DiscoveryEngine {
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$targets$DiscoveryEngine != null ? class$oracle$sysman$ccr$collector$targets$DiscoveryEngine : (class$oracle$sysman$ccr$collector$targets$DiscoveryEngine = DiscoveryEngine.class$("oracle.sysman.ccr.collector.targets.DiscoveryEngine")));
    private final String ENV_CCR_HOME = "CCR_HOME";
    private final String ENV_CCR_JAVA_HOME = "CCR_JAVA_HOME";
    private final String ENV_CCR_CONFIG_HOME = "CCR_CONFIG_HOME";
    private final String ENV_CLUSTER_NAME = "CLUSTER_NAME";
    private final String ENV_CRS_HOME = "CRS_HOME";
    private final String ENV_EMAGENT_PERL_TRACE_DIR = "EMAGENT_PERL_TRACE_DIR";
    private final String ENV_EMAGENT_PERL_TRACE_LEVEL = "EMAGENT_PERL_TRACE_LEVEL";
    private final String ENV_EMDROOT = "EMDROOT";
    private final String ENV_LD_PRELOAD = "LD_PRELOAD";
    private final String ENV_LL_ORACLE_HOME = "LL_ORACLE_HOME";
    private final String ENV_ORACLE_CONFIG_HOME = "ORACLE_CONFIG_HOME";
    private final String ENV_ORAINST_LOC = "ORAINST_LOC";
    private final String ENV_PERL5LIB = "PERL5LIB";
    private final String ENV_SYSTEMROOT = "SYSTEMROOT";
    private final String ENV_TNS_ADMIN = "TNS_ADMIN";
    private final String ENV_USER_ORACLE_HOME = "USER_ORACLE_HOME";
    private final String ENV_AGENT_HOME = "AGENT_HOME";
    private final String ENV_AGENTPROXYHOME = "AGENTPROXYHOME";
    private final String ENV_JDBC_OCI_SWITCH = "JDBC_OCI_SWITCH";
    private final String ENV_IAS_CFG_HOME = "IAS_CONFIG_HOME";
    private final String ENV_WL_HOME = "WL_HOME";
    private final String ENV_BEA_HOME = "BEA_HOME";
    private final String ENV_ORACLE_HOME = "ORACLE_HOME";
    private final String ENV_JAVA_HOME = "JAVA_HOME";
    private final String PROP_PERLBIN = "perlBin";
    private final String PERL_EXE = "perl";
    private final String EXE_EXT = ".exe";
    private static final String ENV_HOME = "HOME";
    private static final String JAVA_HOME_PROP = "user.home";
    private static final String DISCOVERY_LST = "discover.lst";
    private static RE m_discoverLstPattern = null;
    private static DiscoveryEngine m_instance = null;
    private String[] m_envVarsArray = this.getEnvironmentVars();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$DiscoveryEngine;

    static {
        try {
            m_discoverLstPattern = new RE("^(.*?)\\|(.*?)\\|(.*?)$");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException("Invalid pattern\n" + rESyntaxException.getMessage());
        }
    }

    private DiscoveryEngine() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public StringBuffer discover() throws DiscoveryCommandException {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.getDiscoveryScripts();
        int n = 0;
        while (n < vector.size()) {
            try {
                stringBuffer.append(this.discover((String)vector.get(n)).toString());
            }
            catch (DiscoveryCommandException discoveryCommandException) {
                if (Collector.failOnError()) {
                    throw discoveryCommandException;
                }
                Collector.logExceptionChainToStderr(discoveryCommandException);
            }
            ++n;
        }
        return stringBuffer;
    }

    public void discover(File file) throws DiscoveryCommandException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(printWriter);
            bufferedWriter.write("<Targets>\n");
            bufferedWriter.write(this.discover().toString());
            bufferedWriter.write("</Targets>\n");
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DiscoveryCommandException("Unable to create list of discovered targets", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new DiscoveryCommandException("Unable to write the targets.xml file", (Throwable)iOException);
        }
    }

    private StringBuffer discover(String string) throws DiscoveryCommandException {
        Config config = UplinkHomeConfig.getInstance();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.DISCOVER_PATH, string});
        String string3 = "perl";
        String string4 = System.getProperty("os.name");
        if (string4.startsWith("Windows")) {
            string3 = String.valueOf(string3) + ".exe";
        }
        String[] stringArray = new String[]{FileSpec.catfile(new String[]{config.getProperty("perlBin"), string3}), string2, FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.LIVE_LINK_PATH}), Hostname.getHostname()};
        try {
            int n;
            Object object;
            if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug("Executing discovery using cmd: ");
                object = "";
                n = 0;
                while (n < stringArray.length) {
                    object = String.valueOf(object) + stringArray[n] + " ";
                    ++n;
                }
                s_log.debug("  " + (String)object);
            }
            if ((n = ((Process)(object = Process.exec(stringArray, this.m_envVarsArray, null))).waitFor(stringBuffer)) != 0) {
                throw new DiscoveryCommandException("Unable to perform discovery using " + string + " Terminated with " + stringBuffer.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DiscoveryCommandException("Error in performing discovery using " + string, (Throwable)interruptedException);
        }
        catch (IOException iOException) {
            throw new DiscoveryCommandException("Error in performing discovery using " + string, (Throwable)iOException);
        }
        return stringBuffer;
    }

    private Vector getDiscoveryScripts() {
        Object object2;
        Vector<String> vector = new Vector<String>();
        File file = new File(FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.DISCOVER_PATH, DISCOVERY_LST}));
        BufferedReader bufferedReader = null;
        try {
            try {
                FileReader fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                while ((object2 = bufferedReader.readLine()) != null) {
                    int n = ((String)object2).indexOf("#");
                    if (n > 0) {
                        object2 = ((String)object2).substring(0, n - 1);
                    } else if (n == 0) {
                        object2 = "";
                    }
                    object2 = ((String)object2).trim();
                    if (((String)object2).length() == 0 || !m_discoverLstPattern.match((String)object2)) continue;
                    String string = m_discoverLstPattern.getParen(1);
                    String string2 = m_discoverLstPattern.getParen(2);
                    String string3 = m_discoverLstPattern.getParen(3);
                    vector.add(string2);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Vector<String> vector2 = vector;
                Object var6_14 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return vector2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Object var6_15 = null;
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException object2) {
            ((Throwable)object2).printStackTrace();
        }
        return vector;
    }

    private String[] getEnvironmentVars() {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Vector<String> vector = new Vector<String>();
        String string8 = null;
        string8 = System.getProperty("LD_PRELOAD");
        if (string8 != null) {
            vector.add("LD_PRELOAD=" + string8);
        }
        String string9 = null;
        string9 = System.getProperty("TNS_ADMIN");
        if (string9 != null) {
            vector.add("TNS_ADMIN=" + string9);
        }
        String string10 = null;
        string10 = System.getProperty("IAS_CONFIG_HOME");
        if (string10 != null) {
            vector.add("IAS_CONFIG_HOME=" + string10);
        }
        String string11 = null;
        string11 = System.getProperty("WL_HOME");
        if (string11 != null) {
            vector.add("WL_HOME=" + string11);
        }
        String string12 = null;
        string12 = System.getProperty("BEA_HOME");
        if (string12 != null) {
            vector.add("BEA_HOME=" + string12);
        }
        String string13 = null;
        string13 = System.getProperty("USER_ORACLE_HOME");
        if (string13 != null) {
            vector.add("USER_ORACLE_HOME=" + string13);
        }
        vector.add("PERL5LIB=" + this.getPerl5LibPath());
        vector.add("EMAGENT_PERL_TRACE_DIR=" + FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.LOG_PATH}));
        String string14 = null;
        string14 = System.getProperty("CCR_JAVA_HOME");
        if (string14 != null) {
            vector.add("CCR_JAVA_HOME=" + string14);
        }
        String string15 = null;
        string15 = System.getProperty("CCR_CONFIG_HOME");
        if (string15 != null) {
            vector.add("CCR_CONFIG_HOME=" + string15);
        }
        String string16 = null;
        string16 = System.getProperty("ORACLE_CONFIG_HOME");
        if (string16 != null) {
            vector.add("ORACLE_CONFIG_HOME=" + string16);
        }
        vector.add("LL_ORACLE_HOME=" + Collector.getOracleHome());
        vector.add("CCR_HOME=" + FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.LIVE_LINK_PATH}));
        String string17 = System.getProperty("CRS_HOME");
        if (string17 != null && string17.length() > 0) {
            vector.add("CRS_HOME=" + string17);
        }
        if ((string7 = System.getProperty("CLUSTER_NAME")) != null && string7.length() > 0) {
            vector.add("CLUSTER_NAME=" + string7);
        }
        if ((string6 = System.getProperty("ORAINST_LOC")) != null && string6.length() > 0) {
            vector.add("ORAINST_LOC=" + string6);
        }
        if ((string5 = System.getProperty("SYSTEMROOT")) != null && string5.length() > 0) {
            vector.add("SYSTEMROOT=" + string5);
        }
        if ((string4 = System.getProperty(JAVA_HOME_PROP)) != null) {
            vector.add("HOME=" + string4);
        }
        if ((string3 = System.getProperty("EMAGENT_PERL_TRACE_LEVEL")) != null) {
            vector.add("EMAGENT_PERL_TRACE_LEVEL=" + string3);
        }
        if ((string2 = System.getProperty("SHLIB_VAR")) != null) {
            vector.add(string2);
        }
        String string18 = UplinkPath.gridAgentMode() ? "1" : "0";
        vector.add("AGENT_HOME=" + string18);
        String string19 = System.getProperty("AGENTPROXYHOME");
        if (string19 != null && string19.length() > 0) {
            vector.add("AGENTPROXYHOME=" + string19);
        }
        if ((string = System.getProperty("JDBC_OCI_SWITCH")) != null && string.length() > 0) {
            vector.add("JDBC_OCI_SWITCH=" + string);
        }
        if (UplinkPath.gridAgentMode()) {
            vector.add("ORACLE_HOME=" + Collector.getOracleHome());
            object = null;
            object = System.getProperty("CCR_JAVA_HOME");
            if (object != null) {
                vector.add("JAVA_HOME=" + (String)object);
            }
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug("Discovery environment array is:");
            int n = 0;
            while (n < ((Object[])object).length) {
                s_log.debug("\t" + (String)object[n]);
                ++n;
            }
        }
        return object;
    }

    public static DiscoveryEngine getInstance() {
        if (m_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$targets$DiscoveryEngine != null ? class$oracle$sysman$ccr$collector$targets$DiscoveryEngine : (class$oracle$sysman$ccr$collector$targets$DiscoveryEngine = DiscoveryEngine.class$("oracle.sysman.ccr.collector.targets.DiscoveryEngine"));
            synchronized (clazz) {
                if (m_instance == null) {
                    m_instance = new DiscoveryEngine();
                }
            }
        }
        return m_instance;
    }

    private String getPerl5LibPath() {
        String string = System.getProperty("PERL5LIB");
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final void main(String[] var0) {
        block3: {
            var1_1 = DiscoveryEngine.getInstance();
            try {
                System.out.println(var1_1.discover().toString());
                break block3;
            }
            catch (DiscoveryCommandException var2_2) {
                var3_3 /* !! */  = var2_2;
                ** while (var3_3 /* !! */  != null)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(var3_3 /* !! */ .getMessage());
                if (!(var3_3 /* !! */  instanceof CCRException)) continue;
                var4_4 = var3_3 /* !! */ ;
                var3_3 /* !! */  = var4_4.getCause();
                continue;
            }
        }
    }
}

