/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.targets.TargetAssocTargetInstance;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.TargetProperty;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.collector.targets.metadata.DynamicProperties;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.timezone.Timezone;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.XMLOps;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Target
implements Serializable {
    private static final long serialVersionUID = -7196199441270915507L;
    private transient Logger m_log = Logger.getInstance(class$oracle$sysman$ccr$collector$targets$Target != null ? class$oracle$sysman$ccr$collector$targets$Target : (class$oracle$sysman$ccr$collector$targets$Target = Target.class$("oracle.sysman.ccr.collector.targets.Target")));
    private transient MessageBundle m_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.targets.Targets");
    private transient HashMap m_hashProperties = new HashMap();
    public transient HashMap m_env = new HashMap();
    public transient HashMap m_hashTargetAssocs = null;
    private String m_strTargetName = null;
    private String m_strTargetType = null;
    private String m_strTimeZone = null;
    private String m_strDisplayName = "";
    private String m_strOnHost = "";
    private boolean m_bDisabled = false;
    private String m_strVersion = "";
    private boolean m_bOnHost = false;
    private String m_oracleHome = null;
    private String m_configHome = null;
    private String m_hostName = null;
    private boolean m_isProxyTarget = false;
    private boolean m_useCfgHomeForGUID = true;
    private String m_fullPath = null;
    private String m_strGUID = null;
    public static final String HOST_TARGET = "host";
    private static final String RAC_DATABASE = "rac_database";
    private static final String WEBSPHERE_TARGET = "ibm";
    private static final String BEA_TARGET = "bea";
    private static final String IAS_FARM_TARGET = "oracle_ias_farm";
    private static final String IAS_CLUSTER_TARGET = "oracle_ias_cluster";
    private static final String CLUSTER_TARGET = "cluster";
    private static final String ORACLE_HOME_TARGET = "oracle_home";
    private transient Date m_dateCollection = null;
    public static final String INSTANCE_PROP_ORACLE_HOME = "OracleHome";
    public static final String INSTANCE_PROP_IS_PROXY_TARGET = "IsProxyTarget";
    public static final String INSTANCE_PROP_OCM_PROXY_HOST = "OcmProxyHost";
    public static final String INSTANCE_PROP_OCM_PROXY_ORACLE_HOME = "OcmProxyOracleHome";
    public static final String INSTANCE_PROP_OCM_PROXY_CONFIG_HOME = "OcmProxyConfigHome";
    public static final String INSTANCE_PROP_OCM_CROSS_HOST = "OCM_CROSS_HOST";
    public static final String INSTANCE_PROP_IS_REMOTE = "IS_REMOTE";
    private static final String GUID_PROP = "GUID";
    private static final String CCR_COLLECTION_TIMESTAMP_OVERRIDE = "CCR_COLLECTION_TIMESTAMP_OVERRIDE";
    public static final String ATTR_TYPE = "TYPE";
    public static final String ATTR_NAME = "NAME";
    public static final String ATTR_DISPLAY_NAME = "DISPLAY_NAME";
    public static final String ATTR_ON_HOST = "ON_HOST";
    public static final String ATTR_NO_EMD_URL = "NO_EMD_URL";
    public static final String ATTR_TIMEZONE_REGION = "TIMEZONE_REGION";
    public static final String ATTR_DISABLED = "DISABLED";
    public static final String ATTR_VERSION = "VERSION";
    public static final String TARGET = "Target";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$Target;

    public Target(String string, String string2, boolean bl, String string3, boolean bl2, String string4, String string5, String string6, boolean bl3, String string7, String string8, String string9) throws SAXException {
        this.m_strTargetName = string;
        this.m_strTargetType = string2;
        this.m_bDisabled = bl;
        this.m_strDisplayName = string3;
        this.m_bOnHost = bl2;
        this.m_hostName = string4;
        this.m_useCfgHomeForGUID = true;
        if (string6 == null || string6.length() == 0 || this.m_strTargetType.equalsIgnoreCase(ORACLE_HOME_TARGET)) {
            this.m_useCfgHomeForGUID = false;
        }
        this.m_oracleHome = string5;
        this.m_configHome = string6;
        this.m_isProxyTarget = bl3;
        this.m_strOnHost = string7;
        if (this.m_isProxyTarget) {
            this.m_hostName = this.m_strOnHost == null ? this.m_hostName : this.m_strOnHost.toLowerCase();
            this.addProperty(INSTANCE_PROP_OCM_PROXY_HOST, this.m_hostName);
        }
        this.m_strVersion = string9;
        this.postCreation(false, string8);
    }

    public Target(Attributes attributes) throws SAXException {
        this.m_hashTargetAssocs = new HashMap();
        this.m_oracleHome = Collector.getOracleHome();
        this.m_configHome = Collector.getConfigHome();
        if (this.m_configHome == null || this.m_configHome.length() == 0) {
            this.m_useCfgHomeForGUID = false;
        }
        this.m_fullPath = Collector.getFullPath();
        this.m_hostName = Hostname.getHostname();
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getQName(n);
            if (string.equals(ATTR_NAME)) {
                this.m_strTargetName = attributes.getValue(n);
            } else if (string.equals(ATTR_TYPE)) {
                this.m_strTargetType = attributes.getValue(n);
                if (this.m_strTargetType.equalsIgnoreCase(ORACLE_HOME_TARGET)) {
                    this.m_useCfgHomeForGUID = false;
                }
            } else if (string.equals(ATTR_DISABLED)) {
                this.m_bDisabled = Boolean.valueOf(attributes.getValue(n));
            } else if (string.equals(ATTR_DISPLAY_NAME)) {
                this.m_strDisplayName = attributes.getValue(n);
            } else if (string.equals(ATTR_NO_EMD_URL)) {
                this.m_bOnHost = Boolean.valueOf(attributes.getValue(n));
            } else if (string.equals(ATTR_ON_HOST)) {
                this.m_strOnHost = attributes.getValue(n);
                this.m_isProxyTarget = true;
                this.m_configHome = null;
                this.m_useCfgHomeForGUID = false;
                this.m_hostName = attributes.getValue(n).toLowerCase();
                this.addProperty(INSTANCE_PROP_OCM_PROXY_HOST, this.m_hostName);
            } else if (string.equals(ATTR_TIMEZONE_REGION)) {
                this.m_strTimeZone = attributes.getValue(n);
            } else if (string.equals(ATTR_VERSION)) {
                this.m_strVersion = attributes.getValue(n);
            } else if (this.m_log.isEnabledFor(Logger.WARN)) {
                this.m_log.warn(TargetsMsgID.UNSUPPORTED_TARGET_ATTR, new String[]{string});
            }
            ++n;
        }
        this.postCreation(true, null);
    }

    void addDefaultInstanceProperties() {
        this.addProperty(ATTR_NAME, this.getTargetName());
        this.addProperty(ATTR_TYPE, this.getTargetType());
        this.addProperty(ATTR_DISPLAY_NAME, this.getDisplayName());
        this.addProperty(INSTANCE_PROP_IS_PROXY_TARGET, new Boolean(this.m_isProxyTarget).toString());
        boolean bl = Collector.isRemoteGridAgentMode();
        this.addProperty(INSTANCE_PROP_IS_REMOTE, new Boolean(bl).toString());
    }

    void addProperty(String string, String string2) {
        this.m_hashProperties.put(string, new TargetProperty(string, string2));
        this.setCollectionTimestamp(string, string2);
    }

    void addProperty(Attributes attributes) throws SAXException {
        TargetProperty targetProperty = new TargetProperty(attributes);
        if (this.m_isProxyTarget && targetProperty.getName().equals(INSTANCE_PROP_OCM_PROXY_HOST)) {
            if (this.m_log.isEnabledFor(Logger.WARN)) {
                this.m_log.warn(TargetsMsgID.PROXY_HOST_PROP_IGNORED, new String[]{this.m_strTargetName});
            }
            return;
        }
        this.m_hashProperties.put(targetProperty.getName(), targetProperty);
        this.setCollectionTimestamp(targetProperty.getName(), targetProperty.getValue());
        if (this.m_isProxyTarget && targetProperty.getName().equals(INSTANCE_PROP_OCM_PROXY_ORACLE_HOME)) {
            this.m_oracleHome = targetProperty.getValue();
            if (this.m_configHome == null) {
                this.m_useCfgHomeForGUID = false;
            }
        }
        if (this.m_isProxyTarget && targetProperty.getName().equals(INSTANCE_PROP_OCM_PROXY_CONFIG_HOME)) {
            this.m_configHome = targetProperty.getValue();
            this.m_useCfgHomeForGUID = true;
        }
        if (UplinkPath.gridAgentMode() && !this.m_isProxyTarget && targetProperty.getName().equals(INSTANCE_PROP_ORACLE_HOME)) {
            this.m_oracleHome = targetProperty.getValue();
        }
    }

    public void addTargetAssoc(Attributes attributes) throws SAXException {
        TargetAssocTargetInstance targetAssocTargetInstance = new TargetAssocTargetInstance(attributes);
        this.m_hashTargetAssocs.put(targetAssocTargetInstance.getAssocId(), targetAssocTargetInstance);
    }

    public boolean assocsDisjointWith(Set set) {
        Collection collection = this.m_hashTargetAssocs.values();
        HashSet hashSet = new HashSet(collection);
        hashSet.retainAll(set);
        return hashSet.isEmpty();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void disable(boolean bl) {
        this.m_bDisabled = bl;
    }

    public boolean equals(Target target) {
        boolean bl = false;
        if (target == null) {
            return bl;
        }
        if (target == this) {
            bl = true;
        } else if (this.m_strTargetName.equals(target.m_strTargetName) && this.m_strTargetType.equals(target.m_strTargetType) && this.m_strDisplayName.equals(target.m_strDisplayName) && this.m_strOnHost.equals(target.m_strOnHost) && this.m_strTimeZone.equals(target.m_strTimeZone) && this.m_strVersion.equals(target.m_strVersion) && this.m_bDisabled == target.m_bDisabled && this.m_bOnHost == target.m_bOnHost) {
            Object object;
            Object object2;
            Object object3;
            Set set = this.m_hashProperties.keySet();
            Set set2 = target.m_hashProperties.keySet();
            Iterator iterator = set.iterator();
            bl = true;
            if (set.size() != set2.size()) {
                bl = false;
            }
            while (iterator.hasNext() && bl) {
                object3 = (String)iterator.next();
                object2 = (TargetProperty)this.m_hashProperties.get(object3);
                object = (TargetProperty)target.m_hashProperties.get(object3);
                bl = ((TargetProperty)object2).equals((TargetProperty)object);
            }
            if (bl) {
                object3 = this.m_env.keySet();
                object2 = target.m_env.keySet();
                object = object3.iterator();
                if (object3.size() != object2.size()) {
                    bl = false;
                }
                while (object.hasNext() && bl) {
                    String string = (String)object.next();
                    String string2 = (String)this.m_env.get(string);
                    String string3 = (String)target.m_env.get(string);
                    bl = string2.equals(string3);
                }
            }
        }
        return bl;
    }

    public void evaluateDynProps(Vector vector) throws SAXException {
        int n = 0;
        while (n < vector.size()) {
            DynamicProperties dynamicProperties = (DynamicProperties)vector.get(n);
            dynamicProperties.evaluate(this);
            ++n;
        }
    }

    private String generateGUID() throws SAXException {
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        String string = securityMgr.getCustomerOrgId();
        return this.generateGuid(string, this.getTargetHostForGUID());
    }

    public void generateGUIDForImport(String string, String string2) throws SAXException {
        this.m_strGUID = this.generateGuid(string, string2);
        this.m_log.debug("target GUID is " + this.m_strGUID);
        this.addProperty(GUID_PROP, this.m_strGUID);
    }

    private String generateGuid(String string, String string2) throws SAXException {
        String string3;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string3 = this.getTargetHomeForGUID()) == null) {
            string3 = "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string4 = String.valueOf(string) + ":" + string2;
            string4 = String.valueOf(string4.toLowerCase()) + ":" + this.getTargetName() + ":" + string3 + ":" + this.getTargetType().toLowerCase();
            if (this.m_log.isEnabledFor(Logger.DEBUG)) {
                this.m_log.debug("Target " + this.getTargetName() + "," + this.getTargetType() + " is using a MD5 key of: " + string4);
            }
            byte[] byArray = messageDigest.digest(string4.getBytes());
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < byArray.length) {
                int n2 = byArray[n] & 0xFF;
                String string5 = Integer.toHexString(n2);
                if (string5.length() == 1) {
                    string5 = "0" + string5;
                }
                stringBuffer.append(string5);
                ++n;
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SAXException("Unable to get MD5 GUID\n" + noSuchAlgorithmException.getMessage());
        }
    }

    void generateTargetGUIDProperty() throws SAXException {
        this.m_strGUID = this.generateGUID();
        this.m_log.debug("target GUID is " + this.m_strGUID);
        this.addProperty(GUID_PROP, this.m_strGUID);
    }

    public Vector getAssocTarget(String string) {
        return (Vector)this.m_hashTargetAssocs.get(string);
    }

    private String getAttributesStr() {
        Boolean bl = new Boolean(this.m_bOnHost);
        Boolean bl2 = new Boolean(this.m_bDisabled);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XMLOps.makeNVPair(ATTR_NAME, this.m_strTargetName));
        stringBuffer.append(XMLOps.makeNVPair(ATTR_TYPE, this.m_strTargetType));
        if (this.m_isProxyTarget) {
            stringBuffer.append(XMLOps.makeNVPair(ATTR_ON_HOST, this.m_hostName));
        }
        stringBuffer.append(XMLOps.makeNVPair(ATTR_DISABLED, bl2.toString()));
        return stringBuffer.toString().trim();
    }

    public Date getCollectionTimestamp() {
        return this.m_dateCollection;
    }

    public Date getCollectionTimestampOverride() {
        return this.m_dateCollection;
    }

    public final String getConfigHome() {
        return this.m_configHome;
    }

    public String getDisplayName() {
        return this.m_strDisplayName;
    }

    public final String getFullPath() {
        return this.m_fullPath;
    }

    public String getGUID() {
        if (this.m_strGUID != null) {
            return this.m_strGUID;
        }
        throw new RuntimeException("Target is not fully instatiated!");
    }

    private String getPropertyElmtsStr() {
        Set set = this.m_hashProperties.keySet();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(GUID_PROP)) continue;
            TargetProperty targetProperty = (TargetProperty)this.m_hashProperties.get(string);
            stringBuffer.append(targetProperty.toXML().toString());
        }
        return stringBuffer.toString();
    }

    public final String getTargetHome() {
        return this.m_oracleHome;
    }

    private String getTargetHomeForGUID() {
        if (this.getTargetType().equalsIgnoreCase(HOST_TARGET) || this.getTargetType().equalsIgnoreCase(BEA_TARGET) || this.getTargetType().equalsIgnoreCase(WEBSPHERE_TARGET) || this.getTargetType().equalsIgnoreCase(IAS_FARM_TARGET) || this.getTargetType().equalsIgnoreCase(IAS_CLUSTER_TARGET)) {
            return "";
        }
        return this.m_useCfgHomeForGUID ? this.m_configHome : this.m_oracleHome;
    }

    public final String getTargetHost() {
        return this.m_hostName;
    }

    private String getTargetHostForGUID() {
        boolean bl;
        TargetManager targetManager = TargetManager.getInstance();
        TargetMetadata targetMetadata = targetManager.getTargetMetadata(this.getTargetType());
        String string = this.getTargetProperty(INSTANCE_PROP_OCM_CROSS_HOST);
        boolean bl2 = bl = string != null && string.equalsIgnoreCase("TRUE");
        if (targetMetadata.targetTypeCrossesHosts() || bl || this.getTargetType().equals(RAC_DATABASE) || this.getTargetType().equals(CLUSTER_TARGET) || this.getTargetType().equals(IAS_FARM_TARGET) || this.getTargetType().equals(IAS_CLUSTER_TARGET)) {
            return "";
        }
        return this.m_hostName;
    }

    public Vector getTargetKey() {
        return Target.getTargetKey(this.getTargetHost(), this.getTargetHome(), this.getTargetType(), this.getTargetName());
    }

    public static Vector getTargetKey(String string, String string2, String string3, String string4) {
        Vector<String> vector = new Vector<String>(4);
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(string3);
        vector.addElement(string4);
        return vector;
    }

    public final String getTargetName() {
        return this.m_strTargetName;
    }

    public String getTargetProperty(String string) {
        TargetProperty targetProperty = (TargetProperty)this.m_hashProperties.get(string);
        if (targetProperty == null) {
            String string2 = (String)this.m_env.get(string);
            if (string2 == null && this.m_log.isEnabledFor(Logger.DEBUG)) {
                this.m_log.debug("Instance Property (" + string + ") not found for target (" + this.getTargetName() + "," + this.getTargetType() + ")");
            }
            return string2;
        }
        return targetProperty.getValue();
    }

    public final String getTargetType() {
        return this.m_strTargetType;
    }

    public static String getTargetType(Vector vector) {
        return (String)vector.get(2);
    }

    public String getTimeZone() {
        return this.m_strTimeZone;
    }

    public boolean hasTargetAssocs() {
        return this.m_hashTargetAssocs.isEmpty() ^ true;
    }

    public boolean isDisabled() {
        return this.m_bDisabled;
    }

    public boolean isProxyTarget() {
        return this.m_isProxyTarget;
    }

    public boolean isRemote() {
        return this.m_strOnHost != null && this.m_strOnHost.length() > 0;
    }

    private void postCreation(boolean bl, String string) throws SAXException {
        if (this.m_strTargetName == null || this.m_strTargetType == null) {
            throw new SAXException("TARGET element does not have a NAME or TYPE");
        }
        this.addDefaultInstanceProperties();
        if (bl) {
            this.setTimeZone();
        } else if (string != null) {
            Timezone timezone = Timezone.getInstance();
            this.m_strTimeZone = timezone.findSupportedRegion(string);
        } else {
            this.m_strTimeZone = null;
        }
        if (UplinkPath.isGCMode()) {
            this.generateTargetGUIDProperty();
        }
        this.m_log.info(TargetsMsgID.PROCESSING_TARGET, new String[]{this.getTargetName(), this.getTargetType()});
    }

    private void setCollectionTimestamp(String string, String string2) {
        if (string.equals(CCR_COLLECTION_TIMESTAMP_OVERRIDE)) {
            this.m_dateCollection = XMLUploadWriter.parseCollectionDate(string2);
            if (this.m_dateCollection == null && this.m_log.isEnabledFor(Logger.WARN)) {
                this.m_log.warn(TargetsMsgID.INVALID_COLLECTION_TS_OVERRIDE, new String[]{this.m_strTargetName, this.m_strTargetType, string2});
            }
        }
    }

    public void setCollectionTimestampOverride(Date date) {
        this.m_dateCollection = date;
    }

    public void setGUID(String string) {
        this.m_strGUID = string;
        this.m_log.debug("SETGUID target GUID is " + this.m_strGUID);
        this.addProperty(GUID_PROP, this.m_strGUID);
    }

    private void setTimeZone() {
        Timezone timezone = Timezone.getInstance();
        this.m_strTimeZone = timezone.getSupportedRegion();
    }

    public void storeAssocsByTargetKeys() {
        if (this.m_hashTargetAssocs.isEmpty()) {
            return;
        }
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        Iterator iterator = this.m_hashTargetAssocs.keySet().iterator();
        while (iterator.hasNext()) {
            TargetAssocTargetInstance targetAssocTargetInstance = (TargetAssocTargetInstance)this.m_hashTargetAssocs.get(iterator.next());
            Vector vector = Target.getTargetKey(this.getTargetHost(), this.getTargetHome(), targetAssocTargetInstance.getTargetType(), targetAssocTargetInstance.getTargetName());
            hashMap.put(targetAssocTargetInstance.getAssocId(), vector);
            if (!this.m_log.isEnabledFor(Logger.DEBUG)) continue;
            this.m_log.debug("Association \"" + targetAssocTargetInstance.getAssocId() + "\" stored for target (" + this.getTargetName() + ", " + this.getTargetType() + "). Association = " + this.getTargetKey().toString() + " --> " + vector);
        }
        this.m_hashTargetAssocs = hashMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Target (name,value) = ");
        stringBuffer.append(this.m_strTargetName);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_strTargetType);
        stringBuffer.append("\n");
        Set set = this.m_hashProperties.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("\t\t");
            TargetProperty targetProperty = (TargetProperty)this.m_hashProperties.get(string);
            stringBuffer.append("Name = ");
            stringBuffer.append(targetProperty.getName());
            stringBuffer.append(", Value = ");
            stringBuffer.append(targetProperty.getValue());
            stringBuffer.append(", Encrypted = ");
            stringBuffer.append(targetProperty.isEncrypted());
            stringBuffer.append(", isDynamic = ");
            stringBuffer.append(targetProperty.isDynamic());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Target ");
        stringBuffer.append(this.getAttributesStr());
        stringBuffer.append(">");
        stringBuffer.append(XMLOps.getEndTag(TARGET));
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }
}

