/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.DiscoveryCommandException;
import oracle.sysman.ccr.collector.targets.CustomTarget;
import oracle.sysman.ccr.collector.targets.CustomTargetsXMLParser;
import oracle.sysman.ccr.collector.targets.DiscoveryEngine;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetTypeUndefinedException;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.collector.targets.TargetsXMLParser;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadataManager;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.ccr.util.XMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TargetManager {
    public static final String DISABLE_COL_NAMESPACE = "ccr.metric";
    public static final String DISABLE_COL_DELIM = ".";
    private static String[] m_disableSupportedColumns = new String[]{"ccr.metric.host.ecm_hw_nic.inet_address", "ccr.metric.host.ecm_hw_nic.mac_address", "ccr.metric.host.ecm_hw_nic.broadcast_address"};
    public static HashMap m_disabledColumns = null;
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$targets$TargetManager != null ? class$oracle$sysman$ccr$collector$targets$TargetManager : (class$oracle$sysman$ccr$collector$targets$TargetManager = TargetManager.class$("oracle.sysman.ccr.collector.targets.TargetManager")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.targets.Targets");
    private static TargetManager m_instance = null;
    private static HashMap m_hashTargets = null;
    private static HashMap m_hashTargetMetadata = null;
    private static HashSet m_targetsWithAssocs = null;
    private static final String TARGETS_XML = "targets.xml";
    private static final String TEMP_TARGETS_XML = "tempTargets.xml";
    public static final String TARGETS = "Targets";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$TargetManager;

    static {
        m_disabledColumns = new HashMap();
        m_hashTargets = new HashMap();
        m_hashTargetMetadata = new HashMap();
        m_instance = new TargetManager();
        m_targetsWithAssocs = new HashSet();
    }

    private TargetManager() {
        int n = 0;
        while (n < m_disableSupportedColumns.length) {
            String string;
            Config config = UplinkHomeConfig.getInstance();
            boolean bl = config.getProperty(string = m_disableSupportedColumns[n], true);
            if (!bl) {
                m_disabledColumns.put(string, null);
            }
            ++n;
        }
    }

    void addTarget(Target target) {
        Target target2;
        if (target == null) {
            return;
        }
        if (UplinkPath.gridAgentMode() && target.isRemote()) {
            s_log.debug("Ignoring target " + target.getTargetName() + " of type " + target.getTargetType() + " because it is defined as remote");
            return;
        }
        HashMap<Vector, Target> hashMap = (HashMap<Vector, Target>)m_hashTargets.get(target.getTargetType());
        if (hashMap == null) {
            hashMap = new HashMap<Vector, Target>();
            m_hashTargets.put(target.getTargetType(), hashMap);
        }
        if ((target2 = (Target)hashMap.get(target.getTargetKey())) == null || !target2.isProxyTarget() && target.isProxyTarget()) {
            hashMap.put(target.getTargetKey(), target);
            if (target2 != null && s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug("Target discovered as both local and proxy. Choosing proxy over local target.");
            }
        } else if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug("Ignoring target " + target.getTargetName() + " of type " + target.getTargetType() + " because it has already been discovered");
        }
    }

    private boolean addTargetMetadata(String string) throws CommandException, TargetTypeUndefinedException {
        TargetMetadata targetMetadata = null;
        try {
            if (!m_hashTargetMetadata.containsKey(string)) {
                targetMetadata = new TargetMetadata(string);
                m_hashTargetMetadata.put(string, targetMetadata);
            } else {
                targetMetadata = (TargetMetadata)m_hashTargetMetadata.get(string);
            }
        }
        catch (SAXException sAXException) {
            s_log.error(TargetsMsgID.ERR_METADATA_PARSE, new String[]{string}, sAXException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TargetTypeUndefinedException(String.valueOf(string) + " is not a supportable type", fileNotFoundException);
        }
        if (targetMetadata != null) {
            this.evaluateTargetProperties(string, targetMetadata);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearTemporaryCollectionState() {
        String[] stringArray;
        String string;
        block5: {
            string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.STATE_TEMP_PATH});
            File file = new File(string);
            stringArray = null;
            try {
                stringArray = file.list();
            }
            catch (SecurityException securityException) {
                if (!s_log.isEnabledFor(Logger.ERROR)) break block5;
                s_log.error(TargetsMsgID.ERR_LISTING_TEMP_DIR, new String[]{string}, securityException);
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                String string2 = FileSpec.catfile(new String[]{string, stringArray[n]});
                File file = new File(string2);
                try {
                    file.delete();
                }
                catch (SecurityException securityException) {
                    if (!s_log.isEnabledFor(Logger.ERROR)) break block6;
                    s_log.error(TargetsMsgID.ERR_DEL_TEMP_DIR, new String[]{string2}, securityException);
                    String string3 = s_msgBundle.getMessage(TargetsMsgID.ERR_DEL_TEMP_DIR, false, (Object[])new String[]{string2});
                    throw new RuntimeException(string3);
                }
            }
            ++n;
        }
    }

    public void discover() throws DiscoveryCommandException {
        File file = new File(FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_DEFAULT_CONFIG_PATH, TARGETS_XML}));
        DiscoveryEngine discoveryEngine = DiscoveryEngine.getInstance();
        discoveryEngine.discover(file);
    }

    private void evaluateDynPropsWithAssocs() throws CommandException {
        Object object;
        Object object2;
        Object object3;
        int n;
        HashSet hashSet = (HashSet)m_targetsWithAssocs.clone();
        Vector<Object> vector = new Vector<Object>();
        while (!hashSet.isEmpty()) {
            n = 0;
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                object2 = (Vector)object3.next();
                object = this.getTargetFromKey((Vector)object2);
                if (!((Target)object).assocsDisjointWith(hashSet)) continue;
                vector.add(object2);
                object3.remove();
                ++n;
            }
            if (n != 0) continue;
            throw new CommandException("Cyclic or invalid target associations detected.");
        }
        n = 0;
        while (n < vector.size()) {
            object3 = (Vector)vector.get(n);
            object2 = Target.getTargetType((Vector)object3);
            object = this.getTargetMetadata((String)object2);
            Target target = this.getTargetFromKey((Vector)object3);
            try {
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug("Associations present: Evaluating dynamic properties for target (" + target.getTargetName() + ", " + target.getTargetType() + ").");
                }
                target.evaluateDynProps(((TargetMetadata)object).getDynProps());
            }
            catch (SAXException sAXException) {
                String string = "";
                if (target != null) {
                    string = target.getTargetName();
                }
                s_log.error(TargetsMsgID.ERR_EVAL_TARGET_PROPS, new String[]{string, object2}, sAXException);
            }
            ++n;
        }
    }

    private void evaluateTargetProperties(String string, TargetMetadata targetMetadata) {
        HashMap hashMap = (HashMap)m_hashTargets.get(string);
        Set set = hashMap.keySet();
        Target target = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                Vector vector = (Vector)iterator.next();
                target = (Target)hashMap.get(vector);
                target.generateTargetGUIDProperty();
                if (target.hasTargetAssocs()) {
                    m_targetsWithAssocs.add(target.getTargetKey());
                    continue;
                }
                if (s_log.isEnabledFor(Logger.DEBUG)) {
                    s_log.debug("Associations absent: Evaluating dynamic properties for target (" + target.getTargetName() + ", " + target.getTargetType() + ").");
                }
                target.evaluateDynProps(targetMetadata.getDynProps());
            }
            catch (SAXException sAXException) {
                String string2 = "";
                if (target != null) {
                    string2 = target.getTargetName();
                }
                s_log.error(TargetsMsgID.ERR_EVAL_TARGET_PROPS, new String[]{string2, string}, sAXException);
            }
        }
    }

    public HashMap getAllCustomTargets() {
        HashMap hashMap = new HashMap();
        String[] stringArray = this.getTargetTypes();
        int n = 0;
        while (n < stringArray.length) {
            HashMap hashMap2 = (HashMap)m_hashTargets.get(stringArray[n]);
            if (hashMap2 != null) {
                Set set = hashMap2.keySet();
                HashMap<Vector, Target> hashMap3 = new HashMap<Vector, Target>();
                boolean bl = true;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Vector vector = (Vector)iterator.next();
                    Target target = (Target)hashMap2.get(vector);
                    if (!target.isDisabled()) continue;
                    hashMap3.put(vector, target);
                    bl = false;
                }
                if (!bl) {
                    hashMap.put(stringArray[n], hashMap3);
                }
            }
            ++n;
        }
        return hashMap;
    }

    public Target getAssocTarget(String string, String string2, String string3) {
        Vector vector;
        Target target = null;
        Target target2 = this.getTargetByNameType(string2, string);
        if (target2 != null && (vector = target2.getAssocTarget(string3)) != null) {
            target = this.getTargetFromKey(vector);
        }
        return target;
    }

    public static TargetManager getInstance() {
        return m_instance;
    }

    public Target getTarget(Vector vector, String string) {
        Target target = null;
        HashMap hashMap = (HashMap)m_hashTargets.get(string);
        if (hashMap != null) {
            target = (Target)hashMap.get(vector);
        }
        return target;
    }

    public Target getTargetByNameType(String string, String string2) {
        Target target = null;
        HashMap hashMap = (HashMap)m_hashTargets.get(string2);
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            target = (Target)hashMap.get(iterator.next());
            if (!string.equals(target.getTargetName())) continue;
            return target;
        }
        return null;
    }

    private Target getTargetFromKey(Vector vector) {
        String string = Target.getTargetType(vector);
        return (Target)((HashMap)m_hashTargets.get(string)).get(vector);
    }

    public Target[] getTargetInstances(String string) {
        Target[] targetArray = new Target[]{};
        HashMap hashMap = (HashMap)m_hashTargets.get(string);
        if (hashMap != null) {
            Collection collection = hashMap.values();
            targetArray = new Target[collection.size()];
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                targetArray[n] = (Target)iterator.next();
                ++n;
            }
        }
        return targetArray;
    }

    public TargetMetadata getTargetMetadata(String string) {
        TargetMetadata targetMetadata = null;
        targetMetadata = UplinkPath.isGCMode() ? TargetMetadataManager.getTargetMetadata(string) : (TargetMetadata)m_hashTargetMetadata.get(string);
        return targetMetadata;
    }

    public String getTargetTypeDisplayName(String string) {
        String string2 = "";
        TargetMetadata targetMetadata = (TargetMetadata)m_hashTargetMetadata.get(string);
        if (targetMetadata != null) {
            string2 = targetMetadata.getTypeDisplayString();
        }
        return string2;
    }

    public String[] getTargetTypes() {
        Set set = m_hashTargets.keySet();
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public Vector getTargets(boolean bl) {
        Vector<Target> vector = new Vector<Target>();
        boolean bl2 = false;
        Set set = m_hashTargets.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Target[] targetArray = this.getTargetInstances((String)iterator.next());
            int n = 0;
            while (n < targetArray.length) {
                bl2 = targetArray[n].isDisabled() ^ true;
                if (bl && bl2) {
                    vector.add(targetArray[n]);
                }
                if (!bl && !bl2) {
                    vector.add(targetArray[n]);
                }
                ++n;
            }
        }
        return vector;
    }

    public boolean overrideTarget(CustomTarget customTarget) {
        boolean bl = false;
        Target target = this.getTarget(customTarget.getTargetKey(), customTarget.getTargetType());
        if (target != null) {
            target.disable(customTarget.isDisabled());
            bl = true;
        }
        return bl;
    }

    private void processAgentTargets() throws CommandException {
        block2: {
            TargetsXMLParser targetsXMLParser = new TargetsXMLParser();
            String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.AGENT_EMD_PATH, TARGETS_XML});
            File file = new File(string);
            if (!file.isFile() || file.length() == 0L) break block2;
            try {
                this.readTargets(string, targetsXMLParser);
            }
            catch (CommandException commandException) {
                if (!s_log.isEnabledFor(Logger.DEBUG)) break block2;
                s_log.debug("Error in parsing agent targets.xml.");
                s_log.error(commandException);
            }
        }
    }

    private void processCustomTargets() throws CommandException {
        CustomTargetsXMLParser customTargetsXMLParser = new CustomTargetsXMLParser();
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_CONFIG_PATH, TARGETS_XML});
        File file = new File(string);
        if (file.isFile() && file.length() != 0L) {
            this.readTargets(string, customTargetsXMLParser);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void processTargetMetadata() throws CommandException {
        var1_1 = new ArrayList<String>();
        var2_2 = TargetManager.m_hashTargets.keySet();
        var3_3 = var2_2.iterator();
        block2: while (var3_3.hasNext()) {
            var4_4 = (String)var3_3.next();
            try {
                if (TargetManager.s_log.isEnabledFor(Logger.DEBUG)) {
                    TargetManager.s_log.debug("Getting the targetMetadata for " + var4_4);
                }
                if (this.addTargetMetadata(var4_4)) continue;
                var1_1.add(var4_4);
                continue;
            }
            catch (TargetTypeUndefinedException var5_6) {
                var6_8 /* !! */  = var5_6;
                ** while (var6_8 /* !! */  != null)
            }
lbl-1000:
            // 1 sources

            {
                TargetManager.s_log.error(var6_8 /* !! */ );
                if (var6_8 /* !! */  instanceof CCRException) {
                    var7_9 = var6_8 /* !! */ ;
                    var6_8 /* !! */  = var7_9.getCause();
                    continue;
                }
                var6_8 /* !! */  = null;
                continue;
lbl23:
                // 1 sources

            }
        }
        var4_5 = 0;
        while (var4_5 < var1_1.size()) {
            var5_7 = (String)var1_1.get(var4_5);
            TargetManager.m_hashTargets.remove(var5_7);
            ++var4_5;
        }
        this.evaluateDynPropsWithAssocs();
    }

    public void processTargets() throws CommandException {
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_DEFAULT_CONFIG_PATH, TARGETS_XML});
        File file = new File(string);
        TargetsXMLParser targetsXMLParser = new TargetsXMLParser();
        if (UplinkPath.gridAgentMode()) {
            this.processAgentTargets();
        }
        if (file.isFile() && file.length() != 0L) {
            this.readTargets(string, targetsXMLParser);
        }
        this.processCustomTargets();
    }

    private void readTargets(String string, TargetsXMLParser targetsXMLParser) throws CommandException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
            xMLReader.setContentHandler(targetsXMLParser);
            InputSource inputSource = new InputSource(fileInputStream);
            xMLReader.parse(inputSource);
            fileInputStream.close();
        }
        catch (SAXException sAXException) {
            throw new CommandException("Error parsing targets.xml", (Throwable)sAXException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Unable to access ");
            stringBuffer.append(string);
            throw new CommandException(stringBuffer.toString(), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommandException("Error reading targets.xml", (Throwable)iOException);
        }
    }

    public void writeCustomTargets(HashMap hashMap) throws IOException {
        String string = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_CONFIG_PATH, TEMP_TARGETS_XML});
        String string2 = FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.HOST_CONFIG_PATH, TARGETS_XML});
        FileWriter fileWriter = null;
        File file = new File(string);
        BufferedWriter bufferedWriter = null;
        PrintWriter printWriter = null;
        try {
            fileWriter = new FileWriter(string);
            bufferedWriter = new BufferedWriter(fileWriter);
            printWriter = new PrintWriter(bufferedWriter);
            this.writeTargetsToStream(printWriter, hashMap);
        }
        finally {
            Object var9_8 = null;
            printWriter.close();
            bufferedWriter.close();
            fileWriter.close();
        }
        try {
            File file2 = new File(string2);
            file2.delete();
            if (!file.renameTo(file2)) {
                Utils.copyFile(file, file2);
                file.delete();
            }
        }
        catch (IOException iOException) {
            file.delete();
            s_log.error(iOException);
            throw iOException;
        }
    }

    private void writeTargetsToStream(PrintWriter printWriter, HashMap hashMap) {
        printWriter.println(XMLOps.createXMLDirective(true));
        printWriter.println(XMLOps.getStartTag(TARGETS));
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Collection collection = ((HashMap)hashMap.get(iterator.next())).values();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Target target = (Target)iterator2.next();
                if (!target.isDisabled()) continue;
                printWriter.print(target.toXML());
            }
        }
        printWriter.println(XMLOps.getEndTag(TARGETS));
    }
}

