/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.util.UplinkPath;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.ccr.util.XMLOps;
import oracle.sysman.util.crypt.Crypt;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TargetProperty {
    private String m_strName = null;
    private String m_strValue = "";
    private boolean m_bDynamic = false;
    private static HashMap m_hashEncryptValueMap = null;
    public static final int ENCRYPT_FALSE = 0;
    public static final int ENCRYPT_TRUE = 1;
    public static final int ENCRYPT_NOT_APPLICABLE = 2;
    private int m_nEncrypted = 2;
    private static final String ATTR_VALUE = "VALUE";
    private static final String ATTR_NAME = "NAME";
    private static final String ATTR_ENCRYPTED = "ENCRYPTED";
    private static final String ATTR_IS_DYNAMIC = "IS_DYNAMIC";
    private static final String ENCRYPT_TRUE_STR = "TRUE";
    private static final String ENCRYPT_FALSE_STR = "FALSE";
    private static final String ENCRYPT_NA_STR = "NA";
    public static final String PROPERTY = "Property";
    private static boolean gridAgentMode = false;
    private static String m_encryptionKey = null;

    static {
        m_hashEncryptValueMap = new HashMap();
        m_hashEncryptValueMap.put(ENCRYPT_FALSE_STR, new Integer(0));
        m_hashEncryptValueMap.put(ENCRYPT_TRUE_STR, new Integer(1));
        m_hashEncryptValueMap.put(ENCRYPT_NA_STR, new Integer(2));
        if (UplinkPath.gridAgentMode()) {
            gridAgentMode = true;
            m_encryptionKey = AgentConfig.getAgentSeed();
            if (m_encryptionKey == null) {
                String string = null;
                string = Hostname.getHostname();
                if (string == null) {
                    string = PROPERTY;
                }
                m_encryptionKey = new String(String.valueOf(string) + (double)string.length() * 1.5);
            }
        }
    }

    public TargetProperty(String string, String string2) {
        this.m_strName = string;
        this.m_strValue = string2;
    }

    public TargetProperty(TargetProperty targetProperty) {
        this.m_strName = targetProperty.m_strName;
        this.m_strValue = targetProperty.m_strValue;
        this.m_bDynamic = targetProperty.m_bDynamic;
        this.m_nEncrypted = targetProperty.m_nEncrypted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TargetProperty(Attributes attributes) throws SAXException {
        String string = null;
        int n = 0;
        while (n < attributes.getLength()) {
            string = attributes.getQName(n);
            if (string.equalsIgnoreCase(ATTR_NAME)) {
                this.m_strName = attributes.getValue(n);
            } else if (string.equalsIgnoreCase(ATTR_VALUE)) {
                this.m_strValue = attributes.getValue(n);
            } else if (string.equalsIgnoreCase(ATTR_IS_DYNAMIC)) {
                this.m_bDynamic = attributes.getValue(n).equalsIgnoreCase(ENCRYPT_TRUE_STR);
            } else {
                if (!string.equalsIgnoreCase(ATTR_ENCRYPTED)) throw new SAXException("Unknown Target attribute (" + string + ") encountered.");
                String string2 = attributes.getValue(n);
                Integer n2 = (Integer)m_hashEncryptValueMap.get(string2 = string2.toUpperCase());
                if (n2 == null) throw new SAXException("Unexpected value to ENCRYPTION property.");
                this.m_nEncrypted = n2;
            }
            ++n;
        }
    }

    private String decryptValue(String string) {
        Crypt crypt = new Crypt();
        byte[] byArray = Utils.asciiStringToByteArray(string);
        byte[] byArray2 = crypt.decryptAsByteArray(byArray, m_encryptionKey.getBytes());
        return new String(byArray2).trim();
    }

    public boolean equals(TargetProperty targetProperty) {
        boolean bl = false;
        if (targetProperty != null) {
            if (targetProperty == this) {
                bl = true;
            } else if (this.m_strName != null && this.m_strName.equals(targetProperty.m_strName) && this.m_strValue != null && this.m_strValue.equals(targetProperty.m_strValue) && this.m_bDynamic == targetProperty.m_bDynamic && this.m_nEncrypted == targetProperty.m_nEncrypted) {
                bl = true;
            }
        }
        return bl;
    }

    public final String getName() {
        return this.m_strName;
    }

    public final String getValue() {
        if (this.m_nEncrypted == 1 && gridAgentMode) {
            return this.decryptValue(this.m_strValue);
        }
        return this.m_strValue;
    }

    public final boolean isDynamic() {
        return this.m_bDynamic;
    }

    public final int isEncrypted() {
        return this.m_nEncrypted;
    }

    public StringBuffer toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Property ");
        stringBuffer.append(XMLOps.makeNVPair(ATTR_NAME, this.m_strName));
        stringBuffer.append(XMLOps.makeNVPair(ATTR_VALUE, this.m_strValue));
        stringBuffer.append(XMLOps.makeNVPair(ATTR_IS_DYNAMIC, String.valueOf(this.m_bDynamic)));
        Set set = m_hashEncryptValueMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = (Integer)m_hashEncryptValueMap.get(string);
            if (n != this.m_nEncrypted) continue;
            stringBuffer.append(XMLOps.makeNVPair(ATTR_ENCRYPTED, string));
            break;
        }
        stringBuffer.append("/>");
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer;
    }
}

