/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets;

import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.TargetsMsgID;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TargetsXMLParser
extends DefaultHandler {
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$targets$TargetsXMLParser != null ? class$oracle$sysman$ccr$collector$targets$TargetsXMLParser : (class$oracle$sysman$ccr$collector$targets$TargetsXMLParser = TargetsXMLParser.class$("oracle.sysman.ccr.collector.targets.TargetsXMLParser")));
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.targets.Targets");
    private Target m_targetLastFound = null;
    static final String TARGET = "TARGET";
    static final String PROPERTY = "PROPERTY";
    static final String ASSOC_TARGET_INSTANCE = "AssocTargetInstance";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$TargetsXMLParser;

    TargetsXMLParser() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Target createTarget(Attributes attributes) throws SAXException {
        return new Target(attributes);
    }

    public void endDocument() throws SAXException {
        if (s_log.isEnabledFor(Logger.INFO)) {
            s_log.info(TargetsMsgID.ENDING_PARSE_OF_TARGETS);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase(TARGET)) {
            if (this.m_targetLastFound == null) {
                throw new SAXException("End TARGET element encountered without a begin TARGET");
            }
            TargetManager targetManager = TargetManager.getInstance();
            if (targetManager == null) {
                throw new SAXException("TargetManager is not initialized");
            }
            if (this.m_targetLastFound.isProxyTarget() && this.m_targetLastFound.getTargetProperty("OcmProxyOracleHome") == null) {
                throw new SAXException("Property OcmProxyOracleHome not found for proxy target " + this.m_targetLastFound.getTargetName());
            }
            targetManager.addTarget(this.m_targetLastFound);
            this.m_targetLastFound.storeAssocsByTargetKeys();
            this.m_targetLastFound = null;
        }
    }

    public void startDocument() throws SAXException {
        if (s_log.isEnabledFor(Logger.INFO)) {
            s_log.info(TargetsMsgID.STARTING_PARSE_OF_TARGETS);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase(TARGET)) {
            if (this.m_targetLastFound != null) {
                throw new SAXException(s_bundle.getMessage(TargetsMsgID.NESTED_TARGET_ELEMENT_ERR, false));
            }
            this.m_targetLastFound = this.createTarget(attributes);
        }
        if (string3.equalsIgnoreCase(PROPERTY)) {
            if (this.m_targetLastFound == null) {
                throw new SAXException("PROPERTY element encountered outside of target");
            }
            this.m_targetLastFound.addProperty(attributes);
        }
        if (string3.equalsIgnoreCase(ASSOC_TARGET_INSTANCE)) {
            if (this.m_targetLastFound == null) {
                throw new SAXException("AssocTargetInstance element encountered outside of target");
            }
            this.m_targetLastFound.addTargetAssoc(attributes);
        }
    }
}

