/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.QueryDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TargetsMetadataMsgID;
import oracle.sysman.ccr.collector.targets.metadata.ValidIf;
import oracle.sysman.ccr.collector.targets.metadata.ValidMidTierVersions;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorEnabled;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorList;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Metric
implements ValiditySelectorEnabled {
    static final Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$targets$metadata$Metric != null ? class$oracle$sysman$ccr$collector$targets$metadata$Metric : (class$oracle$sysman$ccr$collector$targets$metadata$Metric = Metric.class$("oracle.sysman.ccr.collector.targets.metadata.Metric")));
    static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.targets.metadata.TargetsMetadata");
    static final String TAGNAME = "Metric";
    private static final String ATTR_ID = "NAME";
    private static final String ATTR_TYPE = "TYPE";
    private static final String ATTR_USAGETYPE = "USAGE_TYPE";
    private static final String ATTR_REPOS_PLSQL = "REPOS_PLSQL";
    private static final String ATTR_CUSTOM = "CUSTOM";
    private static final String ATTR_INCREMENTAL = "INCREMENTAL";
    private static final String ATTR_CMDB_FORMAT = "CMDB_FORMAT";
    static final int TYPEID_INVALID = -1;
    static final int TYPEID_NUMBER = 0;
    static final int TYPEID_STRING = 1;
    static final int TYPEID_TABLE = 2;
    static final int TYPEID_RAW = 3;
    static final int TYPEID_EXTERNAL = 4;
    static final int TYPEID_REPOSITORY_TABLE = 5;
    static final int TYPEID_REPOSITORY_NUMBER = 6;
    static final int TYPEID_REPOSITORY_STRING = 7;
    private static final String TYPE_NUMBER = "NUMBER";
    private static final String TYPE_STRING = "STRING";
    private static final String TYPE_TABLE = "TABLE";
    private static final String TYPE_RAW = "RAW";
    private static final String TYPE_EXTERNAL = "EXTERNAL";
    private static final String TYPE_REPOSITORY_TABLE = "REPOSITORY_TABLE";
    private static final String TYPE_REPOSITORY_NUMBER = "REPOSITORY_NUMBER";
    private static final String TYPE_REPOSITORY_STRING = "REPOSITORY_STRING";
    static final int USAGETYPEID_INVALID = -1;
    static final int USAGETYPEID_VIEW_COLLECT = 0;
    static final int USAGETYPEID_DISPLAY_ONLY = 1;
    static final int USAGETYPEID_MULTI_KEY = 2;
    static final int USAGETYPEID_COLLECT_ONLY = 3;
    static final String USAGETYPE_VIEW_COLLECT = "VIEW_COLLECT";
    static final String USAGETYPE_DISPLAY_ONLY = "DISPLAY_ONLY";
    static final String USAGETYPE_MULTI_KEY = "MULTI_KEY";
    static final String USAGETYPE_COLLECT_ONLY = "COLLECT_ONLY";
    static final int COLUMN_NOT_EXIST = -1;
    public static final String[] TYPES = new String[]{"NUMBER", "STRING", "TABLE", "RAW", "EXTERNAL", "REPOSITORY_TABLE", "REPOSITORY_NUMBER", "REPOSITORY_STRING"};
    static final String[] USAGE_TYPES = new String[]{"VIEW_COLLECT", "DISPLAY_ONLY", "MULTI_KEY", "COLLECT_ONLY"};
    private String m_metricId = null;
    private int m_typeId = 0;
    private int m_usageTypeId = 0;
    private boolean m_isIncremental = false;
    private String m_reposPlSql = null;
    private String m_custom = null;
    private ValiditySelectorList m_ValidIfList = new ValiditySelectorList();
    private ValiditySelectorList m_ValidMidTierVerList = new ValiditySelectorList();
    private TableDescriptor m_tblDesc = null;
    private ValiditySelectorList m_queryDescList = new ValiditySelectorList();
    private Vector m_colDescs = new Vector();
    private Element m_metricElement = null;
    private boolean m_isCmdbFormat = false;
    private static HashMap m_hashMetricElements = null;
    private static final int UNKNOWN_ELEMENT = -1;
    private static final int IGNORED_ELEMENT = 0;
    private static final int SUPPORTED_ELEMENT = 1;
    private static final int UNSUPPORTED_ELEMENT = 2;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$Metric;

    static {
        m_hashMetricElements = new HashMap();
        m_hashMetricElements.put("ValidIf", new Integer(1));
        m_hashMetricElements.put("ValidMidTierVersions", new Integer(1));
        m_hashMetricElements.put("Display", new Integer(0));
        m_hashMetricElements.put("CategoryValue", new Integer(0));
        m_hashMetricElements.put("TableDescriptor", new Integer(1));
        m_hashMetricElements.put("QueryDescriptor", new Integer(1));
        m_hashMetricElements.put("ExecutionDescriptor", new Integer(1));
        m_hashMetricElements.put("PushDescriptor", new Integer(1));
    }

    public Metric(Element element) throws SAXException {
        this.m_metricId = element.getAttribute(ATTR_ID);
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug("Working on metric " + this.m_metricId);
        }
        if (element.getAttribute(ATTR_INCREMENTAL).equalsIgnoreCase("true")) {
            this.m_isIncremental = true;
        }
        if (element.getAttribute(ATTR_CMDB_FORMAT).equalsIgnoreCase("true")) {
            this.m_isCmdbFormat = true;
        }
        this.m_metricElement = element;
        NodeList nodeList = element.getChildNodes();
        boolean bl = false;
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                String string = node.getNodeName();
                int n2 = this.validateElement(string);
                if (n2 == 2 || n2 == -1) {
                    bl = true;
                }
                if (node.getNodeName().equals("ValidIf")) {
                    this.m_ValidIfList.add(new ValidIf((Element)node));
                }
                if (node.getNodeName().equals("ValidMidTierVersions")) {
                    this.m_ValidMidTierVerList.add(new ValidMidTierVersions((Element)node));
                }
                if (node.getNodeName().equals("QueryDescriptor")) {
                    this.m_queryDescList.add(new QueryDescriptor((Element)node));
                }
                if (node.getNodeName().equals("TableDescriptor")) {
                    this.setTblDesc(new TableDescriptor((Element)node));
                }
            }
            ++n;
        }
        if (bl) {
            throw new SAXException("Unexpected ELEMENT encountered");
        }
    }

    private void addDigestToFileNameCols(MetricResult metricResult) {
        Vector vector = this.m_tblDesc.getColDescs();
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.get(n);
            if (columnDescriptor.isToBeReadFromFile()) {
                Vector vector2 = metricResult.getValueRows();
                if (vector2 == null) {
                    return;
                }
                int n2 = 0;
                while (n2 < vector2.size()) {
                    ValueRow valueRow = (ValueRow)vector2.get(n2);
                    String string = valueRow.getValue(n);
                    if (string != null) {
                        File file = new File(string);
                        String string2 = new Date().toString();
                        try {
                            string2 = Utils.getDigest(file);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException iOException) {}
                        string = String.valueOf(string) + "$FileDigest=" + string2;
                        valueRow.setValue(n, string);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MetricResult collect(Target target) throws SAXException, FetchletException {
        MetricResult metricResult = null;
        QueryDescriptor queryDescriptor = this.getValidQueryDesc(target);
        if (queryDescriptor != null) {
            metricResult = queryDescriptor.collect(target);
            this.addDigestToFileNameCols(metricResult);
        }
        return metricResult;
    }

    public int findColumnId(String string) {
        if (this.m_colDescs == null) {
            return -1;
        }
        int n = 0;
        while (n < this.m_colDescs.size()) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
            if (string.equals(columnDescriptor.getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getColumnDisplayName(int n) {
        return this.getDisplayLabel();
    }

    public String getColumnDisplayUnitName(int n) {
        return "";
    }

    public String getColumnName(int n) {
        if (this.isSimpleMetric()) {
            return null;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.getColumnName();
    }

    public TableDescriptor getColumnNestedTblDesc(int n) {
        if (this.isSimpleMetric()) {
            return null;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.getNestedTblDesc();
    }

    public int getColumnNumber() {
        if (this.isSimpleMetric()) {
            return 1;
        }
        return this.m_colDescs.size();
    }

    public String getColumnShortName(int n) {
        return null;
    }

    public int getColumnType(int n) {
        if (this.isSimpleMetric()) {
            return this.getTypeId();
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.getTypeId();
    }

    public String getCustomString() {
        return this.m_custom;
    }

    public Vector getDateColumns(ColumnDescriptor columnDescriptor) {
        if (!this.isRawMetric() || this.m_colDescs == null) {
            return null;
        }
        Vector vector = this.m_colDescs;
        if (columnDescriptor != null) {
            vector = columnDescriptor.getNestedTblDesc().getColDescs();
        }
        if (vector == null) {
            return null;
        }
        Vector<String> vector2 = null;
        int n = 0;
        while (n < vector.size()) {
            ColumnDescriptor columnDescriptor2 = (ColumnDescriptor)vector.elementAt(n);
            if (columnDescriptor2 != null && columnDescriptor2.isDate()) {
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                }
                vector2.addElement(columnDescriptor2.getColumnName());
            }
            ++n;
        }
        return vector2;
    }

    public String getDisplayLabel() {
        return this.m_metricId;
    }

    public int getKeyColumnId() {
        if (this.m_colDescs == null) {
            return -1;
        }
        int n = 0;
        while (n < this.m_colDescs.size()) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
            if (columnDescriptor.isKey()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int[] getKeyColumnIds() {
        Object object;
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.m_colDescs.size()) {
            object = (ColumnDescriptor)this.m_colDescs.elementAt(n);
            if (((ColumnDescriptor)object).isKey()) {
                vector.addElement(new Integer(n));
            }
            ++n;
        }
        object = new int[vector.size()];
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            object[n2] = (Integer)vector.elementAt(n2);
            ++n2;
        }
        return object;
    }

    public String getKeyName() {
        String string = null;
        if (this.m_colDescs == null) {
            return null;
        }
        int n = 0;
        while (n < this.m_colDescs.size()) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
            if (columnDescriptor.isKey()) {
                string = columnDescriptor.getName();
                break;
            }
            ++n;
        }
        return string;
    }

    public String getKeyValue(ValueRow valueRow) {
        String string = null;
        if (this.m_colDescs == null) {
            return null;
        }
        int n = 0;
        while (n < this.m_colDescs.size()) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
            if (columnDescriptor.isKey()) {
                string = valueRow.getValue(n);
                break;
            }
            ++n;
        }
        return string;
    }

    public String getKeyValue(ValueRow valueRow, int[] nArray) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            string = valueRow.getValue(nArray[n]);
            if (string != null) {
                stringBuffer.append(string);
                if (n < nArray.length - 1) {
                    stringBuffer.append(",");
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getMetricId() {
        return this.m_metricId;
    }

    public Vector getPrimaryKey(ColumnDescriptor columnDescriptor) {
        Serializable serializable;
        if (this.m_tblDesc == null) {
            return null;
        }
        Vector<String> vector = null;
        int n = 0;
        while (n < this.m_colDescs.size()) {
            serializable = (ColumnDescriptor)this.m_colDescs.elementAt(n);
            if (((ColumnDescriptor)serializable).isKey()) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(((ColumnDescriptor)serializable).getColumnName());
            }
            ++n;
        }
        if (columnDescriptor != null) {
            serializable = columnDescriptor.getNestedTblDesc().getColDescs();
            int n2 = 0;
            while (n2 < ((Vector)serializable).size()) {
                ColumnDescriptor columnDescriptor2 = (ColumnDescriptor)((Vector)serializable).elementAt(n2);
                if (columnDescriptor2.isKey()) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.addElement(columnDescriptor2.getColumnName());
                }
                ++n2;
            }
        }
        return vector;
    }

    public String getReposPlSql() {
        return this.m_reposPlSql;
    }

    public String getTableName() {
        if (this.m_tblDesc == null) {
            return null;
        }
        return this.m_tblDesc.getTableName();
    }

    public TableDescriptor getTblDesc() {
        return this.m_tblDesc;
    }

    public int getTypeId() {
        return this.m_typeId;
    }

    public static int getTypeId(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < TYPES.length) {
            if (TYPES[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public int getUsageTypeId() {
        return this.m_usageTypeId;
    }

    public static int getUsageTypeId(String string) {
        int n = -1;
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n2 = 0;
        while (n2 < USAGE_TYPES.length) {
            if (USAGE_TYPES[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private QueryDescriptor getValidQueryDesc(Target target) {
        return (QueryDescriptor)this.m_queryDescList.getValidElement(target);
    }

    public boolean hasComputedColumn() {
        return this.m_tblDesc != null && this.m_tblDesc.hasComputedColumn();
    }

    public void init(Attributes attributes) throws SAXException {
        this.m_metricId = attributes.getValue(ATTR_ID);
        this.m_typeId = Metric.getTypeId(attributes.getValue(ATTR_TYPE));
        this.m_usageTypeId = Metric.getUsageTypeId(attributes.getValue(ATTR_USAGETYPE));
        this.m_reposPlSql = attributes.getValue(ATTR_REPOS_PLSQL);
        this.m_custom = attributes.getValue(ATTR_CUSTOM);
        if (this.m_metricId == null || this.m_metricId.equals("")) {
            throw new SAXException("Invalid value for NAME in Metric");
        }
        if (!(this.m_typeId != 5 && this.m_typeId != 6 && this.m_typeId != 7 || this.m_reposPlSql != null && !this.m_reposPlSql.equals(""))) {
            throw new SAXException("Invalid value for REPOS_PLSQL in Metric:" + this.m_metricId);
        }
        if (this.m_typeId == -1) {
            throw new SAXException("Invalid value for type  : " + attributes.getValue(ATTR_TYPE) + " in " + TAGNAME + ":" + this.m_metricId);
        }
        if (this.m_usageTypeId == -1) {
            throw new SAXException("Invalid value for usage type  : " + attributes.getValue(ATTR_USAGETYPE) + " in " + TAGNAME + ":" + this.m_metricId);
        }
    }

    public boolean isCmdbFormat() {
        return this.m_isCmdbFormat;
    }

    public boolean isElementValid(Target target) throws SAXException {
        return this.m_ValidIfList.isValid(target);
    }

    public boolean isForSummaryUI(int n) {
        return false;
    }

    public boolean isIncremental() {
        return this.m_isIncremental;
    }

    public boolean isKeyColumn(int n) {
        if (this.isSimpleMetric()) {
            return false;
        }
        if (n < 0 || n >= this.m_colDescs.size()) {
            return false;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.isKey();
    }

    public boolean isLongText(int n) {
        if (this.isSimpleMetric()) {
            return false;
        }
        if (n < 0 || n >= this.m_colDescs.size()) {
            return false;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.isLongText();
    }

    public boolean isMidTierValid() throws SAXException {
        return this.m_ValidMidTierVerList.isValid(null);
    }

    public boolean isRawMetric() {
        return this.getTypeId() == 3;
    }

    public boolean isSimpleMetric() {
        return this.getTypeId() == 0 || this.getTypeId() == 1 || this.getTypeId() == 4;
    }

    public boolean isTransientColumn(int n) {
        if (this.isSimpleMetric()) {
            return false;
        }
        if (n < 0 || n >= this.m_colDescs.size()) {
            return false;
        }
        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_colDescs.elementAt(n);
        return columnDescriptor.isTransient();
    }

    private void setTblDesc(TableDescriptor tableDescriptor) {
        this.m_tblDesc = tableDescriptor;
        if (tableDescriptor == null) {
            return;
        }
        this.m_colDescs = tableDescriptor.getColDescs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int validateElement(String string) {
        int n = -1;
        Integer n2 = (Integer)m_hashMetricElements.get(string);
        if (n2 != null) {
            n = n2;
            switch (n2) {
                case 2: {
                    if (!s_log.isEnabledFor(Logger.WARN)) return n;
                    s_log.warn(TargetsMetadataMsgID.UNSUPPORTED_METRIC_CHILD, new String[]{string});
                    return n;
                }
                case 0: {
                    if (!s_log.isEnabledFor(Logger.DEBUG)) return n;
                    s_log.debug(s_bundle.getMessage(TargetsMetadataMsgID.IGNORED_METRIC_CHILD, false, (Object[])new String[]{string}));
                    return n;
                }
                case 1: {
                    if (!s_log.isEnabledFor(Logger.DEBUG)) return n;
                    s_log.debug(s_bundle.getMessage(TargetsMetadataMsgID.SUPPORTED_METRIC_CHILD, false, (Object[])new String[]{string}));
                    return n;
                }
                default: {
                    return n;
                }
            }
        }
        s_log.error(TargetsMetadataMsgID.UNEXPECTED_METRIC_CHILD, new String[]{string});
        return n;
    }
}

