/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.fetchlets.Fetchlet;
import oracle.sysman.ccr.collector.fetchlets.FetchletException;
import oracle.sysman.ccr.collector.fetchlets.FetchletManager;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.targets.metadata.Property;
import oracle.sysman.ccr.collector.targets.metadata.TargetsMetadataMsgID;
import oracle.sysman.ccr.collector.targets.metadata.ValidIf;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorEnabled;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorList;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryDescriptor
implements ValiditySelectorEnabled {
    static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor != null ? class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor : (class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor = QueryDescriptor.class$("oracle.sysman.ccr.collector.targets.metadata.QueryDescriptor")));
    static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.targets.metadata.TargetsMetadata");
    static final String TAGNAME = "QueryDescriptor";
    private static final String ATTR_FETCHLETID = "FETCHLET_ID";
    private String m_fetchletId = null;
    private Vector m_properties = null;
    private Element m_elementQD = null;
    private ValiditySelectorList m_ValidIfList = new ValiditySelectorList();
    private static RE s_propMatch = null;
    private static RE m_varExpression = null;
    static final String ENV_PREFIX = "ENV";
    static final String ENV_LD_PRELOAD = "LD_PRELOAD";
    static final String ENV_PROP_PERL5LIB = "PERL5LIB";
    static final String ENV_PROP_EMDROOT = "EMDROOT";
    static final String ENV_PROP_ORACLE_HOME = "ORACLE_HOME";
    static final String ENV_PROP_CCR_CONFIG_HOME = "CCR_CONFIG_HOME";
    static final String ENV_EMAGENT_PERL_TRACE_DIR = "EMAGENT_PERL_TRACE_DIR";
    static final String ENV_EMAGENT_PERL_TRACE_LEVEL = "EMAGENT_PERL_TRACE_LEVEL";
    static final String ENV_AGENT_HOME = "AGENT_HOME";
    static final String ENV_EMSTATE = "EMSTATE";
    static final String TNS_ADMIN = "TNS_ADMIN";
    static final String ENV_CCR_HOME = "CCR_HOME";
    static final String ENV_CCR_JAVA_HOME = "CCR_JAVA_HOME";
    static final String ENV_CRS_HOME = "CRS_HOME";
    static final String ENV_USER_ORACLE_HOME = "USER_ORACLE_HOME";
    static final String ENV_COMSPEC = "COMSPEC";
    static final String ENV_SYSTEMROOT = "SYSTEMROOT";
    static final String ENV_TZ = "TZ";
    static final String ENV_AGENTPROXYHOME = "AGENTPROXYHOME";
    static final String ENV_JDBC_OCI_SWITCH = "JDBC_OCI_SWITCH";
    private final String ENV_WL_HOME = "WL_HOME";
    private final String ENV_BEA_HOME = "BEA_HOME";
    static final String ENV_JAVA_HOME = "JAVA_HOME";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$QueryDescriptor;

    static {
        try {
            s_propMatch = new RE("^([^=]*)=(.*)$");
            m_varExpression = new RE("%([^%]+)%");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException("Error with creating regular expression - " + rESyntaxException.getMessage());
        }
    }

    public QueryDescriptor(Element element) throws SAXException {
        this.m_properties = new Vector();
        this.m_elementQD = element;
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItem(ATTR_FETCHLETID);
        if (attr != null) {
            this.m_fetchletId = attr.getValue();
            if (this.m_fetchletId == null || this.m_fetchletId.equals("")) {
                throw new SAXException("Invalid value for FETCHLET_ID in QueryDescriptor");
            }
        } else {
            throw new SAXException("Invalid value for FETCHLET_ID in QueryDescriptor");
        }
        this.addProperties();
        this.addValidIfs();
    }

    private void addProperties() throws SAXException {
        NodeList nodeList = this.m_elementQD.getElementsByTagName("Property");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                this.addProperty(new Property((Element)node));
            } else if (s_log.isEnabledFor(Logger.DEBUG)) {
                s_log.debug("Encountered a non-element Property node");
            }
            ++n;
        }
    }

    public void addProperty(Property property) {
        this.m_properties.add(property);
    }

    private void addValidIfs() throws SAXException {
        NodeList nodeList = this.m_elementQD.getElementsByTagName("ValidIf");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                this.m_ValidIfList.add(new ValidIf((Element)node));
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MetricResult collect(Target target) throws FetchletException {
        return this.collect(target, true);
    }

    public MetricResult collect(Target target, boolean bl) throws FetchletException {
        Fetchlet fetchlet = this.getFetchletInstance();
        Properties properties = new Properties();
        if (bl) {
            this.getDefaultProperties(properties, target);
            this.getDefaultEnvProperties(properties);
        }
        if (!this.getProperties(properties, target)) {
            return null;
        }
        return fetchlet.getMetric(properties);
    }

    private void getDefaultEnvProperties(Properties properties) {
        Config config = UplinkHomeConfig.getInstance();
        String string = null;
        string = System.getProperty(ENV_LD_PRELOAD);
        if (string != null) {
            ((Hashtable)properties).put("ENVLD_PRELOAD", string);
        }
        String string2 = null;
        string2 = System.getProperty(ENV_PROP_PERL5LIB);
        if (string2 != null) {
            ((Hashtable)properties).put("ENVPERL5LIB", string2);
        }
        String string3 = null;
        string3 = System.getProperty(ENV_CCR_JAVA_HOME);
        if (string3 != null) {
            ((Hashtable)properties).put("ENVCCR_JAVA_HOME", string3);
        }
        String string4 = null;
        string4 = System.getProperty(ENV_USER_ORACLE_HOME);
        if (string4 != null) {
            ((Hashtable)properties).put("ENVUSER_ORACLE_HOME", string4);
        }
        ((Hashtable)properties).put("ENVCCR_HOME", FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.LIVE_LINK_PATH}));
        String string5 = System.getProperty("SHLIB_VAR");
        if (string5 != null && s_propMatch.match(string5)) {
            ((Hashtable)properties).put(ENV_PREFIX + s_propMatch.getParen(1), s_propMatch.getParen(2));
        }
        ((Hashtable)properties).put("ENVEMDROOT", FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.LIVE_LINK_PATH}));
        ((Hashtable)properties).put("ENVEMAGENT_PERL_TRACE_DIR", FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), UplinkPath.LOG_PATH}));
        String string6 = System.getProperty(ENV_EMAGENT_PERL_TRACE_LEVEL);
        if (string6 != null) {
            ((Hashtable)properties).put("ENVEMAGENT_PERL_TRACE_LEVEL", string6);
        }
        String string7 = null;
        string7 = System.getProperty(TNS_ADMIN);
        if (string7 != null) {
            ((Hashtable)properties).put("ENVTNS_ADMIN", string7);
        }
        String string8 = null;
        string8 = System.getProperty(ENV_CRS_HOME);
        if (string8 != null && string8.length() > 0) {
            ((Hashtable)properties).put("ENVCRS_HOME", string8);
        }
        ((Hashtable)properties).put("ENVORACLE_HOME", Collector.getOracleHome());
        ((Hashtable)properties).put("ENVCCR_CONFIG_HOME", Collector.getCCRConfigHome());
        String string9 = null;
        string9 = System.getProperty(ENV_COMSPEC);
        if (string9 != null) {
            ((Hashtable)properties).put("ENVCOMSPEC", string9);
        }
        String string10 = null;
        string10 = System.getProperty(ENV_SYSTEMROOT);
        if (string10 != null) {
            ((Hashtable)properties).put("ENVSYSTEMROOT", string10);
        }
        String string11 = null;
        string11 = System.getProperty(ENV_EMSTATE);
        if (string11 != null) {
            ((Hashtable)properties).put("ENVEMSTATE", string11);
        }
        String string12 = null;
        string12 = System.getProperty(ENV_TZ);
        if (string12 != null) {
            ((Hashtable)properties).put("ENVTZ", string12);
        }
        String string13 = UplinkPath.gridAgentMode() ? "1" : "0";
        ((Hashtable)properties).put("ENVAGENT_HOME", string13);
        String string14 = null;
        string14 = System.getProperty(ENV_AGENTPROXYHOME);
        if (string14 != null) {
            ((Hashtable)properties).put("ENVAGENTPROXYHOME", string14);
        }
        String string15 = null;
        string15 = System.getProperty(ENV_JDBC_OCI_SWITCH);
        if (string15 != null) {
            ((Hashtable)properties).put("ENVJDBC_OCI_SWITCH", string15);
        }
        String string16 = null;
        string16 = System.getProperty("WL_HOME");
        if (string16 != null) {
            ((Hashtable)properties).put("ENVWL_HOME", string16);
        }
        String string17 = null;
        string17 = System.getProperty("BEA_HOME");
        if (string17 != null) {
            ((Hashtable)properties).put("ENVBEA_HOME", string17);
        }
        if (UplinkPath.gridAgentMode()) {
            String string18 = null;
            string18 = System.getProperty(ENV_CCR_JAVA_HOME);
            if (string18 != null) {
                ((Hashtable)properties).put("ENVJAVA_HOME", string18);
            }
        }
    }

    private void getDefaultProperties(Properties properties, Target target) {
        TargetManager targetManager = TargetManager.getInstance();
        ((Hashtable)properties).put("TYPE_DISPLAY_NAME", targetManager.getTargetTypeDisplayName(target.getTargetType()));
    }

    public String getFetchletId() {
        return this.m_fetchletId;
    }

    private Fetchlet getFetchletInstance() throws FetchletException {
        FetchletManager fetchletManager = null;
        try {
            fetchletManager = FetchletManager.getInstance();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FetchletException("Unable to load fetchlets registry", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new FetchletException("Error in reading fetchlet registry", iOException);
        }
        return fetchletManager.getFetchlet(this.getFetchletId());
    }

    private boolean getProperties(Properties properties, Target target) throws FetchletException {
        Config config = UplinkHomeConfig.getInstance();
        int n = 0;
        while (n < this.m_properties.size()) {
            Property property = (Property)this.m_properties.get(n);
            String string = property.getName();
            String string2 = property.getContents();
            this.logDuplicateEncountered(properties, string2);
            String string3 = null;
            switch (property.getScopeId()) {
                case 3: {
                    string3 = config.getProperty(string2);
                    if (string3 != null) break;
                    throw new FetchletException("Unable to locate Oracle Configuration Manager SYSTEMGLOBAL property " + string2);
                }
                case 1: {
                    string3 = target.getTargetProperty(string2);
                    break;
                }
                case 4: {
                    TargetManager targetManager = TargetManager.getInstance();
                    Target target2 = null;
                    Target[] targetArray = targetManager.getTargetInstances("host");
                    int n2 = 0;
                    while (n2 < targetArray.length) {
                        if (target.getTargetHost().equals(targetArray[n2].getTargetName())) {
                            target2 = targetArray[n2];
                            break;
                        }
                        ++n2;
                    }
                    if (target2 == null) {
                        throw new FetchletException("Unable to locate Oracle Configuration Manager HOST scope property " + string2 + " for target " + target.getTargetName());
                    }
                    string3 = target2.getTargetProperty(string2);
                    break;
                }
                case 0: 
                case 7: {
                    string3 = string2;
                    break;
                }
                default: {
                    throw new FetchletException("Unsupported QueryDescriptor (" + property.getScopeId() + ") encountered");
                }
            }
            if (string3 != null) {
                string2 = this.replaceVariables(string3, properties, target);
                ((Hashtable)properties).put(string, string2);
            }
            if (string3 == null && !property.isOptional()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String getReplacementForProperty(String string, Properties properties, Target target) {
        String string2 = (String)((Hashtable)properties).get(string);
        if (string2 == null && (string2 = target.getTargetProperty(string)) == null) {
            string2 = UplinkHomeConfig.getInstance().getProperty(string);
        }
        return string2;
    }

    public boolean isElementValid(Target target) throws SAXException {
        return this.m_ValidIfList.isValid(target);
    }

    private void logDuplicateEncountered(Properties properties, String string) {
        if (((Hashtable)properties).containsKey(string) && s_log.isEnabledFor(Logger.WARN)) {
            s_log.warn(TargetsMetadataMsgID.DUPLICATE_QUERY_DESCRIPTOR, new String[]{string});
        }
    }

    private String replaceVariables(String string, Properties properties, Target target) throws FetchletException {
        int n = 0;
        String string2 = string;
        RE rE = m_varExpression;
        synchronized (rE) {
            while (m_varExpression.match(string2, n)) {
                String string3 = m_varExpression.getParen(0);
                String string4 = m_varExpression.getParen(1);
                String string5 = this.getReplacementForProperty(string4, properties, target);
                if (string5 != null) {
                    RE rE2 = null;
                    try {
                        rE2 = new RE(string3);
                        string2 = rE2.subst(string2, string5);
                    }
                    catch (RESyntaxException rESyntaxException) {
                        throw new FetchletException("Invalid variable name encountered in the variable substitution (" + string3 + ")");
                    }
                    n = m_varExpression.getParenStart(0) + string5.length();
                    continue;
                }
                n = m_varExpression.getParenEnd(0);
            }
        }
        return string2;
    }
}

