/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.Display;
import oracle.sysman.ccr.collector.targets.metadata.DynamicProperties;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TargetsMetadataMsgID;
import oracle.sysman.ccr.collector.targets.metadata.ValiditySelectorList;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TargetMetadata {
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata != null ? class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata : (class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata = TargetMetadata.class$("oracle.sysman.ccr.collector.targets.metadata.TargetMetadata")));
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.targets.metadata.TargetsMetadata");
    private static String m_strMetadataSystemId = null;
    private String m_strTargetType = null;
    private String m_metadataVersion = null;
    private Element m_elementMetadataRoot = null;
    private HashMap m_hashConfigMetrics = null;
    private Vector m_dynamicProps = null;
    private Display m_displayNode = null;
    private boolean m_bCollectedAcrossNodes = false;
    private static final String ATTR_META_VER = "META_VER";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata;

    public TargetMetadata(String string) throws SAXException, FileNotFoundException {
        this.m_strTargetType = string;
        if (s_log.isEnabledFor(Logger.DEBUG)) {
            s_log.debug("Parsing metadata for \"" + string + "\"");
        }
        this.m_elementMetadataRoot = this.getTargetMetadata();
        this.setDisplayNode();
        this.setTargetMetadataVersion();
        this.m_dynamicProps = this.dynamicProps();
        this.m_hashConfigMetrics = this.configMetricDefns();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private HashMap configMetricDefns() throws SAXException {
        HashMap<String, ValiditySelectorList> hashMap = new HashMap<String, ValiditySelectorList>();
        ValiditySelectorList validitySelectorList = null;
        NodeList nodeList = this.m_elementMetadataRoot.getElementsByTagName("Metric");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Metric metric;
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = namedNodeMap.getNamedItem("NAME");
                Node node3 = namedNodeMap.getNamedItem("CONFIG");
                Node node4 = namedNodeMap.getNamedItem("COLLECT_ON_ALL_NODES");
                if (node3 != null && node3.getNodeValue().equals("TRUE") && (metric = new Metric((Element)node)).isMidTierValid()) {
                    String string;
                    String string2 = node2.getNodeValue();
                    if (hashMap.containsKey(string2)) {
                        validitySelectorList = (ValiditySelectorList)hashMap.get(string2);
                        validitySelectorList.add(metric);
                    } else {
                        validitySelectorList = new ValiditySelectorList();
                        validitySelectorList.add(metric);
                        hashMap.put(string2, validitySelectorList);
                    }
                    if (node4 != null && Boolean.valueOf(string = node4.getNodeValue()).booleanValue()) {
                        this.m_bCollectedAcrossNodes = true;
                    }
                }
            }
            ++n;
        }
        return hashMap;
    }

    private Vector dynamicProps() throws SAXException {
        Node node;
        Vector<DynamicProperties> vector = new Vector<DynamicProperties>();
        NodeList nodeList = this.m_elementMetadataRoot.getElementsByTagName("InstanceProperties");
        if (nodeList.getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1) {
            NodeList nodeList2 = node.getChildNodes();
            int n = 0;
            while (n < nodeList2.getLength()) {
                Node node2 = nodeList2.item(n);
                if (node2.getNodeType() == 1 && node2.getNodeName().equals("DynamicProperties")) {
                    DynamicProperties dynamicProperties;
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    Node node3 = namedNodeMap.getNamedItem("NAME");
                    Node node4 = namedNodeMap.getNamedItem("PROP_LIST");
                    if (node4 != null && (dynamicProperties = new DynamicProperties((Element)node2)).areAllValidFetchletIds()) {
                        vector.add(dynamicProperties);
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    private Element findMetadataRoot(Document document) throws SAXException {
        Element element = null;
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength() && element == null) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNodeName().equals("TargetMetadata")) {
                element = (Element)node;
            }
            ++n;
        }
        if (element == null) {
            throw new SAXException("Unable to locate TargetMetadata element.");
        }
        return element;
    }

    public Vector getDynProps() {
        return this.m_dynamicProps;
    }

    private String getMetadataSystemId() throws SAXException {
        if (m_strMetadataSystemId == null) {
            Class clazz = class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata != null ? class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata : (class$oracle$sysman$ccr$collector$targets$metadata$TargetMetadata = TargetMetadata.class$("oracle.sysman.ccr.collector.targets.metadata.TargetMetadata"));
            synchronized (clazz) {
                if (m_strMetadataSystemId == null) {
                    try {
                        String[] stringArray = new String[]{Collector.getOracleHome(), UplinkPath.METADATA_PATH};
                        File file = new File(FileSpec.catfile(stringArray));
                        m_strMetadataSystemId = file.toURL().toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SAXException("Error in constructing URL for metadata SystemID", malformedURLException);
                    }
                }
            }
        }
        return m_strMetadataSystemId;
    }

    public String getMetadataVersion() {
        return this.m_metadataVersion;
    }

    public Metric getMetric(String string, Target target) {
        Object var3_3 = null;
        ValiditySelectorList validitySelectorList = (ValiditySelectorList)this.m_hashConfigMetrics.get(string);
        if (validitySelectorList == null) {
            return null;
        }
        return (Metric)validitySelectorList.getValidElement(target);
    }

    private Element getTargetMetadata() throws SAXException, FileNotFoundException {
        Element element = null;
        String[] stringArray = new String[]{Collector.getOracleHome(), UplinkPath.METADATA_PATH, String.valueOf(this.m_strTargetType) + ".xml"};
        String string = FileSpec.catfile(stringArray);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setCoalescing(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            FileInputStream fileInputStream = new FileInputStream(string);
            InputSource inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId(this.getMetadataSystemId());
            Document document = documentBuilder.parse(inputSource);
            fileInputStream.close();
            element = this.findMetadataRoot(document);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new SAXException("Error reading target metadata file for type " + this.m_strTargetType, iOException);
        }
        catch (SAXException sAXException) {
            throw new SAXException("Error parsing target metadata file for " + this.m_strTargetType, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Error creating DOM document for parsing metadata", parserConfigurationException);
        }
        return element;
    }

    public String getTypeDisplayString() {
        if (this.m_displayNode != null) {
            return this.m_displayNode.getDisplayName();
        }
        return this.m_strTargetType;
    }

    private void setDisplayNode() throws SAXException {
        this.m_displayNode = null;
        NodeList nodeList = this.m_elementMetadataRoot.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength() && this.m_displayNode == null) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNodeName().equals("Display")) {
                this.m_displayNode = new Display((Element)node);
            }
            ++n;
        }
    }

    private void setTargetMetadataVersion() {
        if (this.m_elementMetadataRoot.hasAttribute(ATTR_META_VER)) {
            this.m_metadataVersion = this.m_elementMetadataRoot.getAttribute(ATTR_META_VER);
        } else if (s_log.isEnabledFor(Logger.WARN)) {
            s_log.warn(TargetsMetadataMsgID.META_VER_MISSING, new String[]{this.getTypeDisplayString()});
        }
    }

    public boolean supportsConfigMetrics() {
        return this.m_hashConfigMetrics.size() > 0;
    }

    public boolean targetTypeCrossesHosts() {
        return this.m_bCollectedAcrossNodes;
    }
}

