/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.targets.metadata;

import java.io.Serializable;
import oracle.sysman.ccr.collector.softwareMgr.ComponentVersion;
import oracle.sysman.ccr.collector.softwareMgr.InvalidComponentVersionException;
import oracle.sysman.ccr.collector.targets.metadata.CCRMetadataVer;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ValidMidTierVersions
implements Serializable {
    private static final long serialVersionUID = -8927216404652349036L;
    static final String TAGNAME = "ValidMidTierVersions";
    private static final String ATTR_STARTVER = "START_VER";
    private static final String ATTR_ENDVER = "END_VER";
    private static final String ATTR_PLUGIN = "PLUG_IN";
    private String m_startVer = null;
    private String m_endVer = null;
    private String m_plugin = null;

    public ValidMidTierVersions(Element element) {
        if (element.hasAttribute(ATTR_STARTVER)) {
            this.m_startVer = element.getAttribute(ATTR_STARTVER);
        }
        if (element.hasAttribute(ATTR_ENDVER)) {
            this.m_endVer = element.getAttribute(ATTR_ENDVER);
        }
        if (element.hasAttribute(ATTR_PLUGIN)) {
            this.m_plugin = element.getAttribute(ATTR_PLUGIN);
        }
    }

    public boolean evaluate() throws SAXException {
        String string = null;
        try {
            string = this.m_plugin != null ? CCRMetadataVer.getPluginVer(this.m_plugin) : CCRMetadataVer.getMetadataVer();
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException(runtimeException.getMessage());
        }
        if (string == null) {
            throw new SAXException("OMS Version is null");
        }
        try {
            return ComponentVersion.compare(this.m_startVer, string) <= 0 && ComponentVersion.compare(string, this.m_endVer) < 0;
        }
        catch (InvalidComponentVersionException invalidComponentVersionException) {
            throw new SAXException(invalidComponentVersionException.getMessage());
        }
    }
}

