/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.timezone;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import oracle.sysman.ccr.collector.timezone.TimezoneMsgID;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class Timezone {
    private static Timezone s_instance = null;
    public static String FILENAME = "timezones.properties";
    private String m_strSupportedRegion = null;
    private Properties m_properties;
    private String m_strTZDefaultRegion = null;
    private TimeZone m_TZ = null;
    private static int NULL_OFFSET = -999;
    private int m_nOffset = NULL_OFFSET;
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$timezone$Timezone != null ? class$oracle$sysman$ccr$collector$timezone$Timezone : (class$oracle$sysman$ccr$collector$timezone$Timezone = Timezone.class$("oracle.sysman.ccr.collector.timezone.Timezone")));
    private static final MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.timezone.Timezone");
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$timezone$Timezone;

    public Timezone() {
        this.m_TZ = TimeZone.getDefault();
        this.m_strTZDefaultRegion = this.m_TZ.getID();
        int n = this.m_TZ.getRawOffset() / 1000;
        Calendar calendar = Calendar.getInstance();
        this.m_nOffset = this.m_TZ.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14)) / 1000;
    }

    private String calculateOffsetRegion(int n) {
        boolean bl;
        String string = null;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        int n2 = n / 60;
        int n3 = n2 / 60;
        n2 %= 60;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3).append(":");
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        string = stringBuffer.toString();
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String findSupportedRegion(String string) {
        this.m_strSupportedRegion = null;
        if (this.m_properties == null) {
            this.m_properties = this.load();
        }
        if (this.m_properties != null) {
            this.m_strSupportedRegion = (String)((Hashtable)this.m_properties).get(string);
        }
        return this.m_strSupportedRegion;
    }

    public static Timezone getInstance() {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$timezone$Timezone != null ? class$oracle$sysman$ccr$collector$timezone$Timezone : (class$oracle$sysman$ccr$collector$timezone$Timezone = Timezone.class$("oracle.sysman.ccr.collector.timezone.Timezone"));
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new Timezone();
                }
            }
        }
        return s_instance;
    }

    public int getOffset() {
        return this.m_nOffset;
    }

    public String getSupportedRegion() {
        if (this.m_strSupportedRegion == null) {
            this.m_strSupportedRegion = this.getSupportedRegion(this.m_strTZDefaultRegion);
            if (s_log.isDebugEnabled()) {
                s_log.debug("Supported TZ Region = " + this.m_strSupportedRegion + "\n");
            }
        }
        return this.m_strSupportedRegion;
    }

    public String getSupportedRegion(String string) {
        this.findSupportedRegion(string);
        if (this.m_strSupportedRegion == null) {
            this.m_strSupportedRegion = this.calculateOffsetRegion(this.m_nOffset);
        }
        return this.m_strSupportedRegion;
    }

    public static String getTimezonesFilename() {
        return UplinkPath.omsMode() ? FileSpec.catfile(new String[]{UplinkPath.omsConfigDir(), FILENAME}) : FileSpec.catfile(new String[]{AgentConfig.getCCRRootConfigDir(), UplinkPath.DEFAULT_CONFIG_PATH, FILENAME});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties load() {
        Properties properties = new Properties();
        String string = Timezone.getTimezonesFilename();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                s_log.error(TimezoneMsgID.TIMEZONE_DATA_FNF, new String[]{string}, fileNotFoundException);
                properties = null;
            }
            catch (IOException iOException) {
                s_log.error(TimezoneMsgID.TIMEZONE_READERR, new String[]{string}, iOException);
                properties = null;
            }
            Object var5_8 = null;
            if (bufferedInputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedInputStream.close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
    }
}

