/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.sysman.ccr.common.ResourceID;
import oracle.sysman.ccr.common.logging.LogMsgID;
import oracle.sysman.ccr.common.logging.Logger;

public class MessageBundle {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$common$MessageBundle != null ? class$oracle$sysman$ccr$common$MessageBundle : (class$oracle$sysman$ccr$common$MessageBundle = MessageBundle.class$("oracle.sysman.ccr.common.MessageBundle")));
    private static final String RESOURCE_LOCATION = "resources";
    private static final String LOCAL_RESOURCE_LOCATION = "local";
    protected ResourceBundle m_resBundle = null;
    protected ResourceBundle m_localBundle = null;
    private String m_facility = null;
    private Locale m_locale = null;
    private static Map m_hBundles = new HashMap();
    private static Locale m_defLocale = Locale.getDefault();
    static /* synthetic */ Class class$oracle$sysman$ccr$common$MessageBundle;

    public MessageBundle() {
    }

    protected MessageBundle(String string, Locale locale) {
        this.m_facility = string;
        this.m_locale = locale;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static MessageBundle createMessageBundle(String string, Locale locale) {
        MessageBundle messageBundle = new MessageBundle(string, locale);
        String string2 = "resources." + messageBundle.m_facility + "Msg";
        String string3 = "local." + messageBundle.m_facility + "Msg";
        try {
            messageBundle.m_localBundle = ResourceBundle.getBundle(string3, locale);
        }
        catch (MissingResourceException missingResourceException) {}
        try {
            messageBundle.m_resBundle = ResourceBundle.getBundle(string2, locale);
        }
        catch (MissingResourceException missingResourceException) {
            s_logger.debug("unable to find resource bundle", missingResourceException);
            throw missingResourceException;
        }
        return messageBundle;
    }

    private String getCode(String string) {
        return String.valueOf(this.getFacility().toUpperCase()) + ":" + string;
    }

    public String getFacility() {
        return this.m_facility;
    }

    public static MessageBundle getInstance(String string) {
        return MessageBundle.getInstance(string, m_defLocale);
    }

    public static MessageBundle getInstance(String string, Locale locale) {
        MessageBundle messageBundle = null;
        String string2 = String.valueOf(string) + "|" + locale.toString();
        Map map = m_hBundles;
        synchronized (map) {
            messageBundle = (MessageBundle)m_hBundles.get(string2);
            if (messageBundle == null) {
                messageBundle = MessageBundle.createMessageBundle(string, locale);
                m_hBundles.put(string2, messageBundle);
            }
        }
        return messageBundle;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    private String getMessage(String string) {
        return this.getMessage(string, false);
    }

    private String getMessage(String string, boolean bl) {
        String string2 = null;
        if (this.m_localBundle != null) {
            try {
                string2 = this.m_localBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (string2 == null) {
            try {
                string2 = this.getResourceBundle().getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = "<null>";
                s_logger.warn(LogMsgID.LOCAL_MESSAGE_NOT_FOUND, new Object[]{this.getCode(string)});
            }
        }
        if (!bl) {
            return string2;
        }
        return String.valueOf(this.getCode(string)) + ": " + string2;
    }

    private String getMessage(String string, boolean bl, Object[] objectArray) {
        return MessageFormat.format(this.getMessage(string, bl), objectArray);
    }

    public String getMessage(ResourceID resourceID, boolean bl) {
        return this.getMessage(resourceID.getName(), bl);
    }

    public String getMessage(ResourceID resourceID, boolean bl, Object[] objectArray) {
        return this.getMessage(resourceID.getName(), bl, objectArray);
    }

    public ResourceBundle getResourceBundle() {
        return this.m_resBundle;
    }
}

