/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.diagnostic.uploader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagnosticMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.diagnostic.uploader.UploadStateHandler;
import oracle.sysman.ccr.diagnostic.uploader.UploaderMsgID;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class UploadState {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$diagnostic$uploader$UploadState != null ? class$oracle$sysman$ccr$diagnostic$uploader$UploadState : (class$oracle$sysman$ccr$diagnostic$uploader$UploadState = UploadState.class$("oracle.sysman.ccr.diagnostic.uploader.UploadState")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.uploader.Uploader");
    private static MessageBundle s_msgCommonBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.common.Diagnostic");
    private File m_stateFile = null;
    private String m_packageName = null;
    private long m_packageSize = -1L;
    private String m_packageDigest = null;
    private String m_submitTime = null;
    private String m_startTime = null;
    private String m_endTime = null;
    private String m_updateTime = null;
    private String m_state = null;
    private long m_progress = -1L;
    private int m_processID = -1;
    private int m_restartCount = -1;
    private String m_serviceRequest = null;
    private StringBuffer m_uploadStateXML = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$diagnostic$uploader$UploadState;

    public UploadState(File file) throws InvalidStateException, StateAccessException, NoSuchReqException {
        this.load(file);
    }

    public UploadState(String string, String string2) throws InvalidStateException, StateAccessException, NoSuchReqException {
        this.m_serviceRequest = string;
        this.m_packageName = string2;
        this.load();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        Date date = new Date();
        ++this.m_restartCount;
        this.m_startTime = simpleDateFormat.format(date);
        this.m_processID = -1;
    }

    public UploadState(String string, String string2, long l, String string3) throws StateCreationException, StateAccessException {
        this.m_packageName = string2;
        this.m_packageSize = l;
        this.m_packageDigest = string3;
        this.m_serviceRequest = string;
        this.m_processID = -1;
        this.create();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void create() throws StateCreationException, StateAccessException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        Date date = new Date();
        this.m_startTime = this.m_submitTime = simpleDateFormat.format(date);
        this.m_state = "STARTED";
        this.m_progress = 0L;
        this.m_restartCount = 0;
    }

    private String getDTDPath() {
        return FileSpec.catfile(new String[]{"file:" + Collector.getOracleHome(), UplinkPath.DTD_HOME_PATH, "DiagnosticUpload.dtd"});
    }

    public String getEndTime() {
        return this.m_endTime;
    }

    public String getPackageDigest() {
        return this.m_packageDigest;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public long getPackageSize() {
        return this.m_packageSize;
    }

    public int getProcessID() {
        return this.m_processID;
    }

    public long getProgress() {
        return this.m_progress;
    }

    public int getRestartCount() {
        return this.m_restartCount;
    }

    public String getStartTime() {
        return this.m_startTime;
    }

    public String getState() {
        return this.m_state;
    }

    private String getStateFilePath() {
        return UploadState.getStateFilePath(this.m_serviceRequest, this.m_packageName);
    }

    public static String getStateFilePath(String string, String string2) {
        File file = new File(string2);
        return FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_DIAGNOSTIC_PATH, string, String.valueOf(file.getName()) + ".xml"});
    }

    public String getSubmitTime() {
        return this.m_submitTime;
    }

    public String getUpdateTime() {
        return this.m_updateTime;
    }

    private void load() throws InvalidStateException, StateAccessException, NoSuchReqException {
        File file = new File(this.getStateFilePath());
        this.load(file);
    }

    private void load(File file) throws InvalidStateException, StateAccessException, NoSuchReqException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(UploadState.prefixMsg("Loading upload state.", file.getAbsolutePath()));
        }
        UploadStateHandler uploadStateHandler = new UploadStateHandler(file);
        this.m_startTime = uploadStateHandler.getStartTime();
        this.m_submitTime = uploadStateHandler.getSubmitTime();
        this.m_updateTime = uploadStateHandler.getUpdateTime();
        this.m_packageName = uploadStateHandler.getPackageName();
        this.m_packageSize = uploadStateHandler.getPackageSize();
        this.m_packageDigest = uploadStateHandler.getPackageDigest();
        this.m_state = uploadStateHandler.getState();
        this.m_progress = uploadStateHandler.getProgress();
        this.m_processID = uploadStateHandler.getProcessID();
        this.m_restartCount = uploadStateHandler.getRestartCount();
        this.m_endTime = uploadStateHandler.getEndTime();
    }

    public static String prefixMsg(String string, String string2) {
        String string3 = "[STATE: " + string2 + "] - ";
        return String.valueOf(string3) + string;
    }

    private void setupStateDir() throws StateCreationException {
        File file = new File(this.getStateFilePath());
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(UploadState.prefixMsg("Creating directory structure for upload state.", file.getAbsolutePath()));
            }
            if (!file2.mkdirs()) {
                String string = s_msgBundle.getMessage(UploaderMsgID.STATE_CREATION_ERROR, false);
                throw new StateCreationException(UploadState.prefixMsg(string, file.getAbsolutePath()));
            }
        }
    }

    public void update(String string, long l) throws StateCreationException, StateAccessException {
        this.m_state = string;
        this.m_progress = l;
        if (this.m_state.equals("COMPLETED")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
            this.m_endTime = simpleDateFormat.format(new Date());
        }
        this.writeUploadState();
    }

    private void writeUploadState() throws StateCreationException, StateAccessException {
        try {
            this.setupStateDir();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
            Date date = new Date();
            this.m_updateTime = simpleDateFormat.format(date);
            FileOutputStream fileOutputStream = new FileOutputStream(this.getStateFilePath());
            if (this.m_uploadStateXML == null) {
                this.m_uploadStateXML = new StringBuffer();
            }
            this.m_uploadStateXML.delete(0, this.m_uploadStateXML.length());
            this.m_uploadStateXML.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n<!DOCTYPE DiagnosticUpload SYSTEM \"" + this.getDTDPath() + "\">" + "<DiagnosticUpload SUBMITTIME=\"" + this.m_submitTime + "\" STARTTIME=\"" + this.m_startTime + "\" UPDATETIME=\"" + this.m_updateTime + "\"");
            if (this.m_endTime != null) {
                this.m_uploadStateXML.append(" ENDTIME=\"" + this.m_endTime + "\"");
            }
            this.m_uploadStateXML.append(">  <Package NAME=\"" + this.m_packageName + "\" SIZE=\"" + this.m_packageSize + "\" DIGEST=\"" + this.m_packageDigest + "\"/>" + "  <Upload STATE=\"" + this.m_state + "\" PROGRESS=\"" + this.m_progress + "\"/>" + "  <Process ID=\"" + this.m_processID + "\"/>" + "  <Restart COUNT=\"" + this.m_restartCount + "\"/>" + "</DiagnosticUpload>");
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(UploadState.prefixMsg("Writing upload state.", this.getStateFilePath()));
                s_logger.debug(this.m_uploadStateXML.toString());
            }
            fileOutputStream.write(this.m_uploadStateXML.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = s_msgCommonBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{fileNotFoundException.getMessage()});
            throw new StateAccessException(UploadState.prefixMsg(string, this.getStateFilePath()));
        }
        catch (IOException iOException) {
            String string = s_msgCommonBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{iOException.getMessage()});
            throw new StateAccessException(UploadState.prefixMsg(string, this.getStateFilePath()));
        }
    }
}

