/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.diagnostic.uploader;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.File;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.InvalidSessionException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.UploadReqExistsException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.DiagnosticStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.diagnostic.uploader.DiagPackage;
import oracle.sysman.ccr.diagnostic.uploader.UploadRequest;
import oracle.sysman.ccr.diagnostic.uploader.UploadResponse;
import oracle.sysman.ccr.diagnostic.uploader.UploadState;
import oracle.sysman.ccr.diagnostic.uploader.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.uploader.ValidationRequest;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.ServerAccessException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;
import oracle.sysman.ccr.netmgr.UploadConnection;

public class Uploader {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$diagnostic$uploader$Uploader != null ? class$oracle$sysman$ccr$diagnostic$uploader$Uploader : (class$oracle$sysman$ccr$diagnostic$uploader$Uploader = Uploader.class$("oracle.sysman.ccr.diagnostic.uploader.Uploader")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.uploader.Uploader");
    private String m_SRNumber = null;
    private DiagPackage m_diagPkg = null;
    private UploadState m_uploadState = null;
    private UploadConnection m_diagCon = null;
    private long m_progress = -1L;
    private String m_state = null;
    private int m_sessionTimeout = -1;
    private String m_sessionID = null;
    private int m_chunkSize = -1;
    private UploadRequest m_request = null;
    private UploadResponse m_response = null;
    private boolean restart = false;
    private ValidationRequest m_valRequest = null;
    private String m_oracleHome = null;
    private String m_cfgHome = null;
    private String m_hostName = null;
    private static final String START_UPLOAD_URI = "/emdiag/upload";
    private static final String RESTART_UPLOAD_URI = "/emdiag/restartUpload";
    private static final String CONTINUE_UPLOAD_URI = "/emdiag/continuation";
    static /* synthetic */ Class class$oracle$sysman$ccr$diagnostic$uploader$Uploader;

    public Uploader(String string, String string2) throws InvalidPackageException, PackageNotFoundException, PackageAccessException, InternalException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Initializing upload.", string, string2));
        }
        System.out.println(s_msgBundle.getMessage(UploaderMsgID.INIT_UPLOAD, false));
        this.m_SRNumber = string;
        this.m_diagPkg = new DiagPackage(string2);
        this.m_sessionTimeout = 150;
        this.m_chunkSize = 524288;
    }

    private void adjustSessionTimeout() throws SessionTimeoutLimitException {
        if (this.m_sessionTimeout >= 600) {
            String string = s_msgBundle.getMessage(UploaderMsgID.SESSION_TIMEOUT_LIMIT_ERR, false, new Object[]{Integer.toString(600)});
            throw new SessionTimeoutLimitException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_diagPkg.getName()));
        }
        this.m_sessionTimeout = (int)((double)this.m_sessionTimeout * 1.1);
        if (this.m_sessionTimeout > 600) {
            this.m_sessionTimeout = 600;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void cleanup() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Cleaning up...", this.m_SRNumber, this.m_diagPkg.getName()));
        }
        if (this.m_diagPkg != null) {
            this.m_diagPkg.close();
        }
    }

    private void connect() throws InvalidEndPointException, NetworkException, ServerAccessException, KeyMismatchException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Retrieving connection parameters for diagnostic upload.", this.m_SRNumber, this.m_diagPkg.getName()));
        }
        URI uRI = null;
        boolean bl = false;
        EndPointAddr endPointAddr = this.getEndpoint();
        if (endPointAddr != null) {
            uRI = endPointAddr.getURI();
            bl = endPointAddr.getIsRepeater();
        }
        this.m_oracleHome = Collector.getOracleHome();
        this.m_cfgHome = Collector.getConfigHome();
        this.m_hostName = Hostname.getHostname();
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Establishing connection to diagnostic receiver: " + uRI.toExternalForm(), this.m_SRNumber, this.m_diagPkg.getName()));
            s_logger.debug(DiagnosticCmd.prefixMsg("host name: " + this.m_hostName + ", oracle home: " + this.m_oracleHome + ", org id: " + securityMgr.getCustomerOrgId() + ", registration key: " + securityMgr.getAuthenticationKeyString(), this.m_SRNumber, this.m_diagPkg.getName()));
        }
        this.m_diagCon = new UploadConnection(uRI, this.m_hostName, this.m_oracleHome, this.m_cfgHome, securityMgr.getCustomerOrgId(), securityMgr.getAuthenticationKeyString(), this.m_SRNumber, this.m_diagPkg.getName(), this.m_diagPkg.getSize(), this.m_diagPkg.getDigest(), bl);
    }

    private EndPointAddr getEndpoint() throws InvalidEndPointException {
        EndPointAddr endPointAddr = null;
        EndPointAddr endPointAddr2 = null;
        URI uRI = null;
        try {
            endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            if (endPointAddr == null) {
                String string = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_ENDPOINT_ERROR, false);
                throw new InvalidEndPointException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            URI uRI2 = endPointAddr.getURI();
            String string = START_UPLOAD_URI;
            if (this.restart) {
                string = RESTART_UPLOAD_URI;
            }
            uRI = new URI(uRI2.getScheme(), uRI2.getHost(), uRI2.getPort(), string);
            endPointAddr2 = new EndPointAddr(null, endPointAddr.getIsRepeater(), uRI);
        }
        catch (ParseException parseException) {
            String string = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_ENDPOINT_ERROR, false);
            throw new InvalidEndPointException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_diagPkg.getName()));
        }
        return endPointAddr2;
    }

    private void handleFailureResponse(boolean bl) throws StateCreationException, StateAccessException, InvalidStateException, InvalidRequestException, PackageModifiedException, ServerException, KeyMismatchException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, DuplicateUploadException, AlreadyUploadedException, InvalidCredentialsException, SRClosedException, CSIMismatchException {
        int n = this.m_response.getFailureCode();
        String string = this.m_response.getFailureMsg();
        if (!bl) {
            this.m_state = "FAILED";
            this.m_uploadState.update(this.m_state, this.m_progress);
        }
        switch (n) {
            case 7: {
                String string2 = s_msgBundle.getMessage(UploaderMsgID.INVALID_UPLOAD_STATE, false);
                throw new InvalidStateException(DiagnosticCmd.prefixMsg(string2, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 8: {
                String string3 = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_MODIFIED_ERR, false, new Object[]{this.m_diagPkg.getName()});
                throw new PackageModifiedException(DiagnosticCmd.prefixMsg(string3, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 14: {
                String string4 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new ServerException(DiagnosticCmd.prefixMsg(string4, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 4: {
                String string5 = s_msgBundle.getMessage(UploaderMsgID.INVALID_REG_KEY, false);
                throw new KeyMismatchException(DiagnosticCmd.prefixMsg(string5, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 17: {
                String string6 = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_UPLOAD_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new InvalidRequestException(DiagnosticCmd.prefixMsg(string6, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 9: {
                String string7 = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_UPLOAD_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new InvalidSessionException(DiagnosticCmd.prefixMsg(string7, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 2: {
                String string8 = s_msgBundle.getMessage(UploaderMsgID.CSI_MISMATCH, false, new Object[]{this.m_SRNumber});
                throw new CSIMismatchException(DiagnosticCmd.prefixMsg(string8, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 18: {
                String string9 = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_UPLOAD_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new MessageFormatException(DiagnosticCmd.prefixMsg(string9, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 3: {
                String string10 = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ_RESTART, false);
                throw new NoSuchReqException(DiagnosticCmd.prefixMsg(string10, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 1: {
                String string11 = s_msgBundle.getMessage(UploaderMsgID.NOT_SUPPORTED, false, new Object[]{string});
                throw new NotSupportedException(string11);
            }
            case 10: {
                String string12 = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_MODIFIED_ERR, false);
                throw new PackageModifiedException(DiagnosticCmd.prefixMsg(string12, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 15: {
                String string13 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new ServerException(DiagnosticCmd.prefixMsg(string13, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 5: {
                String string14 = s_msgBundle.getMessage(UploaderMsgID.DUPLICATE_UPLOAD_REQ_SERVER, false, new Object[]{string});
                throw new DuplicateUploadException(DiagnosticCmd.prefixMsg(string14, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 16: {
                String string15 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new ServerException(DiagnosticCmd.prefixMsg(string15, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 21: {
                this.m_state = "COMPLETED";
                this.m_uploadState.update(this.m_state, this.m_progress);
                String string16 = s_msgBundle.getMessage(UploaderMsgID.ALREADY_UPLOADED, false);
                throw new AlreadyUploadedException(DiagnosticCmd.prefixMsg(string16, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 22: {
                String string17 = s_msgBundle.getMessage(UploaderMsgID.INVALID_ML_CREDS, false);
                throw new InvalidCredentialsException(DiagnosticCmd.prefixMsg(string17, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 24: {
                String string18 = s_msgBundle.getMessage(UploaderMsgID.SR_CLOSED, false, new Object[]{this.m_SRNumber});
                throw new SRClosedException(DiagnosticCmd.prefixMsg(string18, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            case 23: {
                String string19 = s_msgBundle.getMessage(UploaderMsgID.SR_NOT_FOUND, false, new Object[]{this.m_SRNumber});
                throw new InvalidSRException(DiagnosticCmd.prefixMsg(string19, this.m_SRNumber, this.m_diagPkg.getName()));
            }
        }
        String string20 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
        throw new ServerException(DiagnosticCmd.prefixMsg(string20, this.m_SRNumber, this.m_diagPkg.getName()));
    }

    private void preProcessRestartRequest() throws InvalidStateException, StateAccessException, NoSuchReqException, PackageModifiedException, AlreadyUploadedException {
        try {
            this.m_uploadState = new UploadState(this.m_SRNumber, this.m_diagPkg.getName());
        }
        catch (NoSuchReqException noSuchReqException) {
            String string = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ_RESTART, false);
            Throwable throwable = noSuchReqException.getCause();
            throw new NoSuchReqException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_diagPkg.getName()), throwable);
        }
        if (!this.m_diagPkg.getDigest().equalsIgnoreCase(this.m_uploadState.getPackageDigest())) {
            String string = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_MODIFIED_ERR, false);
            throw new PackageModifiedException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_diagPkg.getName()));
        }
        if ("COMPLETED".equals(this.m_uploadState.getState())) {
            String string = s_msgBundle.getMessage(UploaderMsgID.ALREADY_UPLOADED, false);
            throw new AlreadyUploadedException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_diagPkg.getName()));
        }
        this.m_progress = this.m_uploadState.getProgress();
    }

    private void preProcessStartRequest() throws UploadReqExistsException {
        UploadState uploadState = null;
        File file = null;
        try {
            file = new File(UploadState.getStateFilePath(this.m_SRNumber, this.m_diagPkg.getName()));
            uploadState = new UploadState(file);
        }
        catch (DiagnosticStateException diagnosticStateException) {
            return;
        }
        catch (NoSuchReqException noSuchReqException) {
            return;
        }
        if ("COMPLETED".equals(uploadState.getState())) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(DiagnosticCmd.prefixMsg("Old upload request is in COMPLETED state. Overwriting...", this.m_SRNumber, this.m_diagPkg.getName()));
            }
        } else if (!Collector.qualifierSpecified("force")) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(DiagnosticCmd.prefixMsg("Old upload request is not in COMPLETED state and not forced. Exiting...", this.m_SRNumber, this.m_diagPkg.getName()));
            }
            String string = s_msgBundle.getMessage(UploaderMsgID.UPLOAD_REQUEST_EXISTS, false);
            throw new UploadReqExistsException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_diagPkg.getName()));
        }
    }

    public void restart() throws DuplicateUploadException, InvalidStateException, StateAccessException, NoSuchReqException, PackageModifiedException, AlreadyUploadedException, InvalidEndPointException, NetworkException, ServerAccessException, KeyMismatchException, StateCreationException, PackageAccessException, InvalidResponseException, SessionTimeoutLimitException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException {
        this.restart = true;
        System.out.println(s_msgBundle.getMessage(UploaderMsgID.RESTARTING_UPLOAD, false));
        this.preProcessRestartRequest();
        this.upload();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sendValidationRequest(String string) throws CredentialsNotFoundException, InvalidCredentialsException, NetworkException, ServerAccessException, InvalidResponseException, StateCreationException, StateAccessException, NotSupportedException {
        boolean bl;
        try {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(DiagnosticCmd.prefixMsg("Sending validation request to uri path " + string, this.m_SRNumber, this.m_diagPkg.getName()));
            }
            this.m_response = null;
            this.m_response = this.m_diagCon.send(string, this.m_valRequest, this.m_sessionID);
            if (this.m_response != null && this.m_response.isSuccessful()) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug(DiagnosticCmd.prefixMsg("Validation performed sucessfully.", this.m_SRNumber, this.m_diagPkg.getName()));
                }
                this.m_sessionID = this.m_response.getSessionID();
                boolean bl2 = true;
                Object var4_4 = null;
                if (this.m_valRequest == null) return bl2;
                this.m_valRequest.close();
                return bl2;
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(DiagnosticCmd.prefixMsg("Validation unsuccessful. Server failure code: " + this.m_response.getFailureCode() + ", message: " + this.m_response.getFailureMsg(), this.m_SRNumber, this.m_diagPkg.getName()));
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (this.m_valRequest == null) throw throwable;
            this.m_valRequest.close();
            throw throwable;
        }
        Object var4_5 = null;
        if (this.m_valRequest == null) return bl;
        this.m_valRequest.close();
        return bl;
    }

    public void start(ValidationRequest validationRequest) throws StateCreationException, StateAccessException, UploadReqExistsException, DuplicateUploadException, InvalidEndPointException, NetworkException, KeyMismatchException, AlreadyUploadedException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException {
        this.restart = false;
        System.out.println(s_msgBundle.getMessage(UploaderMsgID.STARTING_UPLOAD, false));
        this.m_uploadState = new UploadState(this.m_SRNumber, this.m_diagPkg.getName(), this.m_diagPkg.getSize(), this.m_diagPkg.getDigest());
        this.m_progress = 0L;
        this.m_valRequest = validationRequest;
        this.preProcessStartRequest();
        this.upload();
    }

    private void upload() throws InvalidEndPointException, NetworkException, ServerAccessException, KeyMismatchException, StateCreationException, StateAccessException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, DuplicateUploadException, AlreadyUploadedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException {
        String string = null;
        int n = 0;
        byte[] byArray = null;
        System.out.println(s_msgBundle.getMessage(UploaderMsgID.CONNECTING, false));
        try {
            this.connect();
        }
        finally {
            Object var5_4 = null;
            if (this.restart) {
                this.m_state = "FAILED";
                this.m_uploadState.update(this.m_state, this.m_progress);
            }
        }
        System.out.println(s_msgBundle.getMessage(UploaderMsgID.UPLOADING, false));
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Allocating " + this.m_chunkSize + " bytes memory for chunk buffer", this.m_SRNumber, this.m_diagPkg.getName()));
        }
        byArray = new byte[this.m_chunkSize];
        this.m_request = new UploadRequest();
        if (this.restart) {
            string = RESTART_UPLOAD_URI;
            n = this.m_diagPkg.readChunk(this.m_progress, byArray);
        } else {
            string = START_UPLOAD_URI;
            if (!this.sendValidationRequest(string)) {
                this.handleFailureResponse(true);
            } else {
                string = CONTINUE_UPLOAD_URI;
                n = this.m_diagPkg.readChunk(byArray);
            }
        }
        this.m_state = "STARTED";
        while (!this.m_state.equalsIgnoreCase("COMPLETED")) {
            if (!this.uploadChunk(string, byArray, n)) {
                if (this.m_response.getFailureCode() == 6) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug(DiagnosticCmd.prefixMsg("Session timed out at server.", this.m_SRNumber, this.m_diagPkg.getName()));
                    }
                    s_logger.error(UploaderMsgID.SESSION_TIMEOUT_ERR);
                    this.adjustSessionTimeout();
                    string = RESTART_UPLOAD_URI;
                    this.m_sessionID = null;
                    continue;
                }
                if (string.equals(START_UPLOAD_URI)) {
                    this.handleFailureResponse(true);
                    continue;
                }
                this.handleFailureResponse(false);
                continue;
            }
            string = CONTINUE_UPLOAD_URI;
            n = this.m_diagPkg.readChunk(byArray);
        }
        this.cleanup();
        System.out.println(s_msgBundle.getMessage(UploaderMsgID.UPLOAD_COMPLETED, false));
    }

    private boolean uploadChunk(String string, byte[] byArray, int n) throws NetworkException, ServerAccessException, InvalidResponseException, StateCreationException, StateAccessException {
        if (n <= 0) {
            n = 0;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Preparing upload request for chunk of " + n + " bytes, offset is " + this.m_progress + " bytes, session timeout is " + this.m_sessionTimeout + " seconds.", this.m_SRNumber, this.m_diagPkg.getName()));
        }
        this.m_request.prepareUploadRequest(byArray, n, this.m_progress, this.m_sessionTimeout);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Uploading chunk to uri path " + string + " with session ID: " + this.m_sessionID, this.m_SRNumber, this.m_diagPkg.getName()));
        }
        try {
            this.m_response = null;
            this.m_response = this.m_diagCon.send(string, this.m_request, this.m_sessionID);
        }
        finally {
            Object var5_4 = null;
            if (this.m_response == null && !START_UPLOAD_URI.equals(string)) {
                this.m_state = "FAILED";
                this.m_uploadState.update(this.m_state, this.m_progress);
            }
        }
        if (this.m_response != null && this.m_response.isSuccessful()) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(DiagnosticCmd.prefixMsg("Chunk uploaded sucessfully.", this.m_SRNumber, this.m_diagPkg.getName()));
            }
            this.m_sessionID = this.m_response.getSessionID();
            if (this.m_sessionID.equals("0") && n == 0) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug(DiagnosticCmd.prefixMsg("Diagnostic package uploaded sucessfully.", this.m_SRNumber, this.m_diagPkg.getName()));
                }
                this.m_state = "COMPLETED";
            } else {
                this.m_state = "STARTED";
            }
            this.m_progress += (long)n;
            this.m_uploadState.update(this.m_state, this.m_progress);
            return true;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Upload unsuccessful. Server failure code: " + this.m_response.getFailureCode() + ", message: " + this.m_response.getFailureMsg(), this.m_SRNumber, this.m_diagPkg.getName()));
        }
        return false;
    }
}

