/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.diagnostic.uploader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.uploader.Request;
import oracle.sysman.ccr.diagnostic.uploader.UploaderMsgID;
import oracle.sysman.ccr.util.SecurePrompter;
import oracle.sysman.ccr.util.Utils;

public class ValidationRequest
extends Request {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$diagnostic$uploader$ValidationRequest != null ? class$oracle$sysman$ccr$diagnostic$uploader$ValidationRequest : (class$oracle$sysman$ccr$diagnostic$uploader$ValidationRequest = ValidationRequest.class$("oracle.sysman.ccr.diagnostic.uploader.ValidationRequest")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.uploader.Uploader");
    private PrintStream Stdout = new PrintStream(System.out, true);
    private StringBuffer m_xmlRequestBuffer = new StringBuffer(1024);
    private static final String DEFAULT_VERSION = "1.0";
    static /* synthetic */ Class class$oracle$sysman$ccr$diagnostic$uploader$ValidationRequest;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        this.m_xmlRequestBuffer.delete(0, this.m_xmlRequestBuffer.length());
        this.m_xmlRequestBuffer = null;
    }

    public void prepareValidationRequest(String string) throws CredentialsNotFoundException, InvalidCredentialsException, NotSupportedException {
        Properties properties = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        char[] cArray = null;
        String string6 = null;
        this.m_xmlRequestBuffer.delete(0, this.m_xmlRequestBuffer.length());
        if (Collector.qualifierSpecified("nointeractive")) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("nointeractive qualifier specified. Loading CRD file.");
            }
            if ((string2 = (properties = Utils.getCredInfo(DiagnosticCmd.getCRDFilePath(string))).getProperty("CRD_VERSION")) == null) {
                string2 = DEFAULT_VERSION;
            }
            string3 = properties.getProperty("METALINK_USER");
            string5 = properties.getProperty("METALINK_PSWD");
            string6 = properties.getProperty("CRYPT_SEED");
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Credentials information loaded.");
                s_logger.debug("user name: " + string3 + ", encrypted passwd: " + string5 + ", encryption key: " + string6 + ", version: " + string2);
            }
            if (string3 == null || string5 == null || string6 == null) {
                throw new InvalidCredentialsException("Invalid credentials information.");
            }
            try {
                string4 = new String(Utils.decryptValue(string3, string6));
                cArray = Utils.decryptValue(string5, string6);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidCredentialsException("Error occurred while de-obfuscating credentials information. Please make sure the obfuscated information is correctly provided.");
            }
        }
        string2 = DEFAULT_VERSION;
        try {
            this.Stdout.println();
            string4 = this.promptForInput(s_msgBundle.getMessage(UploaderMsgID.ML_USERNAME_PROMPT, false));
            cArray = SecurePrompter.readResponse(s_msgBundle.getMessage(UploaderMsgID.ML_PASSWORD_PROMPT, false));
        }
        catch (IOException iOException) {
            throw new CredentialsNotFoundException("Could not obtain credentials information.", iOException);
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Credentials information obtained and validated. Preparing validation request XML.");
        }
        this.m_xmlRequestBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?><ML_CRD VERSION=\"" + string2 + "\">");
        this.m_xmlRequestBuffer.append("<METALINK_USER>");
        this.m_xmlRequestBuffer.append("<![CDATA[" + string4 + "]]>");
        this.m_xmlRequestBuffer.append("</METALINK_USER>");
        this.m_xmlRequestBuffer.append("<METALINK_PSWD>");
        this.m_xmlRequestBuffer.append("<![CDATA[" + new String(cArray) + "]]>");
        this.m_xmlRequestBuffer.append("</METALINK_PSWD>");
        this.m_xmlRequestBuffer.append("</ML_CRD>");
    }

    String promptForInput(String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.Stdout.print(string);
        this.Stdout.flush();
        return bufferedReader.readLine().trim();
    }

    public String toString() {
        return this.m_xmlRequestBuffer.toString();
    }
}

