/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.impl;

import HTTPClient.AuthorizationInfo;
import HTTPClient.HTTPConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.impl.ImplMsgID;
import oracle.sysman.ccr.impl.InvalValueException;
import oracle.sysman.ccr.impl.PageImpl;

public class ConnectionPageImpl
extends PageImpl {
    private MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.impl.Impl");
    private boolean m_useProxy = false;
    private String m_proxyServer = "";
    private int m_proxyPort = 0;
    private boolean m_useCredentials = false;
    private String m_proxyUser = "";
    private String m_proxyPasswd = "";
    private static final int INVAL_PORT = -1;

    public ConnectionPageImpl() {
        this.loadCCRProperties();
    }

    public void applyChanges() {
        if (this.m_useProxy) {
            PageImpl.systemConfigWriter.setProperty("http.proxyHost", this.m_proxyServer);
            PageImpl.systemConfigWriter.setProperty("http.proxyPort", Integer.toString(this.m_proxyPort));
            if (this.m_useCredentials) {
                PageImpl.systemConfigWriter.setProperty("http.proxyUser", this.m_proxyUser);
                PageImpl.systemConfigWriter.setProperty("http.proxyPassword", this.m_proxyPasswd);
            } else {
                PageImpl.systemConfigWriter.removeProperty("http.proxyUser");
                PageImpl.systemConfigWriter.removeProperty("http.proxyPassword");
            }
        } else {
            PageImpl.systemConfigWriter.removeProperty("http.proxyHost");
            PageImpl.systemConfigWriter.removeProperty("http.proxyPort");
            PageImpl.systemConfigWriter.removeProperty("http.proxyUser");
            PageImpl.systemConfigWriter.removeProperty("http.proxyPassword");
        }
        this.updateHTTPConnectionProxy();
    }

    public String getProxyPort() {
        if (this.m_proxyPort == -1) {
            return "";
        }
        return Integer.toString(this.m_proxyPort);
    }

    public String getProxyServer() {
        return this.m_proxyServer;
    }

    public String getProxyUser() {
        return this.m_proxyUser;
    }

    public boolean getUseCredentials() {
        return this.m_useCredentials;
    }

    public boolean getUseProxy() {
        return this.m_useProxy;
    }

    private void loadCCRProperties() {
        Config config = UplinkSystemConfig.getInstance();
        this.m_proxyServer = config.getProperty("http.proxyHost", "");
        this.m_proxyPort = config.getProperty("http.proxyPort", -1);
        this.m_proxyUser = config.getProperty("http.proxyUser", "");
        this.m_proxyPasswd = config.getProperty("http.proxyPassword", "");
        if (this.m_proxyServer.length() != 0) {
            this.m_useProxy = true;
            if (this.m_proxyUser.length() != 0) {
                this.m_useCredentials = true;
            }
        }
    }

    public void setProxyPasswd(String string) throws InvalValueException {
        if ((string = string.trim()).length() == 0) {
            throw new InvalValueException(this.s_bundle.getMessage(ImplMsgID.PROXY_PSWD_ERR, false));
        }
        this.m_proxyPasswd = string;
    }

    public void setProxyPort(String string) throws InvalValueException {
        int n = 0;
        string = string.trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalValueException(this.s_bundle.getMessage(ImplMsgID.PROXY_PORT_ERR, false));
        }
        if (n < 0) {
            throw new InvalValueException(this.s_bundle.getMessage(ImplMsgID.PROXY_PORT_NGTV_ERR, false));
        }
        this.m_proxyPort = n;
    }

    public void setProxyServer(String string) throws InvalValueException {
        if ((string = string.trim()).length() == 0) {
            throw new InvalValueException(this.s_bundle.getMessage(ImplMsgID.PROXY_SERVER_ERR, false));
        }
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalValueException(this.s_bundle.getMessage(ImplMsgID.RESOLVE_PROXY_ADDR_ERR, false, (Object[])new String[]{string}));
        }
        this.m_proxyServer = string;
    }

    public void setProxyUser(String string) throws InvalValueException {
        if ((string = string.trim()).length() == 0) {
            throw new InvalValueException(this.s_bundle.getMessage(ImplMsgID.PROXY_USER_ERR, false));
        }
        this.m_proxyUser = string;
    }

    public void setUseCredentials(boolean bl) {
        this.m_useCredentials = bl;
    }

    public void setUseProxy(boolean bl) {
        this.m_useProxy = bl;
    }

    private void updateHTTPConnectionProxy() {
        if (this.m_useProxy) {
            HTTPConnection.setProxyServer(this.m_proxyServer, this.m_proxyPort);
            AuthorizationInfo.removeAuthorization(HTTPConnection.getDefaultContext());
        } else {
            HTTPConnection.setProxyServer(null, 0);
        }
    }
}

