/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.impl;

import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.RegisterCmd;
import oracle.sysman.ccr.collector.countryCodes.CountryCode;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeException;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeMap;
import oracle.sysman.ccr.collector.countryCodes.NoSuchCountryCodeException;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.impl.ImplMsgID;
import oracle.sysman.ccr.impl.InvalValueException;
import oracle.sysman.ccr.impl.PageImpl;

public class GeneralPageImpl
extends PageImpl {
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.impl.Impl");
    private String m_csi = null;
    private String m_countryCode = null;
    private String m_metalinkID = null;
    private boolean m_autoSoftwareUpdate = true;
    private String m_origCsi = null;
    private String m_origCountryCode = null;
    private String m_origMetalinkID = null;
    private CountryCodeMap m_ccMap = CountryCodeMap.getInstance();

    public GeneralPageImpl() throws CountryCodeException {
        this.loadCCRProperties();
        this.loadCollectorProperties();
    }

    public void applyChanges() throws CommandException {
        this.updateRegistrationInfo();
        this.updateCollectorProperties();
    }

    public boolean getAutoSoftwareUpdate() {
        return this.m_autoSoftwareUpdate;
    }

    public String getCSI() {
        return this.m_csi;
    }

    public String getCountryName() {
        try {
            CountryCode countryCode = this.m_ccMap.getCountryCode(this.m_countryCode);
            return countryCode.getLongName();
        }
        catch (NoSuchCountryCodeException noSuchCountryCodeException) {
            return "";
        }
    }

    public String[] getCountryNames() {
        CountryCode[] countryCodeArray = this.m_ccMap.getCountryCodesList();
        String[] stringArray = new String[countryCodeArray.length];
        int n = 0;
        while (n < countryCodeArray.length) {
            stringArray[n] = countryCodeArray[n].getLongName();
            ++n;
        }
        return stringArray;
    }

    public String getMetalinkID() {
        return this.m_metalinkID;
    }

    private void loadCCRProperties() {
        Config config = UplinkSystemConfig.getInstance();
        this.m_csi = config.getProperty("ccr.support_id", "");
        this.m_countryCode = config.getProperty("ccr.country_code", "");
        this.m_metalinkID = config.getProperty("ccr.metalink_id", "");
        this.m_origCsi = this.m_csi;
        this.m_origCountryCode = this.m_countryCode;
        this.m_origMetalinkID = this.m_metalinkID;
    }

    private void loadCollectorProperties() {
        String string = "false";
        Config config = UplinkHomeConfig.getInstance();
        String string2 = config.getProperty("ccr.autoupdate", "");
        if (string2.equalsIgnoreCase("false")) {
            this.m_autoSoftwareUpdate = false;
        }
    }

    public void setAutoSoftwareUpdate(boolean bl) {
        this.m_autoSoftwareUpdate = bl;
    }

    public void setCSI(String string) throws InvalValueException {
        int n = (string = string.trim()).length();
        if (n == 0) {
            throw new InvalValueException(s_bundle.getMessage(ImplMsgID.CSI_ERR, false));
        }
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isDigit(string.charAt(n2))) {
                throw new InvalValueException(s_bundle.getMessage(ImplMsgID.CSI_ERR, false));
            }
            ++n2;
        }
        this.m_csi = string;
    }

    public void setCountryName(String string) throws InvalValueException {
        CountryCode[] countryCodeArray = this.m_ccMap.getCountryCodesList();
        boolean bl = false;
        int n = 0;
        while (n < countryCodeArray.length) {
            if (string.equalsIgnoreCase(countryCodeArray[n].getLongName())) {
                this.m_countryCode = countryCodeArray[n].getShortName();
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new InvalValueException(s_bundle.getMessage(ImplMsgID.COUNTRY_NAME_ERR, false, (Object[])new String[]{string}));
        }
    }

    public void setMetalinkID(String string) throws InvalValueException {
        if ((string = string.trim()).length() == 0) {
            throw new InvalValueException(s_bundle.getMessage(ImplMsgID.METALINK_ERR, false));
        }
        this.m_metalinkID = string;
    }

    private void updateCollectorProperties() {
        PageImpl.homeConfigWriter.setProperty("ccr.autoupdate", String.valueOf(this.m_autoSoftwareUpdate));
    }

    private void updateRegistrationInfo() throws CommandException {
        Config config = UplinkSystemConfig.getInstance();
        PageImpl.systemConfigWriter.setProperty("ccr.support_id", this.m_csi);
        PageImpl.systemConfigWriter.setProperty("ccr.country_code", this.m_countryCode);
        PageImpl.systemConfigWriter.setProperty("ccr.metalink_id", this.m_metalinkID);
        if (!(this.m_csi.equalsIgnoreCase(this.m_origCsi) && this.m_countryCode.equalsIgnoreCase(this.m_origCountryCode) && this.m_metalinkID.equalsIgnoreCase(this.m_origMetalinkID))) {
            new RegisterCmd().processRequest();
        }
    }
}

