/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.impl;

import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkHomeConfigWriter;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;

public abstract class PageImpl {
    protected static ConfigWriter homeConfigWriter = null;
    protected static ConfigWriter systemConfigWriter = null;

    public abstract void applyChanges() throws CommandException;

    public static StringBuffer getErrorStr(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        while (throwable != null) {
            String string2 = throwable.getMessage();
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
            if (throwable instanceof CCRException) {
                CCRException cCRException = (CCRException)throwable;
                throwable = cCRException.getCause();
                continue;
            }
            throwable = null;
        }
        return stringBuffer;
    }

    public static void initialize() throws FileReadException, FileWriteException {
        Logger.init(UplinkHomeConfig.getInstance().getProperties());
        homeConfigWriter = UplinkHomeConfigWriter.getInstance();
        systemConfigWriter = UplinkSystemConfigWriter.getInstance();
    }

    public void save() throws FileWriteException {
        homeConfigWriter.persistProperties();
        systemConfigWriter.persistProperties();
    }
}

