/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.impl.ImplMsgID;
import oracle.sysman.ccr.impl.SchedFrequency;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class SchedImpl
implements SchedFrequency {
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.impl.Impl");
    private static final String FREQ = "FREQ";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String STATE = "STATE";
    private static final String NMZCTL = "emCCR";
    private static final String _GET = "_get";
    private static final String _SET = "_set";
    private static final String COLLECTION_INTERVAL = "collection_interval";
    private static final String HOLD = "hold";
    private static final String _HOLD = "_hold";
    private static final String _RESUME = "_resume";
    private static final String WINDOWS = "Windows";
    private static final String BAT_EXT = ".bat";
    private Properties m_prop = new Properties();
    private boolean m_dirty = false;
    private String m_nmzctl = "";

    public SchedImpl() throws CommandException {
        this.createControlUtilPath();
        this.loadSchedProperties();
    }

    public void applyChanges() throws CommandException {
        if (this.m_dirty) {
            boolean bl = this.getAutoUpload();
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            String string = _HOLD;
            if (bl) {
                string = _RESUME;
            }
            if ((n = SchedImpl.runProcess(new String[]{this.m_nmzctl, string}, null, stringBuffer)) == 0 && bl) {
                n = this.setCollectionInterval(stringBuffer);
            }
            if (n != 0) {
                throw new CommandException(String.valueOf(s_bundle.getMessage(ImplMsgID.UPDATE_ERR, false)) + "\n" + stringBuffer);
            }
        }
    }

    private void createControlUtilPath() {
        File file;
        String string;
        String string2 = System.getProperty("ORACLE_HOME");
        if (string2 != null) {
            string2 = string2.trim();
            this.m_nmzctl = FileSpec.catfile(new String[]{string2, UplinkPath.BIN_PATH, NMZCTL});
        }
        if ((string = System.getProperty("os.name")).startsWith(WINDOWS)) {
            this.m_nmzctl = String.valueOf(this.m_nmzctl) + BAT_EXT;
        }
        if (!(file = new File(this.m_nmzctl)).exists()) {
            throw new RuntimeException(s_bundle.getMessage(ImplMsgID.BIN_MISSING_ERR, false, (Object[])new String[]{file.getPath()}));
        }
    }

    public boolean getAutoUpload() {
        return Boolean.valueOf(this.m_prop.getProperty(STATE));
    }

    public int getFrequency() {
        return Integer.parseInt(this.m_prop.getProperty(FREQ));
    }

    public int getHour() {
        return Integer.parseInt(this.m_prop.getProperty(BYHOUR));
    }

    public int getMinute() {
        return Integer.parseInt(this.m_prop.getProperty(BYMINUTE));
    }

    public String getMonthDay() {
        return this.m_prop.getProperty(BYMONTHDAY, null);
    }

    public String getWeekDay() {
        return this.m_prop.getProperty(BYDAY, null);
    }

    private void loadSchedProperties() throws CommandException {
        InputStream[] inputStreamArray = new InputStream[2];
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        int n = SchedImpl.runProcess(new String[]{this.m_nmzctl, _GET, STATE}, properties, stringBuffer);
        if (n == 0) {
            if (HOLD.equalsIgnoreCase(properties.getProperty(STATE))) {
                this.m_prop.setProperty(STATE, String.valueOf(false));
            } else {
                this.m_prop.setProperty(STATE, String.valueOf(true));
            }
        }
        if (n == 0 && (n = SchedImpl.runProcess(new String[]{this.m_nmzctl, _GET, COLLECTION_INTERVAL}, properties, stringBuffer)) == 0) {
            this.parseCollectionInterval((String)((Hashtable)properties).get(COLLECTION_INTERVAL));
        }
        if (n != 0) {
            throw new CommandException(stringBuffer.toString());
        }
    }

    private void parseCollectionInterval(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            if (string3.equalsIgnoreCase(FREQ)) {
                int n = 0;
                while (n < SchedFrequency.FREQUENCIES.length) {
                    if (string4.equalsIgnoreCase(SchedFrequency.FREQUENCIES[n])) break;
                    ++n;
                }
                this.m_prop.setProperty(string3, Integer.toString(n));
                continue;
            }
            this.m_prop.setProperty(string3, string4.trim());
        }
    }

    private static int runProcess(String[] stringArray, Properties properties, StringBuffer stringBuffer) {
        int n;
        block9: {
            n = 0;
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(stringArray);
                InputStream inputStream = process.getInputStream();
                InputStream inputStream2 = process.getErrorStream();
                n = process.waitFor();
                if (n == 0) {
                    if (properties != null) {
                        try {
                            properties.load(inputStream);
                        }
                        catch (IOException iOException) {}
                    }
                    break block9;
                }
                if (stringBuffer == null) break block9;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream2);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string);
                        stringBuffer.append('\n');
                    }
                }
                catch (IOException iOException) {}
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(String.valueOf(s_bundle.getMessage(ImplMsgID.PROCESS_ERR, false)) + "\n" + throwable.getMessage());
            }
        }
        return n;
    }

    public void setAutoUpload(boolean bl) {
        this.setProperty(STATE, String.valueOf(bl));
    }

    private int setCollectionInterval(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = this.getFrequency();
        stringBuffer2.append(COLLECTION_INTERVAL);
        stringBuffer2.append('=');
        stringBuffer2.append(FREQ);
        stringBuffer2.append('=');
        stringBuffer2.append(SchedFrequency.FREQUENCIES[n]);
        stringBuffer2.append(';');
        stringBuffer2.append(BYHOUR);
        stringBuffer2.append('=');
        stringBuffer2.append(this.getHour());
        stringBuffer2.append(';');
        stringBuffer2.append(BYMINUTE);
        stringBuffer2.append('=');
        stringBuffer2.append(this.getMinute());
        stringBuffer2.append(';');
        if (n == 1) {
            stringBuffer2.append(BYDAY);
            stringBuffer2.append('=');
            stringBuffer2.append(this.getWeekDay().substring(0, 3));
            stringBuffer2.append(';');
        }
        if (n == 2) {
            stringBuffer2.append(BYMONTHDAY);
            stringBuffer2.append('=');
            stringBuffer2.append(this.getMonthDay());
            stringBuffer2.append(';');
        }
        return SchedImpl.runProcess(new String[]{this.m_nmzctl, _SET, stringBuffer2.toString()}, null, stringBuffer);
    }

    public void setFrequency(int n) {
        this.setProperty(FREQ, Integer.toString(n));
    }

    public void setHour(int n) {
        this.setProperty(BYHOUR, Integer.toString(n));
    }

    public void setMinute(int n) {
        this.setProperty(BYMINUTE, Integer.toString(n));
    }

    public void setMonthDay(String string) {
        this.setProperty(BYMONTHDAY, string);
    }

    private void setProperty(String string, String string2) {
        string2 = string2.trim();
        String string3 = this.m_prop.getProperty(string);
        if (string3 == null || !string3.equals(string2)) {
            this.m_prop.setProperty(string, string2);
            this.m_dirty = true;
        }
    }

    public void setWeekDay(String string) {
        this.setProperty(BYDAY, string);
    }
}

