/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CollectionInputStream
extends InputStream {
    private int m_position = 0;
    private long m_collFileSize = 0L;
    private File m_collectionFile = null;
    private FileInputStream m_fileInputStream = null;
    private StringBuffer m_preamble = null;
    private StringBuffer m_epilogue = null;
    private int m_preambleSize = 0;
    private int m_epilogueSize = 0;

    public CollectionInputStream(File file) {
        this.m_collectionFile = file;
        this.m_collFileSize = this.m_collectionFile.length();
        this.m_preamble = this.constructPreamble();
        this.m_preambleSize = this.m_preamble.length();
        this.m_epilogue = this.constructEpilogue();
        this.m_epilogueSize = this.m_epilogue.length();
        this.m_position = -1;
    }

    public void close() throws IOException {
        block2: {
            try {
                if (this.m_fileInputStream == null) break block2;
                this.m_fileInputStream.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.m_fileInputStream = null;
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.m_fileInputStream = null;
    }

    private StringBuffer constructEpilogue() {
        StringBuffer stringBuffer = new StringBuffer(50);
        return stringBuffer;
    }

    private StringBuffer constructPreamble() {
        String string = "payloadID";
        String string2 = "timestamp";
        String string3 = "supportIdentifier";
        String string4 = "InventoryXML";
        StringBuffer stringBuffer = new StringBuffer(250);
        return stringBuffer;
    }

    public File getCollectionFile() {
        return this.m_collectionFile;
    }

    public int read() throws IOException {
        ++this.m_position;
        if (this.m_position + 1 <= this.m_preambleSize) {
            return this.m_preamble.charAt(this.m_position);
        }
        if (this.m_position + 1 > this.m_preambleSize && (long)(this.m_position + 1) < (long)this.m_preambleSize + this.m_collFileSize) {
            if (this.m_fileInputStream == null) {
                this.m_fileInputStream = new FileInputStream(this.m_collectionFile);
            }
            return this.m_fileInputStream.read();
        }
        int n = (int)((long)this.m_position - ((long)this.m_preambleSize + this.m_collFileSize));
        if (this.m_epilogueSize > 0 && n + 1 <= this.m_epilogueSize) {
            return this.m_epilogue.charAt(n);
        }
        return -1;
    }
}

