/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.TrustedKeystore;
import oracle.sysman.ccr.util.TrustedKeystoreException;
import oracle.sysman.ccr.util.Utils;

public class EncryptionKeysManager {
    public static String OCM_REPEATER_PUBLIC_KEY_CERT_NAME = "ocm_rpt_key";
    private static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$netmgr$EncryptionKeysManager != null ? class$oracle$sysman$ccr$netmgr$EncryptionKeysManager : (class$oracle$sysman$ccr$netmgr$EncryptionKeysManager = EncryptionKeysManager.class$("oracle.sysman.ccr.netmgr.EncryptionKeysManager")));
    private static Map s_instances = new HashMap();
    private KeyStore m_keyStore = null;
    private String m_publicAliasName = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$EncryptionKeysManager;

    private EncryptionKeysManager(String string) {
        try {
            this.m_keyStore = TrustedKeystore.createKeyStore(string);
        }
        catch (TrustedKeystoreException trustedKeystoreException) {
            s_logger.error(trustedKeystoreException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static EncryptionKeysManager getInstanse(String string) {
        EncryptionKeysManager encryptionKeysManager = (EncryptionKeysManager)s_instances.get(string);
        if (encryptionKeysManager == null) {
            Class clazz = class$oracle$sysman$ccr$netmgr$EncryptionKeysManager != null ? class$oracle$sysman$ccr$netmgr$EncryptionKeysManager : (class$oracle$sysman$ccr$netmgr$EncryptionKeysManager = EncryptionKeysManager.class$("oracle.sysman.ccr.netmgr.EncryptionKeysManager"));
            synchronized (clazz) {
                encryptionKeysManager = (EncryptionKeysManager)s_instances.get(string);
                if (encryptionKeysManager == null) {
                    encryptionKeysManager = new EncryptionKeysManager(string);
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug("EncryptionKeysManager created for '" + string + ":\n" + encryptionKeysManager);
                    }
                    s_instances.put(string, encryptionKeysManager);
                }
            }
        }
        return encryptionKeysManager;
    }

    public Key getPrivateKey(String string, String string2) throws KeyStoreException {
        Key key;
        char[] cArray = string2.toCharArray();
        try {
            key = this.m_keyStore.getKey(string, cArray);
            if (key == null) {
                throw new KeyStoreException("Keyname: " + string + " Not found in KeyStore");
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new KeyStoreException("UnrecoverableKeyException, Keyname:" + string + " Not found");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException("NoSuchAlgorithException, Keyname:" + string + " Not found");
        }
        return key;
    }

    public String getPrivateKeyAliasName(X509Certificate x509Certificate) {
        Principal principal = x509Certificate.getIssuerDN();
        String string = principal.getName();
        return Utils.extractCName(string);
    }

    public PublicKey getPublicKey(String string) throws KeyStoreException {
        Certificate certificate = this.m_keyStore.getCertificate(string);
        if (certificate == null) {
            throw new KeyStoreException("Keyname: " + string + " Not found in KeyStore");
        }
        PublicKey publicKey = certificate.getPublicKey();
        return publicKey;
    }

    public synchronized String getPublicKeyAliasName() throws KeyStoreException {
        if (this.m_publicAliasName == null) {
            X509Certificate x509Certificate = this.getPublicKeyCertificate(OCM_REPEATER_PUBLIC_KEY_CERT_NAME);
            if (x509Certificate == null) {
                throw new KeyStoreException("Certicate: " + OCM_REPEATER_PUBLIC_KEY_CERT_NAME + " not found in keystore\n");
            }
            this.m_publicAliasName = this.getPrivateKeyAliasName(x509Certificate);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("PrivateKeyAlias = " + this.m_publicAliasName);
            }
        }
        return this.m_publicAliasName;
    }

    public X509Certificate getPublicKeyCertificate(String string) throws KeyStoreException {
        X509Certificate x509Certificate = (X509Certificate)this.m_keyStore.getCertificate(string);
        if (x509Certificate == null) {
            throw new KeyStoreException("alias: " + string + " Not found in KeyStore");
        }
        return x509Certificate;
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        byte[] byArray = new byte[13];
        byArray[1] = 1;
        byArray[2] = -34;
        byArray[3] = 125;
        byArray[4] = 127;
        byArray[7] = 11;
        byArray[8] = 11;
        byArray[9] = -100;
        byArray[10] = -100;
        byArray[12] = 98;
        byte[] byArray2 = byArray;
        System.out.println("Starting \n");
        try {
            string = "/scratch/glavash/view_storage/glavash_repeat/emll/certificates/livelink/repeaterKS.vfy";
            object = "ccrverify.oracle.com";
            String string2 = "LiveLinkOcmRepeater";
            Key key = EncryptionKeysManager.getInstanse(string).getPrivateKey((String)object, string2);
            if (key != null) {
                System.out.println("got a good key\n");
            }
        }
        catch (KeyStoreException keyStoreException) {
            System.out.println("Exception e:" + keyStoreException);
        }
        string = Utils.toHex(byArray2);
        System.out.println("Array:  { " + string + " }");
        object = Utils.fromHex(string);
        if (((Object)object).length != byArray2.length) {
            System.out.println("Size mismatch arr=" + byArray2.length + ", res=" + ((Object)object).length);
        }
        int n = Math.min(((Object)object).length, byArray2.length);
        int n2 = 0;
        while (n2 < n) {
            if (byArray2[n2] != object[n2]) {
                System.out.println("mismatch [" + n2 + "] - arr=" + byArray2[n2] + ", res=" + (int)object[n2]);
            }
            ++n2;
        }
        System.out.println("Result: { " + Utils.toHex((byte[])object) + " }");
    }
}

