/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.AuthorizationPrompter;
import HTTPClient.CookieModule;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import HTTPClient.https.Handler;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.EndPointAuthHandler;
import oracle.sysman.ccr.netmgr.NetMgrMsgID;
import oracle.sysman.ccr.netmgr.SSLInitializationException;
import oracle.sysman.ccr.util.SecureRandomUtil;
import oracle.sysman.ccr.util.TrustedKeystore;
import oracle.sysman.ccr.util.TrustedKeystoreException;
import oracle.sysman.ccr.util.Utils;
import org.apache.log4j.PropertyConfigurator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class EndPoint {
    protected static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.netmgr.NetMgr");
    public static final String INTERNET_ADDRESS = "http://www.oracle.com";
    public static final String DEFAULT_OCM_SERVICE_ENDPOINT = "https://ccr.oracle.com";
    public static final String PROXY_USER = "http.proxyUser";
    public static final String PROXY_PASSWORD = "http.proxyPassword";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String CCR_PROXY_PSWD_SEED = "ccr.proxypswd.seed";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    public static final int RETCODE_RESOLVEADDR_SUCCESS = 0;
    public static final int RETCODE_RESOLVEADDR_NULL_HOST = 1;
    public static final int RETCODE_RESOLVEADDR_UNKNOWN_HOST = 2;
    public static final int RETCODE_RESOLVEADDR_NOT_ALLOWED = 3;
    public static final int RETCODE_VERIFYPROXY_VALID_SETTINGS = 0;
    public static final int RETCODE_VERIFYPROXY_NO_PROXY_SET = 1;
    public static final int RETCODE_VERIFYPROXY_UNKNOWN_PROXY = 2;
    public static final int RETCODE_VERIFYPROXY_LOOKUP_NOT_ALLOWED = 3;
    public static final int RETCODE_VERIFYPROXY_NO_CONN_THRU_PROXY = 4;
    public static final int RETCODE_TESTSERVICE_SUCCESS = 0;
    public static final int RETCODE_TESTSERVICE_CONN_FAILED = 1;
    public static final int RETCODE_TESTSERVICE_GET_REQ_FAILED = 2;
    public static final int RETCODE_TESTSERVICE_SERVICE_DOWN = 3;
    protected URL m_URL = null;
    protected EndPointAddr m_endPointAddr = null;
    private HTTPConnection m_connection = null;
    static final int HTTP_INTERNAL_ERROR = 500;
    private static boolean s_bSSLInitialized = false;
    private static SecureRandom s_secureRandom = null;
    private static KeyStore s_caKeystore = null;
    private static SSLContext s_sslContext = null;
    private static TrustManager[] s_trustManagers = null;
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$netmgr$EndPoint != null ? class$oracle$sysman$ccr$netmgr$EndPoint : (class$oracle$sysman$ccr$netmgr$EndPoint = EndPoint.class$("oracle.sysman.ccr.netmgr.EndPoint")));
    private static AuthorizationPrompter s_authorizationPrompter = null;
    private static RE s_patternCN = null;
    private static RE s_patternDot = null;
    private static RE s_patternWildcard = null;
    protected static int DEFAULT_CONNECT_TIMEOUT = 0;
    protected static int DEFAULT_READ_TIMEOUT = 0;
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$EndPoint;

    static {
        Security.addProvider(new Provider());
        Security.setProperty("cert.provider.x509v1", "com.sun.security.cert.internal.x509.X509V1CertImpl");
        CookieModule.setCookiePolicyHandler(null);
        try {
            s_patternCN = new RE("^CN=(.*?),\\s*(OU|O|L|S|C)=");
            s_patternDot = new RE("([.])");
            s_patternWildcard = new RE("([*])");
        }
        catch (RESyntaxException rESyntaxException) {}
    }

    public EndPoint(URI uRI) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ProtocolNotSuppException, ParseException, UnknownHostException, IOException {
        this(new EndPointAddr(uRI), new Properties());
    }

    public EndPoint(URI uRI, Properties properties) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ParseException, ProtocolNotSuppException, UnknownHostException, IOException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Creating an endpoint for " + uRI + " with httpProperties: " + properties);
        }
        EndPointAddr endPointAddr = new EndPointAddr(uRI);
        this.initialize(endPointAddr, properties);
    }

    public EndPoint(EndPointAddr endPointAddr) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ProtocolNotSuppException, ParseException, UnknownHostException, IOException {
        this(endPointAddr, new Properties());
    }

    public EndPoint(EndPointAddr endPointAddr, Properties properties) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ParseException, ProtocolNotSuppException, UnknownHostException, IOException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Creating an endpoint for " + endPointAddr.getURI() + " with httpProperties: " + properties);
        }
        this.initialize(endPointAddr, properties);
    }

    private boolean DNequalURLhost(String string, String string2) throws SSLPeerUnverifiedException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Comparing DB host " + string + " with " + string2);
        }
        String string3 = Utils.extractCName(string);
        String string4 = this.escapePeerChars(string3);
        try {
            RE rE = new RE(string4.toLowerCase());
            return rE.match(string2.toLowerCase());
        }
        catch (RESyntaxException rESyntaxException) {
            throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.INVALID_CNAME_CHARS, false, (Object[])new String[]{string3}));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void connect(URL uRL, Properties properties) throws ProtocolNotSuppException, SSLPeerUnverifiedException, IOException {
        this.m_connection = new HTTPConnection(uRL);
        this.setProxyProperties(properties);
        if (this.m_connection.getProtocol().equals(HTTPS_PROTOCOL)) {
            this.m_connection.setSSLSocketFactory(s_sslContext.getSocketFactory());
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("SSL Protocol Initialized - SSL SocketFactory initialized");
            }
        }
        this.preConnect();
        this.m_connection.connect();
        if (this.m_connection.getProtocol().equals(HTTPS_PROTOCOL)) {
            this.verifyConnection();
        }
    }

    public void disconnect() {
        this.m_connection.stop();
    }

    private String escapePeerChars(String string) {
        String string2 = null;
        if (string != null) {
            string2 = s_patternDot.subst(string, "\\.");
            string2 = s_patternWildcard.subst(string2, ".*");
        }
        return string2;
    }

    public HTTPResponse get(String string) throws ModuleException, IOException {
        HTTPResponse hTTPResponse = this.getConnection().Get(string);
        return hTTPResponse;
    }

    public static AuthorizationPrompter getAuthorizationHandler() {
        return s_authorizationPrompter;
    }

    public HTTPConnection getConnection() {
        return this.m_connection;
    }

    URL getConnectionURL() {
        return this.m_URL;
    }

    public boolean getIsRepeater() {
        return this.m_endPointAddr.getIsRepeater();
    }

    private static TrustManager[] getTrustManagers(KeyStore keyStore) throws SSLInitializationException {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTFACTORY_INIT, false), noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTMGR_INIT, false), keyStoreException);
        }
        return trustManagerFactory.getTrustManagers();
    }

    private static KeyStore getTrustedCAKeystore() throws SSLInitializationException {
        try {
            return TrustedKeystore.getInstance();
        }
        catch (TrustedKeystoreException trustedKeystoreException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTEDKEYSTORE_ERR, false), trustedKeystoreException);
        }
    }

    static String getURLParamString(NVPair[] nVPairArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nVPairArray.length) {
            if (nVPairArray[n].getValue() != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("&");
                }
                stringBuffer.append(nVPairArray[n].getName());
                stringBuffer.append("=");
                stringBuffer.append(nVPairArray[n].getValue());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void initialize(EndPointAddr endPointAddr, Properties properties) throws SSLInitializationException, MalformedURLException, ProtocolNotSuppException, SSLPeerUnverifiedException, UnknownHostException, IOException {
        this.m_endPointAddr = endPointAddr;
        this.m_URL = this.registerURLHandlers(endPointAddr.getURI());
        if (this.m_URL.getProtocol().equals(HTTPS_PROTOCOL)) {
            EndPoint.sslInit();
        }
        this.connect(this.m_URL, properties);
    }

    public static boolean isValidScheme(String string) {
        return string.equals(HTTP_PROTOCOL) || string.equals(HTTPS_PROTOCOL);
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
        ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
        ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
        ((Hashtable)properties).put("log4j.rootCategory", "DEBUG, Console");
        PropertyConfigurator.configure(properties);
        System.setProperty("HTTPClient.log.mask", Integer.toString(-1));
        System.setProperty("ocm.keystore_resource", "true");
        Properties properties2 = new Properties();
        String string = System.getProperty(PROXY_HOST);
        if (string != null) {
            ((Hashtable)properties2).put(PROXY_HOST, string);
            string = System.getProperty(PROXY_PORT);
            if (string != null) {
                ((Hashtable)properties2).put(PROXY_PORT, string);
            }
            EndPoint.setAuthorizationHandler(new EndPointAuthHandler(System.getProperty(PROXY_USER), System.getProperty(PROXY_PASSWORD)));
        }
        try {
            new EndPoint(new URI(DEFAULT_OCM_SERVICE_ENDPOINT));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void preConnect() {
    }

    private URL registerURLHandlers(URI uRI) throws MalformedURLException, ProtocolNotSuppException {
        URL uRL = null;
        if (uRI.getScheme().equals(HTTP_PROTOCOL)) {
            uRL = new URL(null, uRI.toExternalForm(), new HTTPClient.http.Handler());
        } else if (uRI.getScheme().equals(HTTPS_PROTOCOL)) {
            uRL = new URL(null, uRI.toExternalForm(), new Handler());
        } else {
            throw new MalformedURLException(s_msgBundle.getMessage(NetMgrMsgID.PROTOCOL_TYPE_UNK, false, (Object[])new String[]{uRI.toExternalForm()}));
        }
        return uRL;
    }

    public void resetProxyProperties() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Connection proxy is: {" + this.m_connection.getProxyHost() + "," + this.m_connection.getProxyPort() + "} and being reset to {null,0}.");
        }
        this.m_connection.setCurrentProxy(null, 0);
    }

    public static int resolveAddr(String string) {
        if (string == null) {
            return 1;
        }
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return 2;
        }
        catch (SecurityException securityException) {
            return 3;
        }
        return 0;
    }

    public static AuthorizationPrompter setAuthorizationHandler(AuthorizationPrompter authorizationPrompter) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("AuthorizationPrompter being set to: " + authorizationPrompter);
        }
        AuthorizationPrompter authorizationPrompter2 = s_authorizationPrompter;
        s_authorizationPrompter = authorizationPrompter;
        DefaultAuthHandler.setAuthorizationPrompter(authorizationPrompter);
        return authorizationPrompter2;
    }

    public static void setDefaultConnectionTimeout(int n) {
        HTTPConnection.setDefaultConnectionTimeout(n);
    }

    private void setProxyProperties(String string, String string2) {
        int n = this.m_connection.getProxyPort();
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        if (string != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Connection proxy is: {" + this.m_connection.getProxyHost() + "," + this.m_connection.getProxyPort() + "} and being set to {" + string + "," + string2 + "}.");
            }
            this.m_connection.setCurrentProxy(string, n);
        } else if (this.m_connection != null && this.m_connection.getProxyHost() == null) {
            this.resetProxyProperties();
        }
    }

    private void setProxyProperties(Properties properties) {
        this.setProxyProperties(properties.getProperty(PROXY_HOST), properties.getProperty(PROXY_PORT));
    }

    static final void sslInit() throws SSLInitializationException {
        if (!s_bSSLInitialized) {
            Class clazz = class$oracle$sysman$ccr$netmgr$EndPoint != null ? class$oracle$sysman$ccr$netmgr$EndPoint : (class$oracle$sysman$ccr$netmgr$EndPoint = EndPoint.class$("oracle.sysman.ccr.netmgr.EndPoint"));
            synchronized (clazz) {
                if (!s_bSSLInitialized) {
                    s_secureRandom = SecureRandomUtil.getSecureRandomInstance();
                    s_caKeystore = EndPoint.getTrustedCAKeystore();
                    s_trustManagers = EndPoint.getTrustManagers(s_caKeystore);
                    try {
                        s_sslContext = SSLContext.getInstance("SSL", new Provider());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLInitializationException("Unable to construct SSLContext", noSuchAlgorithmException);
                    }
                    try {
                        s_sslContext.init(null, s_trustManagers, s_secureRandom);
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new SSLInitializationException("Unable to initialize SSLContext", keyManagementException);
                    }
                    s_bSSLInitialized = true;
                }
            }
        }
    }

    public static int testEndPointServiceConnection(String string, String string2, int n) {
        HTTPConnection hTTPConnection = null;
        try {
            hTTPConnection = new EndPoint(new URI(string)).getConnection();
        }
        catch (Exception exception) {
            return 1;
        }
        hTTPConnection.setCurrentProxy(string2, n);
        try {
            hTTPConnection.connect();
        }
        catch (Exception exception) {
            return 1;
        }
        int n2 = 200;
        try {
            HTTPResponse hTTPResponse = hTTPConnection.Get("/em/upload");
            n2 = hTTPResponse.getStatusCode();
        }
        catch (Exception exception) {
            return 2;
        }
        if (n2 >= 300) {
            return 3;
        }
        return 0;
    }

    private void verifyConnection() throws SSLPeerUnverifiedException {
        SSLSession sSLSession = this.m_connection.getSSLSession();
        if (sSLSession != null) {
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Peer Certificate Chain(" + x509CertificateArray.length + "):");
                int n = 0;
                while (n < x509CertificateArray.length) {
                    s_logger.debug("    " + x509CertificateArray[n]);
                    ++n;
                }
            }
            if (x509CertificateArray.length == 0) {
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_PEER_MISSING, false));
            }
            Principal principal = x509CertificateArray[0].getSubjectDN();
            if (principal == null) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("No principal Cert name");
                }
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_CNAME_ERR, false));
            }
            String string = principal.getName();
            if (string == null) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Certificate DN is null.");
                }
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_PRINCIPAL_ERR, false));
            }
            if (!this.DNequalURLhost(string, this.m_URL.getHost())) {
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_MISMATCH, false));
            }
        } else {
            throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.NOSSL_SESSION, false));
        }
    }

    public static int verifyProxy(String string, String string2, int n) {
        HTTPConnection hTTPConnection = null;
        try {
            hTTPConnection = new EndPoint(new URI(string)).getConnection();
        }
        catch (Exception exception) {
            return 4;
        }
        hTTPConnection.setCurrentProxy(string2, n);
        String string3 = hTTPConnection.getProxyHost();
        if (string3 == null) {
            return 1;
        }
        int n2 = EndPoint.resolveAddr(string3);
        if (n2 != 0) {
            if (n2 == 2) {
                return 2;
            }
            if (n2 == 3) {
                return 3;
            }
        }
        try {
            hTTPConnection.connect();
        }
        catch (Exception exception) {
            return 4;
        }
        return 0;
    }
}

