/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.AuthorizationPrompter;
import HTTPClient.HTTPConnection;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.SystemConsole;
import oracle.sysman.ccr.collector.cmd.CollectionXMLFileParser;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.AuthenticationXMLParse;
import oracle.sysman.ccr.netmgr.CCRProxyAuthorization;
import oracle.sysman.ccr.netmgr.CollectionInputStream;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.HTTPServerException;
import oracle.sysman.ccr.netmgr.NetMgrMsgID;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMHTTPConnection;
import oracle.sysman.ccr.netmgr.OCMHTTPResponse;
import oracle.sysman.ccr.netmgr.OCMRepeaterHTTPResponse;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;
import oracle.sysman.ccr.netmgr.RegistrationXMLParse;
import oracle.sysman.ccr.netmgr.WebsvcResponse;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.SAXException;

public class OCMEndPoint {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$netmgr$EndPoint != null ? class$oracle$sysman$ccr$netmgr$EndPoint : (class$oracle$sysman$ccr$netmgr$EndPoint = OCMEndPoint.class$("oracle.sysman.ccr.netmgr.EndPoint")));
    private static final String UPLOAD_RESPONSE_HEADER_NAME = "EM_UPLOAD_NOTIF_RESPONSE";
    private static final String REGISTRATION_URI = "/emccr/registerUser";
    public static final String UPLOAD_URI = "/em/upload";
    public static final String GETUPDATES_URI = "/emccr/contentServer/getUpgrades";
    public static final String DIAG_START_UPLOAD_URI = "/emdiag/upload";
    public static final String DIAG_RESTART_UPLOAD_URI = "/emdiag/restartUpload";
    public static final String DIAG_CONTINUE_UPLOAD_URI = "/emdiag/continuation";
    private static final String PWD_MASK = "************";
    private long m_collFileSize = 0L;
    private static final String COLLECTOR_PROTOCOL_VER = "10.3.0.0.0";
    private static int DEFAULT_REGISTER_TIMEOUT = 60000;
    public static final String DEFAULT_OCM_SERVICE_ENDPOINT = "https://ccr.oracle.com";
    private static RE s_unknownHostRE = null;
    private static RE s_portOutOfRangeRE = null;
    private EndPoint m_endPoint = null;
    private OCMHTTPConnection m_ocmConnection = null;
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.netmgr.NetMgr");
    private static final MessageFormat s_loggerMsg = new MessageFormat("Oracle Configuration Manager failed to establish a connection to Oracle. Reconfigure using {0}");
    private static final String CONFIG_CCR = "configCCR";
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$EndPoint;

    static {
        HTTPConnection.setDefaultAllowUserInteraction(true);
        AuthorizationPrompter authorizationPrompter = EndPoint.getAuthorizationHandler();
        if (authorizationPrompter == null) {
            EndPoint.setAuthorizationHandler(new CCRProxyAuthorization());
        }
        HTTPConnection.setDefaultTimeout(OCMEndPoint.getReadTimeout());
        HTTPConnection.setDefaultConnectionTimeout(OCMEndPoint.getConnectionTimeout());
        try {
            s_unknownHostRE = new RE("^(.*?)(:.*)?$");
            s_portOutOfRangeRE = new RE("^port out of range:(\\d+)$");
        }
        catch (RESyntaxException rESyntaxException) {}
    }

    public OCMEndPoint(URI uRI) throws NetworkException {
        try {
            this.initialize(uRI, new Properties(), false);
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public OCMEndPoint(URI uRI, Properties properties) throws NetworkException {
        try {
            this.initialize(uRI, properties, false);
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public OCMEndPoint(URI uRI, boolean bl) throws NetworkException {
        try {
            this.initialize(uRI, new Properties(), bl);
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public OCMEndPoint(EndPoint endPoint) throws NetworkException {
        this.m_endPoint = endPoint;
        this.m_ocmConnection = OCMHTTPConnection.createConnection(this.m_endPoint.getConnection(), this.m_endPoint.getIsRepeater());
    }

    public OCMEndPoint(EndPointAddr endPointAddr) throws NetworkException {
        try {
            this.initialize(endPointAddr.getURI(), new Properties(), endPointAddr.getIsRepeater());
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public String authenticateUser(String string, String string2, int n) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "authenticate"), new NVPair("form", "CSI"), new NVPair("X-ORCL-META", string), new NVPair("X-ORCL-CUST", string2), new NVPair("X-ORCL-CTRY", Integer.toString(n)), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("CSI authentication", nVPairArray);
        return this.postAuthenticationRequest(nVPairArray);
    }

    public String authenticateUser(String string, byte[] byArray) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "authenticate"), new NVPair("form", "MLIDPW"), new NVPair("X-ORCL-METAEML", string), new NVPair("X-ORCL-METAPWD", new String(byArray)), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("email authentication", nVPairArray);
        return this.postAuthenticationRequest(nVPairArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void dumpRegistrationNVPairs(String string, NVPair[] nVPairArray) {
        if (s_logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < nVPairArray.length) {
                if (n > 0) {
                    stringBuffer.append("&");
                }
                stringBuffer.append(nVPairArray[n].getName());
                stringBuffer.append("=");
                if (nVPairArray[n].getName().equals("X-ORCL-METAPWD")) {
                    stringBuffer.append(PWD_MASK);
                } else {
                    stringBuffer.append(nVPairArray[n].getValue());
                }
                ++n;
            }
            s_logger.debug("Sending " + string + " request to " + this.m_endPoint.getConnectionURL().toExternalForm());
            s_logger.debug("\tParams = " + stringBuffer.toString());
        }
    }

    HTTPConnection getConnection() {
        if (this.m_endPoint != null) {
            return this.m_endPoint.getConnection();
        }
        return null;
    }

    static int getConnectionTimeout() {
        int n;
        try {
            Config config = UplinkHomeConfig.getInstance();
            n = config.getProperty("ccr.netmgr.timeout.connect", EndPoint.DEFAULT_CONNECT_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = EndPoint.DEFAULT_CONNECT_TIMEOUT;
        }
        return n;
    }

    public InputStream getFile(String string) throws FileNotFoundException, NetworkException {
        try {
            OCMHTTPResponse oCMHTTPResponse = this.getOCMConnection().Get(string);
            int n = oCMHTTPResponse.getStatusCode();
            if (n >= 300) {
                switch (n) {
                    case 404: {
                        throw new FileNotFoundException(s_msgBundle.getMessage(NetMgrMsgID.KIT_NOTFOUND, false, (Object[])new String[]{oCMHTTPResponse.getEffectiveURI().toExternalForm()}));
                    }
                    case 500: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.KIT_DOWNLOAD_ERR, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.KIT_DOWNLOAD_IERR, false, new Object[]{oCMHTTPResponse.getEffectiveURI().toExternalForm(), new Integer(n)}));
            }
            return oCMHTTPResponse.getInputStream();
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError(moduleException), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
    }

    OCMHTTPConnection getOCMConnection() {
        if (this.m_ocmConnection != null) {
            return this.m_ocmConnection;
        }
        return null;
    }

    static int getReadTimeout() {
        int n;
        try {
            Config config = UplinkHomeConfig.getInstance();
            n = config.getProperty("ccr.netmgr.timeout.read", EndPoint.DEFAULT_READ_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = EndPoint.DEFAULT_READ_TIMEOUT;
        }
        return n;
    }

    public String getUpdates(Vector vector, String string, String string2, String string3, String string4, String string5) throws NetworkException {
        String string6 = null;
        try {
            int n;
            Object object;
            Vector<NVPair> vector2 = new Vector<NVPair>();
            vector2.addAll(vector);
            vector2.add(new NVPair("X-ORCL-ORGI", string3));
            vector2.add(new NVPair("X-ORCL-HOST", string));
            vector2.add(new NVPair("X-ORCL-HOME", string2));
            String string7 = System.getProperty("os.name");
            if (string7.startsWith("Windows")) {
                string7 = "Windows";
            }
            vector2.add(new NVPair("X-ORCL-PLAT", string7));
            vector2.add(new NVPair("X-ORCL-CFGHOME", string5));
            vector2.add(new NVPair("X-ORCL-REGKEY", string4));
            vector2.add(new NVPair("X-ORCL-PLVR", System.getProperty("os.version")));
            vector2.add(new NVPair("X-ORCL-ARCH", System.getProperty("os.arch")));
            vector2.add(new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER));
            Object[] objectArray = new NVPair[vector2.size()];
            vector2.copyInto(objectArray);
            if (s_logger.isDebugEnabled()) {
                object = new StringBuffer();
                n = 0;
                while (n < objectArray.length) {
                    if (n > 0) {
                        ((StringBuffer)object).append("&");
                    }
                    ((StringBuffer)object).append(((NVPair)objectArray[n]).getName());
                    ((StringBuffer)object).append("=");
                    ((StringBuffer)object).append(((NVPair)objectArray[n]).getValue());
                    ++n;
                }
                s_logger.debug("Sending getUpdates request to " + this.m_endPoint.getConnectionURL().toExternalForm());
                s_logger.debug("\tParams = " + ((StringBuffer)object).toString());
            }
            if ((n = ((OCMHTTPResponse)(object = this.getOCMConnection().Post(GETUPDATES_URI, (NVPair[])objectArray))).getStatusCode()) >= 300) {
                switch (n) {
                    case 500: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INVENTORY_SEND_FAILURE, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n), ((OCMHTTPResponse)object).getReasonLine(), ((OCMHTTPResponse)object).getText()}));
            }
            string6 = ((OCMHTTPResponse)object).getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Result from the getUpdates() request is: " + string6);
            }
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError(moduleException), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
        catch (ParseException parseException) {}
        return string6;
    }

    private void initialize(URI uRI, Properties properties, boolean bl) throws NetworkException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("OCMEndPoint() : with URI of " + uRI + ", isRepeater of " + bl);
        }
        try {
            EndPointAddr endPointAddr = new EndPointAddr(null, bl, uRI);
            this.m_endPoint = new EndPoint(endPointAddr, properties);
            this.m_ocmConnection = OCMHTTPConnection.createConnection(this.m_endPoint.getConnection(), this.m_endPoint.getIsRepeater());
        }
        catch (MalformedURLException malformedURLException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.URL_FORMAT_ERR, false, (Object[])new String[]{uRI.toExternalForm()}), malformedURLException);
        }
        catch (ProtocolNotSuppException protocolNotSuppException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.PROTOCOL_TYPE_UNK, false, (Object[])new String[]{uRI.toExternalForm()}), protocolNotSuppException);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.CONNECT_ERROR, false), sSLPeerUnverifiedException);
        }
        catch (UnknownHostException unknownHostException) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(unknownHostException);
            }
            String string = unknownHostException.getMessage();
            String string2 = null;
            if (s_unknownHostRE.match(string)) {
                String string3 = s_msgBundle.getMessage(NetMgrMsgID.CCR_ENDPOINT_CONFIG, false);
                String string4 = s_unknownHostRE.getParen(1);
                String string5 = System.getProperty("http.proxyHost");
                if (string5 != null && string4.equalsIgnoreCase(string5)) {
                    string3 = s_msgBundle.getMessage(NetMgrMsgID.CCR_PROXY_CONFIG, false);
                }
                string2 = s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_HOST, false, (Object[])new String[]{string3, string4});
            } else {
                string2 = s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_HOST_UNCATEGORIZED, false, (Object[])new String[]{string});
            }
            throw new NetworkException(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getMessage();
            String string6 = null;
            if (s_portOutOfRangeRE.match(string)) {
                String string7 = System.getProperty("http.proxyPort");
                long l = 80L;
                if (string7 != null) {
                    l = Long.parseLong(string7);
                }
                String string8 = s_msgBundle.getMessage(NetMgrMsgID.CCR_ENDPOINT_CONFIG, false);
                String string9 = s_portOutOfRangeRE.getParen(1);
                long l2 = Long.parseLong(string9);
                if (l2 == l) {
                    string8 = s_msgBundle.getMessage(NetMgrMsgID.CCR_PROXY_CONFIG, false);
                }
                string6 = s_msgBundle.getMessage(NetMgrMsgID.INVALID_PORT, false, new Object[]{string8, new Long(l2)});
            } else {
                string6 = s_msgBundle.getMessage(NetMgrMsgID.ILLEGAL_CONNECT_INFO, false, (Object[])new String[]{string});
            }
            throw new NetworkException(string6);
        }
        catch (IOException iOException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.CONNECT_ERROR, false), iOException);
        }
        catch (ParseException parseException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.URL_FORMAT_ERR, false, (Object[])new String[]{uRI.toExternalForm()}), parseException);
        }
    }

    public static void logConnectFailure() {
        String string = FileSpec.catfile(new String[]{Collector.getOracleHome(), UplinkPath.BIN_PATH, CONFIG_CCR});
        String string2 = s_loggerMsg.format(new String[]{string});
        SystemConsole.logMessage(SystemConsole.LEVEL_WARNING, string2);
    }

    private String postAuthenticationRequest(NVPair[] nVPairArray) throws NetworkException {
        int n;
        Object object;
        try {
            object = UplinkHomeConfig.getInstance();
            n = ((Config)object).getProperty("ccr.netmgr.timeout.register", DEFAULT_REGISTER_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = DEFAULT_REGISTER_TIMEOUT;
        }
        this.getConnection().setTimeout(n);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Authenticating with a read timeout of " + n + "ms.");
        }
        this.getConnection().setConnectionTimeout(OCMEndPoint.getConnectionTimeout());
        object = null;
        try {
            object = this.getOCMConnection().Post(REGISTRATION_URI, nVPairArray);
            int n2 = ((OCMHTTPResponse)object).getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("return code is: " + n2);
            }
            if (n2 >= 300) {
                switch (n2) {
                    case 407: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
                    }
                    case 500: {
                        throw new HTTPServerException(NetMgrMsgID.REGISTRATION_COMMS_ERR, n2);
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n2), ((OCMHTTPResponse)object).getReasonLine(), ((OCMHTTPResponse)object).getText()}));
            }
            String string = ((OCMHTTPResponse)object).getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Result from the authenticateUser() request is: " + string);
            }
            AuthenticationXMLParse authenticationXMLParse = new AuthenticationXMLParse();
            try {
                WebsvcResponse websvcResponse = new WebsvcResponse((OCMHTTPResponse)object, authenticationXMLParse);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Received cipherText of: " + authenticationXMLParse.cipherText());
                }
                switch (websvcResponse.getRequestStatusCode()) {
                    case 1001: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INV_REGISTRATION_CREDS, false));
                    }
                    case 1004: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.BAD_REGISTRATION_PARAMS, false));
                    }
                    case 1002: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_SQLERR, false, (Object[])new String[]{websvcResponse.getRequestResponseMessage()}));
                    }
                    case 1005: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_AUTH_ATTACK, false));
                    }
                    default: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_ERR, false, (Object[])new String[]{new Integer(websvcResponse.getRequestStatusCode()).toString(), websvcResponse.getRequestResponseMessage()}));
                    }
                    case 202: {
                        return authenticationXMLParse.cipherText();
                    }
                }
            }
            catch (SAXException sAXException) {
                throw new NetworkException(sAXException.toString());
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            InputStream inputStream = null;
            try {
                if (object != null && (inputStream = ((OCMHTTPResponse)object).getInputStream()) != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), interruptedIOException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("Bug in authorization handling: server refused the given info")) {
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
            }
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(generalSecurityException.getMessage(), generalSecurityException);
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.LINK_ERR, false));
        }
        catch (ParseException parseException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_RESPONSE_ERR, false), parseException);
        }
    }

    private RegistrationKeyDoc postRegistrationRequest(NVPair[] nVPairArray) throws NetworkException {
        int n;
        Object object;
        String string = "";
        try {
            object = UplinkHomeConfig.getInstance();
            n = ((Config)object).getProperty("ccr.netmgr.timeout.register", DEFAULT_REGISTER_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = DEFAULT_REGISTER_TIMEOUT;
        }
        this.getConnection().setTimeout(n);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Registering with a read timeout of " + n + "ms.");
        }
        this.getConnection().setConnectionTimeout(OCMEndPoint.getConnectionTimeout());
        object = null;
        try {
            object = this.getOCMConnection().Post(REGISTRATION_URI, nVPairArray);
            int n2 = ((OCMHTTPResponse)object).getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("return code is: " + n2);
            }
            if (n2 >= 300) {
                switch (n2) {
                    case 407: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
                    }
                    case 500: {
                        throw new HTTPServerException(NetMgrMsgID.REGISTRATION_COMMS_ERR, n2);
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n2), ((OCMHTTPResponse)object).getReasonLine(), ((OCMHTTPResponse)object).getText()}));
            }
            string = ((OCMHTTPResponse)object).getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Result from the registerUser() request is: " + string);
            }
            RegistrationXMLParse registrationXMLParse = new RegistrationXMLParse();
            try {
                WebsvcResponse websvcResponse = new WebsvcResponse((OCMHTTPResponse)object, registrationXMLParse);
                switch (websvcResponse.getRequestStatusCode()) {
                    case 1001: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INV_REGISTRATION_CREDS, false));
                    }
                    case 1004: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.BAD_REGISTRATION_PARAMS, false));
                    }
                    case 1003: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.DUP_REG_ID, false));
                    }
                    case 1002: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_SQLERR, false, (Object[])new String[]{((OCMHTTPResponse)object).getReasonLine()}));
                    }
                    default: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_ERR, false, (Object[])new String[]{new Integer(websvcResponse.getRequestStatusCode()).toString(), websvcResponse.getRequestResponseMessage()}));
                    }
                    case 202: 
                }
                return registrationXMLParse.getRegistrationDoc();
            }
            catch (SAXException sAXException) {
                throw new NetworkException(sAXException.toString());
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            InputStream inputStream = null;
            try {
                if (object != null && (inputStream = ((OCMHTTPResponse)object).getInputStream()) != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), interruptedIOException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("Bug in authorization handling: server refused the given info")) {
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
            }
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(generalSecurityException.getMessage(), generalSecurityException);
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.LINK_ERR, false));
        }
        catch (ParseException parseException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_RESPONSE_ERR, false), parseException);
        }
    }

    protected void preConnect() {
        if (s_logger.isEnabledFor(Logger.INFO) && this.getConnection().getProxyHost() != null) {
            s_logger.info(NetMgrMsgID.PROXY_CONFIG, new Object[]{this.getConnection().getProxyHost(), new Long(this.getConnection().getProxyPort())});
        }
    }

    public String processRepeaterTestRequest() throws NetworkException {
        String string = "";
        try {
            OCMHTTPResponse oCMHTTPResponse = this.getOCMConnection().Post("EMCCR_TEST_CMD", null);
            int n = oCMHTTPResponse.getStatusCode();
            if (n >= 300) {
                switch (n) {
                    case 500: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REPEATER_UNAVAILABLE_ERR, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n), oCMHTTPResponse.getReasonLine(), oCMHTTPResponse.getText()}));
            }
            if (oCMHTTPResponse instanceof OCMRepeaterHTTPResponse) {
                string = ((OCMRepeaterHTTPResponse)oCMHTTPResponse).getRepeaterMessage();
            }
        }
        catch (Exception exception) {
            throw new NetworkException(exception.getMessage());
        }
        return string;
    }

    private String processSendingError(Exception exception) {
        String string = s_msgBundle.getMessage(NetMgrMsgID.ERROR_SENDING, false, (Object[])new String[]{this.m_endPoint.getConnectionURL().toString(), exception.getMessage()});
        s_logger.error(NetMgrMsgID.INVALID_RESPONSE, new String[]{this.m_endPoint.getConnectionURL().toString(), exception.getMessage()});
        return string;
    }

    public RegistrationKeyDoc registerAnonymous(String string, String string2, String string3, String string4) throws NetworkException {
        String string5 = string4;
        if (string5 == null) {
            string5 = "";
        }
        if (string == null) {
            string = "";
        }
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "ANONYMOUS"), new NVPair("X-ORCL-METAEML", string), new NVPair("X-ORCL-HOST", string2), new NVPair("X-ORCL-HOME", string3), new NVPair("X-ORCL-CFGHOME", string5), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("Anonymous registration", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerAnonymous(String string, String string2, String string3, String string4, String string5) throws NetworkException {
        String string6 = string5;
        if (string6 == null) {
            string6 = "";
        }
        NVPair[] nVPairArray = new NVPair[]{new NVPair("X-ORCL-REGKEY", string), new NVPair("X-ORCL-ORGI", string2), new NVPair("cmd", "register"), new NVPair("form", "ANONYMOUS"), new NVPair("X-ORCL-HOST", string3), new NVPair("X-ORCL-HOME", string4), new NVPair("X-ORCL-CFGHOME", string6), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("Anonymous re-registration", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerUser(String string, String string2, String string3, String string4) throws NetworkException {
        String string5 = string4;
        if (string5 == null) {
            string5 = "";
        }
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "VALIDATED"), new NVPair("X-ORCL-HOST", string2), new NVPair("X-ORCL-HOME", string3), new NVPair("X-ORCL-CFGHOME", string5), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER), new NVPair("X-ORCL-REGCIPHER", string)};
        this.dumpRegistrationNVPairs("Validated RegisterUser", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public void sendContent(File file, String string, String string2, String string3, String string4, String string5) throws NetworkException {
        this.m_collFileSize = file.length();
        if (string5 == null || string5.length() == 0) {
            string5 = "";
        }
        CollectionInputStream collectionInputStream = new CollectionInputStream(file);
        try {
            this.sendContent(collectionInputStream, string, string2, string3, string4, string5);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (collectionInputStream != null) {
                    collectionInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var9_8 = null;
        try {
            if (collectionInputStream != null) {
                collectionInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void sendContent(CollectionInputStream collectionInputStream, String string, String string2, String string3, String string4, String string5) throws NetworkException {
        if (string5 == null) {
            string5 = "";
        }
        NVPair[] nVPairArray = null;
        String string6 = null;
        String string7 = null;
        OCMHTTPResponse oCMHTTPResponse = null;
        try {
            String string8;
            String string9;
            CollectionXMLFileParser collectionXMLFileParser = new CollectionXMLFileParser(collectionInputStream.getCollectionFile());
            nVPairArray = this.setupConfigUploadHeaders(collectionXMLFileParser, string, string2, string3, string4, string5);
            string7 = UPLOAD_URI;
            if (s_logger.isDebugEnabled()) {
                string9 = string7;
                string8 = EndPoint.getURLParamString(nVPairArray);
                if (string8 != null && string8.length() > 0) {
                    string9 = String.valueOf(string7) + "?" + string8;
                }
                s_logger.debug("Sending load request to " + this.m_endPoint.getConnectionURL().toExternalForm());
                s_logger.debug("\tParams = " + string9);
            }
            if ((string6 = (oCMHTTPResponse = this.getOCMConnection().Post(string7, collectionInputStream, this.m_collFileSize, nVPairArray)).getHeader("X-ORCL-EMRS")) != null && !string6.equalsIgnoreCase("SUCCESS")) {
                string9 = s_msgBundle.getMessage(NetMgrMsgID.HANDSHAKE_FAILED, false, new Object[]{this.m_endPoint.getConnectionURL().toString(), string6});
                s_logger.error(NetMgrMsgID.HANDSHAKE_FAILED, new Object[]{this.m_endPoint.getConnectionURL().toString(), string6});
                throw new NetworkException(string9);
            }
            string9 = oCMHTTPResponse.getHeader(UPLOAD_RESPONSE_HEADER_NAME);
            if (string9 == null || !string9.startsWith("SUCCESS")) {
                string8 = null;
                string8 = string9 == null ? oCMHTTPResponse.getReasonLine() : string9;
                String string10 = s_msgBundle.getMessage(NetMgrMsgID.INVALID_RESPONSE, false, new Object[]{this.m_endPoint.getConnectionURL().toString(), string8});
                s_logger.error(NetMgrMsgID.INVALID_RESPONSE, new Object[]{this.m_endPoint.getConnectionURL().toString(), string8});
                throw new NetworkException(string10);
            }
        }
        catch (SAXException sAXException) {
            throw new NetworkException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError(moduleException), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
    }

    public byte[] sendDiagnosticRequest(String string, byte[] byArray, NVPair[] nVPairArray) throws NetworkException {
        String string2 = null;
        string2 = string;
        OCMHTTPResponse oCMHTTPResponse = null;
        try {
            String string3;
            if (s_logger.isDebugEnabled()) {
                String string4 = string2;
                string3 = EndPoint.getURLParamString(nVPairArray);
                if (string3 != null && string3.length() > 0) {
                    string4 = String.valueOf(string2) + "?" + string3;
                }
                s_logger.debug("Sending upload request to diagnostic server. ");
                s_logger.debug("URI: " + string4);
            }
            oCMHTTPResponse = this.getOCMConnection().Post(string2, byArray, nVPairArray);
            int n = oCMHTTPResponse.getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Server response code for diagnostic request:  " + n);
            }
            if (n >= 300) {
                string3 = s_msgBundle.getMessage(NetMgrMsgID.ERROR_SENDING, false, new Object[]{this.m_endPoint.getConnectionURL().toString()});
                NetworkException networkException = new NetworkException(string3);
                s_logger.error(NetMgrMsgID.ERROR_SENDING, new Object[]{this.m_endPoint.getConnectionURL().toString()});
                throw networkException;
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Response received from server: ");
                s_logger.debug(new String(oCMHTTPResponse.getData()));
            }
            return oCMHTTPResponse.getData();
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError(moduleException), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
    }

    private NVPair[] setupConfigUploadHeaders(CollectionXMLFileParser collectionXMLFileParser, String string, String string2, String string3, String string4, String string5) throws NetworkException {
        String string6 = null;
        ArrayList<NVPair> arrayList = new ArrayList<NVPair>();
        string6 = Hostname.getHostname();
        arrayList.add(new NVPair("type", "data"));
        arrayList.add(new NVPair("X-ORCL-EMCV", "4.0.0.0.0"));
        arrayList.add(new NVPair("X-ORCL-EMSV", "4.0.0.0.0"));
        arrayList.add(new NVPair("X-ORCL-EMOV", "4.0.0.0.0"));
        arrayList.add(new NVPair("EMD_URL", "http://" + string6 + "/CCR/"));
        arrayList.add(new NVPair("X-ORCL-EMUR", "http://" + string6 + "/CCR/"));
        arrayList.add(new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER));
        arrayList.add(new NVPair("X-ORCL-HOST", string3));
        arrayList.add(new NVPair("X-ORCL-ORGI", string2));
        arrayList.add(new NVPair("X-ORCL-HOME", string4));
        arrayList.add(new NVPair("X-ORCL-CFGHOME", string5));
        if (collectionXMLFileParser.isProxyTarget()) {
            arrayList.add(new NVPair("X-ORCL-PROXY", new Boolean(collectionXMLFileParser.isProxyTarget()).toString()));
            arrayList.add(new NVPair("X-ORCL-PHOST", collectionXMLFileParser.getProxyHost()));
            arrayList.add(new NVPair("X-ORCL-PHOME", collectionXMLFileParser.getProxyHome()));
            arrayList.add(new NVPair("X-ORCL-PCFGHOME", collectionXMLFileParser.getProxyCfgHome()));
        }
        if (string != null) {
            arrayList.add(new NVPair("X-ORCL-EMAK", string));
        }
        NVPair[] nVPairArray = new NVPair[arrayList.size()];
        arrayList.toArray(nVPairArray);
        return nVPairArray;
    }
}

