/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.PublicKey;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.CollectionInputStream;
import oracle.sysman.ccr.netmgr.EncryptionKeysManager;
import oracle.sysman.ccr.netmgr.MessageEnvelopeHandler;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMHTTPConnection;
import oracle.sysman.ccr.netmgr.OCMHTTPResponse;
import oracle.sysman.ccr.netmgr.OCMTunnelCommon;
import oracle.sysman.ccr.util.Utils;

public class OCMRepeaterHTTPConnection
extends OCMHTTPConnection {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$netmgr$OCMHTTPConnection != null ? class$oracle$sysman$ccr$netmgr$OCMHTTPConnection : (class$oracle$sysman$ccr$netmgr$OCMHTTPConnection = OCMRepeaterHTTPConnection.class$("oracle.sysman.ccr.netmgr.OCMHTTPConnection")));
    private static String REPEATER_URI = "/ocmrepeater/";
    private byte[] m_symKey = null;
    private PublicKey m_asymmKey = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$OCMHTTPConnection;

    public OCMRepeaterHTTPConnection(HTTPConnection hTTPConnection) {
        super(hTTPConnection);
    }

    public OCMHTTPResponse Get(String string) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        NVPair[] nVPairArray = this.createRepeaterParams(string);
        return OCMHTTPResponse.createResponse(this.m_connection.Get(REPEATER_URI, (NVPair[])null, nVPairArray), 2, null);
    }

    public OCMHTTPResponse Post(String string, CollectionInputStream collectionInputStream, long l, NVPair[] nVPairArray) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        NVPair[] nVPairArray2 = this.createRepeaterParams(string);
        HttpOutputStream httpOutputStream = new HttpOutputStream();
        try {
            HTTPResponse hTTPResponse = this.m_connection.Post(REPEATER_URI, httpOutputStream, nVPairArray2);
            byte[] byArray = this.getSymmetricKey();
            MessageEnvelopeHandler.writeEnvelope(collectionInputStream, httpOutputStream, nVPairArray, byArray);
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                try {
                    httpOutputStream.flush();
                }
                catch (IOException iOException) {}
            }
            finally {
                Object v1 = null;
            }
        }
        Object var11_9 = null;
        try {
            try {
                httpOutputStream.flush();
            }
            catch (IOException iOException) {}
        }
        finally {
            Object v3 = null;
        }
    }

    public OCMHTTPResponse Post(String string, byte[] byArray, NVPair[] nVPairArray) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        NVPair[] nVPairArray2 = this.createRepeaterParams(string);
        byte[] byArray2 = this.getSymmetricKey();
        return OCMHTTPResponse.createResponse(this.m_connection.Post(REPEATER_URI, MessageEnvelopeHandler.createEnvelope(byArray, nVPairArray, byArray2), nVPairArray2), 1, byArray2);
    }

    public OCMHTTPResponse Post(String string, NVPair[] nVPairArray) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        NVPair[] nVPairArray2 = this.createRepeaterParams(string);
        byte[] byArray = this.getSymmetricKey();
        return OCMHTTPResponse.createResponse(this.m_connection.Post(REPEATER_URI, MessageEnvelopeHandler.createEnvelope(nVPairArray, byArray), nVPairArray2), 1, byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private NVPair[] createRepeaterParams(String string) throws NetworkException {
        String string2;
        byte[] byArray = null;
        PublicKey publicKey = null;
        byte[] byArray2 = null;
        try {
            string2 = EncryptionKeysManager.getInstanse(null).getPublicKeyAliasName();
        }
        catch (KeyStoreException keyStoreException) {
            throw new NetworkException("Failed to get PublicKey Alias" + keyStoreException.getMessage());
        }
        try {
            byArray = this.getSymmetricKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException("Failed to get Symmetric Key " + generalSecurityException.getMessage());
        }
        try {
            publicKey = this.getAsymmetricKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException("Failed to get ASymmetric Key" + generalSecurityException.getMessage());
        }
        try {
            byArray2 = OCMTunnelCommon.encryptAsymmetric(byArray, publicKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException("Failed to get Encrypt symmetric Key" + generalSecurityException.getMessage());
        }
        if (s_logger.isDebugEnabled() && byArray2 != null) {
            s_logger.debug("encrypted sessionid length= " + byArray2.length);
        }
        if (byArray2 == null) {
            throw new NetworkException("encryptAssymetric failed to return valid result");
        }
        String string3 = Utils.toHex(byArray2);
        return new NVPair[]{new NVPair("X-ORCL-APPURL", string), new NVPair("X-ORCL-KEYNAME", string2), new NVPair("X-ORCL-OCMSID", string3)};
    }

    private PublicKey getAsymmetricKey() throws GeneralSecurityException {
        if (this.m_asymmKey == null) {
            OCMRepeaterHTTPConnection oCMRepeaterHTTPConnection = this;
            synchronized (oCMRepeaterHTTPConnection) {
                if (this.m_asymmKey == null) {
                    this.m_asymmKey = EncryptionKeysManager.getInstanse(null).getPublicKey(EncryptionKeysManager.OCM_REPEATER_PUBLIC_KEY_CERT_NAME);
                }
            }
        }
        return this.m_asymmKey;
    }

    private byte[] getSymmetricKey() throws GeneralSecurityException {
        if (this.m_symKey == null) {
            OCMRepeaterHTTPConnection oCMRepeaterHTTPConnection = this;
            synchronized (oCMRepeaterHTTPConnection) {
                if (this.m_symKey == null) {
                    this.m_symKey = OCMTunnelCommon.generateSymmetricKey();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug("Symmetric key is: " + Utils.toHex(this.m_symKey));
                    }
                }
            }
        }
        return this.m_symKey;
    }
}

