/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.OCMHTTPResponse;
import oracle.sysman.ccr.netmgr.OCMTunnelCommon;
import oracle.sysman.ccr.util.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class OCMRepeaterHTTPResponse
extends OCMHTTPResponse {
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$netmgr$OCMRepeaterHTTPResponse != null ? class$oracle$sysman$ccr$netmgr$OCMRepeaterHTTPResponse : (class$oracle$sysman$ccr$netmgr$OCMRepeaterHTTPResponse = OCMRepeaterHTTPResponse.class$("oracle.sysman.ccr.netmgr.OCMRepeaterHTTPResponse")));
    private static final int OCMR_BASE_ERROR_CODE = 900;
    private int m_ccrStatusCode;
    private int m_ocmrStatusCode;
    private int m_statusCode;
    private String m_reasonLine;
    private String m_message;
    private byte[] m_data;
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$OCMRepeaterHTTPResponse;

    protected OCMRepeaterHTTPResponse(HTTPResponse hTTPResponse, byte[] byArray) throws IOException, ModuleException, GeneralSecurityException {
        block12: {
            super(hTTPResponse);
            this.m_ccrStatusCode = 0;
            this.m_ocmrStatusCode = 0;
            this.m_statusCode = 0;
            this.m_reasonLine = null;
            this.m_message = null;
            this.m_data = null;
            this.m_statusCode = hTTPResponse.getStatusCode();
            this.m_reasonLine = hTTPResponse.getReasonLine();
            if (s_log.isDebugEnabled()) {
                s_log.debug("Repeater status=" + this.m_statusCode + " {" + this.m_reasonLine + "}");
            }
            try {
                new OCMHTTPResponseXMLParser();
                if (this.m_data != null && this.m_data.length > 0) {
                    String string = new String(this.m_data);
                    if (Character.isLetterOrDigit(string.charAt(0))) {
                        this.m_data = Utils.fromHex(string);
                        byte[] byArray2 = OCMTunnelCommon.decryptSymmetric(this.m_data, byArray);
                        if (s_log.isDebugEnabled()) {
                            s_log.debug("decrypt data: '" + new String(byArray2) + "'");
                        }
                        this.m_data = byArray2;
                    } else {
                        this.m_data = string.getBytes();
                        if (s_log.isDebugEnabled()) {
                            s_log.debug("clear text data: '" + string + "'");
                        }
                    }
                }
            }
            catch (SAXException sAXException) {
                if (!s_log.isDebugEnabled()) break block12;
                s_log.debug("Error parsing HTTPResponse.");
                StringWriter stringWriter = new StringWriter();
                sAXException.printStackTrace(new PrintWriter(stringWriter));
                s_log.debug(stringWriter.toString());
            }
        }
        if (this.m_statusCode < 300) {
            if (this.m_ocmrStatusCode == 0) {
                this.m_statusCode = this.m_ccrStatusCode;
                if (this.m_ccrStatusCode >= 300 && this.m_data != null) {
                    this.m_reasonLine = new String(this.m_data);
                }
            } else {
                this.m_statusCode = 900 + this.m_ocmrStatusCode;
                this.m_reasonLine = this.m_message;
            }
        }
    }

    static /* synthetic */ String access$5(OCMRepeaterHTTPResponse oCMRepeaterHTTPResponse) {
        return oCMRepeaterHTTPResponse.m_message;
    }

    static /* synthetic */ byte[] access$7(OCMRepeaterHTTPResponse oCMRepeaterHTTPResponse) {
        return oCMRepeaterHTTPResponse.m_data;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] getData() throws IOException, ModuleException {
        return this.m_data;
    }

    protected InputStream getInputStream() throws IOException, ModuleException {
        return new ByteArrayInputStream(this.m_data);
    }

    protected String getReasonLine() {
        return this.m_reasonLine;
    }

    protected String getRepeaterMessage() {
        return this.m_message;
    }

    protected int getStatusCode() {
        return this.m_statusCode;
    }

    protected String getText() throws IOException, ModuleException, ParseException {
        return new String(this.m_data);
    }

    private class OCMHTTPResponseXMLParser
    extends DefaultHandler {
        private StringBuffer im_buffer = null;

        public OCMHTTPResponseXMLParser() throws SAXException {
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                xMLReader.setContentHandler(this);
                InputStream inputStream = OCMRepeaterHTTPResponse.this.m_response.getInputStream();
                InputSource inputSource = new InputSource(inputStream);
                xMLReader.parse(inputSource);
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.toString());
            }
            catch (ModuleException moduleException) {
                throw new SAXException(moduleException.toString());
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.im_buffer != null) {
                this.im_buffer.append(cArray, n, n2);
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equalsIgnoreCase("Service_Response_Message")) {
                if (this.im_buffer != null) {
                    OCMRepeaterHTTPResponse.this.m_message = this.im_buffer.toString();
                    this.im_buffer = null;
                }
            } else if (string3.equalsIgnoreCase("Service_Response_Body") && this.im_buffer != null) {
                OCMRepeaterHTTPResponse.this.m_data = this.im_buffer.toString().getBytes();
                this.im_buffer = null;
            }
        }

        public void startDocument() throws SAXException {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equalsIgnoreCase("Service_Response_Code")) {
                try {
                    OCMRepeaterHTTPResponse.this.m_ccrStatusCode = Integer.parseInt(attributes.getValue("CCR_CODE"));
                    OCMRepeaterHTTPResponse.this.m_ocmrStatusCode = Integer.parseInt(attributes.getValue("OCMR_CODE"));
                    if (!s_log.isDebugEnabled()) return;
                    s_log.debug("Parsed status=" + OCMRepeaterHTTPResponse.this.m_ccrStatusCode + ", OCMR=" + OCMRepeaterHTTPResponse.this.m_ocmrStatusCode);
                    return;
                }
                catch (Exception exception) {
                    throw new SAXException(exception.toString());
                }
            } else {
                if (!string3.equalsIgnoreCase("Service_Response_Message") && !string3.equalsIgnoreCase("Service_Response_Body")) return;
                this.im_buffer = new StringBuffer();
            }
        }
    }
}

