/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.CryptoHandler;
import oracle.sysman.ccr.netmgr.JCEInitializationException;
import oracle.sysman.ccr.util.Utils;
import org.apache.log4j.PropertyConfigurator;

public class OCMTunnelCommon {
    private static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$netmgr$OCMTunnelCommon != null ? class$oracle$sysman$ccr$netmgr$OCMTunnelCommon : (class$oracle$sysman$ccr$netmgr$OCMTunnelCommon = OCMTunnelCommon.class$("oracle.sysman.ccr.netmgr.OCMTunnelCommon")));
    private static String OCMCRYPTO_CLASS = "oracle.sysman.ccr.security.OCMCrypto";
    private static Class s_crypto_class = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$OCMTunnelCommon;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static byte[] decryptAsymmetric(byte[] byArray, PrivateKey privateKey) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        return cryptoHandler.privateDecrypt(byArray, privateKey);
    }

    public static byte[] decryptSymmetric(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        cryptoHandler.setSymmetricKey(byArray2);
        return cryptoHandler.decrypt(byArray);
    }

    public static byte[] encryptAsymmetric(byte[] byArray, PublicKey publicKey) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        return cryptoHandler.publicEncrypt(byArray, publicKey);
    }

    public static byte[] encryptSymmetric(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        cryptoHandler.setSymmetricKey(byArray2);
        return cryptoHandler.encrypt(byArray);
    }

    public static byte[] generateSymmetricKey() throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        if (cryptoHandler == null) {
            throw new GeneralSecurityException("Failed to get dynamic crypto object");
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("OCMTunnelCommon: generating a sym key\n");
        }
        cryptoHandler.generateSymmetricKey();
        return cryptoHandler.getIvAndKey();
    }

    public static InputStream getCipherInputStream(InputStream inputStream, byte[] byArray) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        cryptoHandler.setSymmetricKey(byArray);
        return cryptoHandler.getCipherInputStream(inputStream);
    }

    private static CryptoHandler getCryptoObject() {
        CryptoHandler cryptoHandler = null;
        if (s_crypto_class == null) {
            Class clazz = class$oracle$sysman$ccr$netmgr$OCMTunnelCommon != null ? class$oracle$sysman$ccr$netmgr$OCMTunnelCommon : (class$oracle$sysman$ccr$netmgr$OCMTunnelCommon = OCMTunnelCommon.class$("oracle.sysman.ccr.netmgr.OCMTunnelCommon"));
            synchronized (clazz) {
                if (s_crypto_class == null) {
                    try {
                        s_crypto_class = Class.forName(OCMCRYPTO_CLASS);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        s_crypto_class = null;
                        throw new JCEInitializationException("Class " + OCMCRYPTO_CLASS + "Never loaded");
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        s_crypto_class = null;
                        throw new JCEInitializationException("\nSupporting JDK does not contain required JCE support\nRepeater can not be used with the JDK version in use.");
                    }
                }
            }
        }
        try {
            cryptoHandler = (CryptoHandler)s_crypto_class.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JCEInitializationException("Unable to instantiate the " + OCMCRYPTO_CLASS + " class" + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JCEInitializationException(illegalAccessException.toString());
        }
        return cryptoHandler;
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
            ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
            ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
            ((Hashtable)properties).put("log4j.rootCategory", "DEBUG, Console");
            PropertyConfigurator.configure(properties);
            String string = "This is a test message";
            System.out.println("Message = '" + string + "'");
            byte[] byArray = OCMTunnelCommon.generateSymmetricKey();
            System.out.println("Key = '" + Utils.toHex(byArray) + "'");
            byte[] byArray2 = OCMTunnelCommon.encryptSymmetric(string.getBytes(), byArray);
            System.out.println("Encrypted = '" + Utils.toHex(byArray2) + "'");
            String string2 = new String(OCMTunnelCommon.decryptSymmetric(byArray2, byArray));
            System.out.println("Decrypted = '" + string2 + "'");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

